@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin

import com.pulumi.alicloud.ros.TemplateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a ROS Template resource.
 * For information about ROS Template and how to use it, see [What is Template](https://www.alibabacloud.com/help/en/doc-detail/141851.htm).
 * > **NOTE:** Available in v1.108.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.ros.Template("example", {
 *     templateName: "example_value",
 *     templateBody: `    {
 *     \x09"ROSTemplateFormatVersion": "2015-09-01"
 *     }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.ros.Template("example",
 *     template_name="example_value",
 *     template_body="""    {
 *     \x09"ROSTemplateFormatVersion": "2015-09-01"
 *     }
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Ros.Template("example", new()
 *     {
 *         TemplateName = "example_value",
 *         TemplateBody = @"    {
 *     	""ROSTemplateFormatVersion"": ""2015-09-01""
 *     }
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ros"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ros.NewTemplate(ctx, "example", &ros.TemplateArgs{
 * 			TemplateName: pulumi.String("example_value"),
 * 			TemplateBody: pulumi.String("    {\n    	\"ROSTemplateFormatVersion\": \"2015-09-01\"\n    }\n"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ros.Template;
 * import com.pulumi.alicloud.ros.TemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Template("example", TemplateArgs.builder()
 *             .templateName("example_value")
 *             .templateBody("""
 *     {
 *     	"ROSTemplateFormatVersion": "2015-09-01"
 *     }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:ros:Template
 *     properties:
 *       templateName: example_value
 *       templateBody: |2
 *             {
 *             	"ROSTemplateFormatVersion": "2015-09-01"
 *             }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ROS Template can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ros/template:Template example <template_id>
 * ```
 * @property description The description of the template. The description can be up to 256 characters in length.
 * @property tags A mapping of tags to assign to the resource.
 * @property templateBody The structure that contains the template body. The template body must be 1 to 524,288 bytes in length.  If the length of the template body is longer than required, we recommend that you add parameters to the HTTP POST request body to avoid request failures due to excessive length of URLs.  You must specify one of the TemplateBody and TemplateURL parameters, but you cannot specify both of them.
 * @property templateName The name of the template. The name can be up to 255 characters in length and can contain digits, letters, hyphens (-), and underscores (_). It must start with a digit or letter.
 * @property templateUrl The template url.
 */
public data class TemplateArgs(
    public val description: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val templateBody: Output<String>? = null,
    public val templateName: Output<String>? = null,
    public val templateUrl: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ros.TemplateArgs> {
    override fun toJava(): com.pulumi.alicloud.ros.TemplateArgs =
        com.pulumi.alicloud.ros.TemplateArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .templateBody(templateBody?.applyValue({ args0 -> args0 }))
            .templateName(templateName?.applyValue({ args0 -> args0 }))
            .templateUrl(templateUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TemplateArgs].
 */
@PulumiTagMarker
public class TemplateArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var templateBody: Output<String>? = null

    private var templateName: Output<String>? = null

    private var templateUrl: Output<String>? = null

    /**
     * @param value The description of the template. The description can be up to 256 characters in length.
     */
    @JvmName("bvkhynjqpnmpdarw")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("kspkdbgnqesqdidx")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The structure that contains the template body. The template body must be 1 to 524,288 bytes in length.  If the length of the template body is longer than required, we recommend that you add parameters to the HTTP POST request body to avoid request failures due to excessive length of URLs.  You must specify one of the TemplateBody and TemplateURL parameters, but you cannot specify both of them.
     */
    @JvmName("klwxxbgjnxylvgec")
    public suspend fun templateBody(`value`: Output<String>) {
        this.templateBody = value
    }

    /**
     * @param value The name of the template. The name can be up to 255 characters in length and can contain digits, letters, hyphens (-), and underscores (_). It must start with a digit or letter.
     */
    @JvmName("cbiegactlbxoharl")
    public suspend fun templateName(`value`: Output<String>) {
        this.templateName = value
    }

    /**
     * @param value The template url.
     */
    @JvmName("ljbmvixmsevtekhq")
    public suspend fun templateUrl(`value`: Output<String>) {
        this.templateUrl = value
    }

    /**
     * @param value The description of the template. The description can be up to 256 characters in length.
     */
    @JvmName("wyowneiqyloyrotj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("sqwonwactbipvsnv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("hjifvfkrlkkonxga")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The structure that contains the template body. The template body must be 1 to 524,288 bytes in length.  If the length of the template body is longer than required, we recommend that you add parameters to the HTTP POST request body to avoid request failures due to excessive length of URLs.  You must specify one of the TemplateBody and TemplateURL parameters, but you cannot specify both of them.
     */
    @JvmName("ylwuopfafbuxfkfh")
    public suspend fun templateBody(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateBody = mapped
    }

    /**
     * @param value The name of the template. The name can be up to 255 characters in length and can contain digits, letters, hyphens (-), and underscores (_). It must start with a digit or letter.
     */
    @JvmName("wklqcmuwvrxuqpdn")
    public suspend fun templateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateName = mapped
    }

    /**
     * @param value The template url.
     */
    @JvmName("gihvssovfqmvlggm")
    public suspend fun templateUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateUrl = mapped
    }

    internal fun build(): TemplateArgs = TemplateArgs(
        description = description,
        tags = tags,
        templateBody = templateBody,
        templateName = templateName,
        templateUrl = templateUrl,
    )
}
