@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin

import com.pulumi.alicloud.ros.kotlin.outputs.TemplateScratchPreferenceParameter
import com.pulumi.alicloud.ros.kotlin.outputs.TemplateScratchSourceResource
import com.pulumi.alicloud.ros.kotlin.outputs.TemplateScratchSourceResourceGroup
import com.pulumi.alicloud.ros.kotlin.outputs.TemplateScratchSourceTag
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.ros.kotlin.outputs.TemplateScratchPreferenceParameter.Companion.toKotlin as templateScratchPreferenceParameterToKotlin
import com.pulumi.alicloud.ros.kotlin.outputs.TemplateScratchSourceResource.Companion.toKotlin as templateScratchSourceResourceToKotlin
import com.pulumi.alicloud.ros.kotlin.outputs.TemplateScratchSourceResourceGroup.Companion.toKotlin as templateScratchSourceResourceGroupToKotlin
import com.pulumi.alicloud.ros.kotlin.outputs.TemplateScratchSourceTag.Companion.toKotlin as templateScratchSourceTagToKotlin

/**
 * Builder for [TemplateScratch].
 */
@PulumiTagMarker
public class TemplateScratchResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TemplateScratchArgs = TemplateScratchArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TemplateScratchArgsBuilder.() -> Unit) {
        val builder = TemplateScratchArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TemplateScratch {
        val builtJavaResource = com.pulumi.alicloud.ros.TemplateScratch(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TemplateScratch(builtJavaResource)
    }
}

/**
 * Provides a ROS Template Scratch resource.
 * For information about ROS Template Scratch and how to use it, see [What is Template Scratch](https://www.alibabacloud.com/help/zh/doc-detail/352074.html).
 * > **NOTE:** Available in v1.151.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const example = new alicloud.ros.TemplateScratch("example", {
 *     description: "tf_testacc",
 *     templateScratchType: "ResourceImport",
 *     preferenceParameters: [{
 *         parameterKey: "DeletionPolicy",
 *         parameterValue: "Retain",
 *     }],
 *     sourceResourceGroup: {
 *         resourceGroupId: _default.then(_default => _default.ids?.[0]),
 *         resourceTypeFilters: ["ALIYUN::ECS::VPC"],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.resourcemanager.get_resource_groups()
 * example = alicloud.ros.TemplateScratch("example",
 *     description="tf_testacc",
 *     template_scratch_type="ResourceImport",
 *     preference_parameters=[{
 *         "parameter_key": "DeletionPolicy",
 *         "parameter_value": "Retain",
 *     }],
 *     source_resource_group={
 *         "resource_group_id": default.ids[0],
 *         "resource_type_filters": ["ALIYUN::ECS::VPC"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var example = new AliCloud.Ros.TemplateScratch("example", new()
 *     {
 *         Description = "tf_testacc",
 *         TemplateScratchType = "ResourceImport",
 *         PreferenceParameters = new[]
 *         {
 *             new AliCloud.Ros.Inputs.TemplateScratchPreferenceParameterArgs
 *             {
 *                 ParameterKey = "DeletionPolicy",
 *                 ParameterValue = "Retain",
 *             },
 *         },
 *         SourceResourceGroup = new AliCloud.Ros.Inputs.TemplateScratchSourceResourceGroupArgs
 *         {
 *             ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Ids[0])),
 *             ResourceTypeFilters = new[]
 *             {
 *                 "ALIYUN::ECS::VPC",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ros"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ros.NewTemplateScratch(ctx, "example", &ros.TemplateScratchArgs{
 * 			Description:         pulumi.String("tf_testacc"),
 * 			TemplateScratchType: pulumi.String("ResourceImport"),
 * 			PreferenceParameters: ros.TemplateScratchPreferenceParameterArray{
 * 				&ros.TemplateScratchPreferenceParameterArgs{
 * 					ParameterKey:   pulumi.String("DeletionPolicy"),
 * 					ParameterValue: pulumi.String("Retain"),
 * 				},
 * 			},
 * 			SourceResourceGroup: &ros.TemplateScratchSourceResourceGroupArgs{
 * 				ResourceGroupId: pulumi.String(_default.Ids[0]),
 * 				ResourceTypeFilters: pulumi.StringArray{
 * 					pulumi.String("ALIYUN::ECS::VPC"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.ros.TemplateScratch;
 * import com.pulumi.alicloud.ros.TemplateScratchArgs;
 * import com.pulumi.alicloud.ros.inputs.TemplateScratchPreferenceParameterArgs;
 * import com.pulumi.alicloud.ros.inputs.TemplateScratchSourceResourceGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = ResourcemanagerFunctions.getResourceGroups();
 *         var example = new TemplateScratch("example", TemplateScratchArgs.builder()
 *             .description("tf_testacc")
 *             .templateScratchType("ResourceImport")
 *             .preferenceParameters(TemplateScratchPreferenceParameterArgs.builder()
 *                 .parameterKey("DeletionPolicy")
 *                 .parameterValue("Retain")
 *                 .build())
 *             .sourceResourceGroup(TemplateScratchSourceResourceGroupArgs.builder()
 *                 .resourceGroupId(default_.ids()[0])
 *                 .resourceTypeFilters("ALIYUN::ECS::VPC")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:ros:TemplateScratch
 *     properties:
 *       description: tf_testacc
 *       templateScratchType: ResourceImport
 *       preferenceParameters:
 *         - parameterKey: DeletionPolicy
 *           parameterValue: Retain
 *       sourceResourceGroup:
 *         resourceGroupId: ${default.ids[0]}
 *         resourceTypeFilters:
 *           - ALIYUN::ECS::VPC
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ROS Template Scratch can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ros/templateScratch:TemplateScratch example <id>
 * ```
 */
public class TemplateScratch internal constructor(
    override val javaResource: com.pulumi.alicloud.ros.TemplateScratch,
) : KotlinCustomResource(javaResource, TemplateScratchMapper) {
    /**
     * The Description of the Template Scratch.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The execution mode. Valid Values: `Async` or `Sync`.
     */
    public val executionMode: Output<String>?
        get() = javaResource.executionMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Logical ID generation strategy. Valid Values: `LongTypePrefixAndIndexSuffix`, `LongTypePrefixAndHashSuffix` and `ShortTypePrefixAndHashSuffix`.
     */
    public val logicalIdStrategy: Output<String>
        get() = javaResource.logicalIdStrategy().applyValue({ args0 -> args0 })

    /**
     * Priority parameter. See the following `Block preference_parameters`.
     */
    public val preferenceParameters: Output<List<TemplateScratchPreferenceParameter>>
        get() = javaResource.preferenceParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> templateScratchPreferenceParameterToKotlin(args0) })
            })
        })

    /**
     * Source resource grouping. See the following `Block source_resource_group`.
     */
    public val sourceResourceGroup: Output<TemplateScratchSourceResourceGroup>?
        get() = javaResource.sourceResourceGroup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> templateScratchSourceResourceGroupToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Source resource. See the following `Block source_resources`.
     */
    public val sourceResources: Output<List<TemplateScratchSourceResource>>?
        get() = javaResource.sourceResources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        templateScratchSourceResourceToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Source tag. See the following `Block source_tag`.
     */
    public val sourceTag: Output<TemplateScratchSourceTag>?
        get() = javaResource.sourceTag().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    templateScratchSourceTagToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The type of the Template scan. Valid Values: `ResourceImport` or `ArchitectureReplication`.
     */
    public val templateScratchType: Output<String>
        get() = javaResource.templateScratchType().applyValue({ args0 -> args0 })
}

public object TemplateScratchMapper : ResourceMapper<TemplateScratch> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ros.TemplateScratch::class == javaResource::class

    override fun map(javaResource: Resource): TemplateScratch = TemplateScratch(
        javaResource as
            com.pulumi.alicloud.ros.TemplateScratch,
    )
}

/**
 * @see [TemplateScratch].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TemplateScratch].
 */
public suspend fun templateScratch(
    name: String,
    block: suspend TemplateScratchResourceBuilder.() -> Unit,
): TemplateScratch {
    val builder = TemplateScratchResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TemplateScratch].
 * @param name The _unique_ name of the resulting resource.
 */
public fun templateScratch(name: String): TemplateScratch {
    val builder = TemplateScratchResourceBuilder()
    builder.name(name)
    return builder.build()
}
