@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin

import com.pulumi.alicloud.ros.TemplateScratchArgs.builder
import com.pulumi.alicloud.ros.kotlin.inputs.TemplateScratchPreferenceParameterArgs
import com.pulumi.alicloud.ros.kotlin.inputs.TemplateScratchPreferenceParameterArgsBuilder
import com.pulumi.alicloud.ros.kotlin.inputs.TemplateScratchSourceResourceArgs
import com.pulumi.alicloud.ros.kotlin.inputs.TemplateScratchSourceResourceArgsBuilder
import com.pulumi.alicloud.ros.kotlin.inputs.TemplateScratchSourceResourceGroupArgs
import com.pulumi.alicloud.ros.kotlin.inputs.TemplateScratchSourceResourceGroupArgsBuilder
import com.pulumi.alicloud.ros.kotlin.inputs.TemplateScratchSourceTagArgs
import com.pulumi.alicloud.ros.kotlin.inputs.TemplateScratchSourceTagArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a ROS Template Scratch resource.
 * For information about ROS Template Scratch and how to use it, see [What is Template Scratch](https://www.alibabacloud.com/help/zh/doc-detail/352074.html).
 * > **NOTE:** Available in v1.151.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const example = new alicloud.ros.TemplateScratch("example", {
 *     description: "tf_testacc",
 *     templateScratchType: "ResourceImport",
 *     preferenceParameters: [{
 *         parameterKey: "DeletionPolicy",
 *         parameterValue: "Retain",
 *     }],
 *     sourceResourceGroup: {
 *         resourceGroupId: _default.then(_default => _default.ids?.[0]),
 *         resourceTypeFilters: ["ALIYUN::ECS::VPC"],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.resourcemanager.get_resource_groups()
 * example = alicloud.ros.TemplateScratch("example",
 *     description="tf_testacc",
 *     template_scratch_type="ResourceImport",
 *     preference_parameters=[{
 *         "parameter_key": "DeletionPolicy",
 *         "parameter_value": "Retain",
 *     }],
 *     source_resource_group={
 *         "resource_group_id": default.ids[0],
 *         "resource_type_filters": ["ALIYUN::ECS::VPC"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var example = new AliCloud.Ros.TemplateScratch("example", new()
 *     {
 *         Description = "tf_testacc",
 *         TemplateScratchType = "ResourceImport",
 *         PreferenceParameters = new[]
 *         {
 *             new AliCloud.Ros.Inputs.TemplateScratchPreferenceParameterArgs
 *             {
 *                 ParameterKey = "DeletionPolicy",
 *                 ParameterValue = "Retain",
 *             },
 *         },
 *         SourceResourceGroup = new AliCloud.Ros.Inputs.TemplateScratchSourceResourceGroupArgs
 *         {
 *             ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Ids[0])),
 *             ResourceTypeFilters = new[]
 *             {
 *                 "ALIYUN::ECS::VPC",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ros"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ros.NewTemplateScratch(ctx, "example", &ros.TemplateScratchArgs{
 * 			Description:         pulumi.String("tf_testacc"),
 * 			TemplateScratchType: pulumi.String("ResourceImport"),
 * 			PreferenceParameters: ros.TemplateScratchPreferenceParameterArray{
 * 				&ros.TemplateScratchPreferenceParameterArgs{
 * 					ParameterKey:   pulumi.String("DeletionPolicy"),
 * 					ParameterValue: pulumi.String("Retain"),
 * 				},
 * 			},
 * 			SourceResourceGroup: &ros.TemplateScratchSourceResourceGroupArgs{
 * 				ResourceGroupId: pulumi.String(_default.Ids[0]),
 * 				ResourceTypeFilters: pulumi.StringArray{
 * 					pulumi.String("ALIYUN::ECS::VPC"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.ros.TemplateScratch;
 * import com.pulumi.alicloud.ros.TemplateScratchArgs;
 * import com.pulumi.alicloud.ros.inputs.TemplateScratchPreferenceParameterArgs;
 * import com.pulumi.alicloud.ros.inputs.TemplateScratchSourceResourceGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = ResourcemanagerFunctions.getResourceGroups();
 *         var example = new TemplateScratch("example", TemplateScratchArgs.builder()
 *             .description("tf_testacc")
 *             .templateScratchType("ResourceImport")
 *             .preferenceParameters(TemplateScratchPreferenceParameterArgs.builder()
 *                 .parameterKey("DeletionPolicy")
 *                 .parameterValue("Retain")
 *                 .build())
 *             .sourceResourceGroup(TemplateScratchSourceResourceGroupArgs.builder()
 *                 .resourceGroupId(default_.ids()[0])
 *                 .resourceTypeFilters("ALIYUN::ECS::VPC")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:ros:TemplateScratch
 *     properties:
 *       description: tf_testacc
 *       templateScratchType: ResourceImport
 *       preferenceParameters:
 *         - parameterKey: DeletionPolicy
 *           parameterValue: Retain
 *       sourceResourceGroup:
 *         resourceGroupId: ${default.ids[0]}
 *         resourceTypeFilters:
 *           - ALIYUN::ECS::VPC
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ROS Template Scratch can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ros/templateScratch:TemplateScratch example <id>
 * ```
 * @property description The Description of the Template Scratch.
 * @property executionMode The execution mode. Valid Values: `Async` or `Sync`.
 * @property logicalIdStrategy Logical ID generation strategy. Valid Values: `LongTypePrefixAndIndexSuffix`, `LongTypePrefixAndHashSuffix` and `ShortTypePrefixAndHashSuffix`.
 * @property preferenceParameters Priority parameter. See the following `Block preference_parameters`.
 * @property sourceResourceGroup Source resource grouping. See the following `Block source_resource_group`.
 * @property sourceResources Source resource. See the following `Block source_resources`.
 * @property sourceTag Source tag. See the following `Block source_tag`.
 * @property templateScratchType The type of the Template scan. Valid Values: `ResourceImport` or `ArchitectureReplication`.
 */
public data class TemplateScratchArgs(
    public val description: Output<String>? = null,
    public val executionMode: Output<String>? = null,
    public val logicalIdStrategy: Output<String>? = null,
    public val preferenceParameters: Output<List<TemplateScratchPreferenceParameterArgs>>? = null,
    public val sourceResourceGroup: Output<TemplateScratchSourceResourceGroupArgs>? = null,
    public val sourceResources: Output<List<TemplateScratchSourceResourceArgs>>? = null,
    public val sourceTag: Output<TemplateScratchSourceTagArgs>? = null,
    public val templateScratchType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ros.TemplateScratchArgs> {
    override fun toJava(): com.pulumi.alicloud.ros.TemplateScratchArgs =
        com.pulumi.alicloud.ros.TemplateScratchArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .executionMode(executionMode?.applyValue({ args0 -> args0 }))
            .logicalIdStrategy(logicalIdStrategy?.applyValue({ args0 -> args0 }))
            .preferenceParameters(
                preferenceParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .sourceResourceGroup(
                sourceResourceGroup?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .sourceResources(
                sourceResources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sourceTag(sourceTag?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .templateScratchType(templateScratchType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TemplateScratchArgs].
 */
@PulumiTagMarker
public class TemplateScratchArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var executionMode: Output<String>? = null

    private var logicalIdStrategy: Output<String>? = null

    private var preferenceParameters: Output<List<TemplateScratchPreferenceParameterArgs>>? = null

    private var sourceResourceGroup: Output<TemplateScratchSourceResourceGroupArgs>? = null

    private var sourceResources: Output<List<TemplateScratchSourceResourceArgs>>? = null

    private var sourceTag: Output<TemplateScratchSourceTagArgs>? = null

    private var templateScratchType: Output<String>? = null

    /**
     * @param value The Description of the Template Scratch.
     */
    @JvmName("wbduuiboofiqlcru")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The execution mode. Valid Values: `Async` or `Sync`.
     */
    @JvmName("whgytpceiklhikob")
    public suspend fun executionMode(`value`: Output<String>) {
        this.executionMode = value
    }

    /**
     * @param value Logical ID generation strategy. Valid Values: `LongTypePrefixAndIndexSuffix`, `LongTypePrefixAndHashSuffix` and `ShortTypePrefixAndHashSuffix`.
     */
    @JvmName("stlepyxxymuoxhkp")
    public suspend fun logicalIdStrategy(`value`: Output<String>) {
        this.logicalIdStrategy = value
    }

    /**
     * @param value Priority parameter. See the following `Block preference_parameters`.
     */
    @JvmName("xayxaffmekcpsjfv")
    public suspend fun preferenceParameters(`value`: Output<List<TemplateScratchPreferenceParameterArgs>>) {
        this.preferenceParameters = value
    }

    @JvmName("ytftjkwtoyowsoit")
    public suspend fun preferenceParameters(vararg values: Output<TemplateScratchPreferenceParameterArgs>) {
        this.preferenceParameters = Output.all(values.asList())
    }

    /**
     * @param values Priority parameter. See the following `Block preference_parameters`.
     */
    @JvmName("uypwpjktimhqasrk")
    public suspend fun preferenceParameters(values: List<Output<TemplateScratchPreferenceParameterArgs>>) {
        this.preferenceParameters = Output.all(values)
    }

    /**
     * @param value Source resource grouping. See the following `Block source_resource_group`.
     */
    @JvmName("ymxrgntfeqnbeful")
    public suspend fun sourceResourceGroup(`value`: Output<TemplateScratchSourceResourceGroupArgs>) {
        this.sourceResourceGroup = value
    }

    /**
     * @param value Source resource. See the following `Block source_resources`.
     */
    @JvmName("wfldmostfsraboiy")
    public suspend fun sourceResources(`value`: Output<List<TemplateScratchSourceResourceArgs>>) {
        this.sourceResources = value
    }

    @JvmName("vmntgwqvgelrlvyj")
    public suspend fun sourceResources(vararg values: Output<TemplateScratchSourceResourceArgs>) {
        this.sourceResources = Output.all(values.asList())
    }

    /**
     * @param values Source resource. See the following `Block source_resources`.
     */
    @JvmName("xnuksdohqyksgykf")
    public suspend fun sourceResources(values: List<Output<TemplateScratchSourceResourceArgs>>) {
        this.sourceResources = Output.all(values)
    }

    /**
     * @param value Source tag. See the following `Block source_tag`.
     */
    @JvmName("pqywrywdsfinqlvk")
    public suspend fun sourceTag(`value`: Output<TemplateScratchSourceTagArgs>) {
        this.sourceTag = value
    }

    /**
     * @param value The type of the Template scan. Valid Values: `ResourceImport` or `ArchitectureReplication`.
     */
    @JvmName("lyvblxixhdtjgnjk")
    public suspend fun templateScratchType(`value`: Output<String>) {
        this.templateScratchType = value
    }

    /**
     * @param value The Description of the Template Scratch.
     */
    @JvmName("ccsptlkdxxavfevw")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The execution mode. Valid Values: `Async` or `Sync`.
     */
    @JvmName("xvpkchnwsejexorq")
    public suspend fun executionMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.executionMode = mapped
    }

    /**
     * @param value Logical ID generation strategy. Valid Values: `LongTypePrefixAndIndexSuffix`, `LongTypePrefixAndHashSuffix` and `ShortTypePrefixAndHashSuffix`.
     */
    @JvmName("gyruryckiyqgbwnn")
    public suspend fun logicalIdStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logicalIdStrategy = mapped
    }

    /**
     * @param value Priority parameter. See the following `Block preference_parameters`.
     */
    @JvmName("knoqukvmamlmfyej")
    public suspend fun preferenceParameters(`value`: List<TemplateScratchPreferenceParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferenceParameters = mapped
    }

    /**
     * @param argument Priority parameter. See the following `Block preference_parameters`.
     */
    @JvmName("vfqydjranudxrspa")
    public suspend fun preferenceParameters(argument: List<suspend TemplateScratchPreferenceParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TemplateScratchPreferenceParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.preferenceParameters = mapped
    }

    /**
     * @param argument Priority parameter. See the following `Block preference_parameters`.
     */
    @JvmName("qcyojqebeakidrcn")
    public suspend fun preferenceParameters(vararg argument: suspend TemplateScratchPreferenceParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TemplateScratchPreferenceParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.preferenceParameters = mapped
    }

    /**
     * @param argument Priority parameter. See the following `Block preference_parameters`.
     */
    @JvmName("rugentquunvvnann")
    public suspend fun preferenceParameters(argument: suspend TemplateScratchPreferenceParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TemplateScratchPreferenceParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.preferenceParameters = mapped
    }

    /**
     * @param values Priority parameter. See the following `Block preference_parameters`.
     */
    @JvmName("pgywidwqwesdtcdk")
    public suspend fun preferenceParameters(vararg values: TemplateScratchPreferenceParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preferenceParameters = mapped
    }

    /**
     * @param value Source resource grouping. See the following `Block source_resource_group`.
     */
    @JvmName("hfekatsuqqbewvik")
    public suspend fun sourceResourceGroup(`value`: TemplateScratchSourceResourceGroupArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceResourceGroup = mapped
    }

    /**
     * @param argument Source resource grouping. See the following `Block source_resource_group`.
     */
    @JvmName("yhyymqgrmypphiqd")
    public suspend fun sourceResourceGroup(argument: suspend TemplateScratchSourceResourceGroupArgsBuilder.() -> Unit) {
        val toBeMapped = TemplateScratchSourceResourceGroupArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sourceResourceGroup = mapped
    }

    /**
     * @param value Source resource. See the following `Block source_resources`.
     */
    @JvmName("dmnsfajcvjxelbwj")
    public suspend fun sourceResources(`value`: List<TemplateScratchSourceResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceResources = mapped
    }

    /**
     * @param argument Source resource. See the following `Block source_resources`.
     */
    @JvmName("fmbyhxtsatdbwpie")
    public suspend fun sourceResources(argument: List<suspend TemplateScratchSourceResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TemplateScratchSourceResourceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sourceResources = mapped
    }

    /**
     * @param argument Source resource. See the following `Block source_resources`.
     */
    @JvmName("ikmtqkoqmhpvwykd")
    public suspend fun sourceResources(vararg argument: suspend TemplateScratchSourceResourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TemplateScratchSourceResourceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sourceResources = mapped
    }

    /**
     * @param argument Source resource. See the following `Block source_resources`.
     */
    @JvmName("adoyctsrsucfarfs")
    public suspend fun sourceResources(argument: suspend TemplateScratchSourceResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TemplateScratchSourceResourceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.sourceResources = mapped
    }

    /**
     * @param values Source resource. See the following `Block source_resources`.
     */
    @JvmName("hkkdhbwtwpdoiwph")
    public suspend fun sourceResources(vararg values: TemplateScratchSourceResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceResources = mapped
    }

    /**
     * @param value Source tag. See the following `Block source_tag`.
     */
    @JvmName("koxakymaofljmtua")
    public suspend fun sourceTag(`value`: TemplateScratchSourceTagArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceTag = mapped
    }

    /**
     * @param argument Source tag. See the following `Block source_tag`.
     */
    @JvmName("xpvworeufrslqubg")
    public suspend fun sourceTag(argument: suspend TemplateScratchSourceTagArgsBuilder.() -> Unit) {
        val toBeMapped = TemplateScratchSourceTagArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceTag = mapped
    }

    /**
     * @param value The type of the Template scan. Valid Values: `ResourceImport` or `ArchitectureReplication`.
     */
    @JvmName("bfijnxaretjkpoiv")
    public suspend fun templateScratchType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateScratchType = mapped
    }

    internal fun build(): TemplateScratchArgs = TemplateScratchArgs(
        description = description,
        executionMode = executionMode,
        logicalIdStrategy = logicalIdStrategy,
        preferenceParameters = preferenceParameters,
        sourceResourceGroup = sourceResourceGroup,
        sourceResources = sourceResources,
        sourceTag = sourceTag,
        templateScratchType = templateScratchType,
    )
}
