@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin.inputs

import com.pulumi.alicloud.ros.inputs.ChangeSetParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property parameterKey The parameter key.
 * @property parameterValue The parameter value.
 */
public data class ChangeSetParameterArgs(
    public val parameterKey: Output<String>,
    public val parameterValue: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.ros.inputs.ChangeSetParameterArgs> {
    override fun toJava(): com.pulumi.alicloud.ros.inputs.ChangeSetParameterArgs =
        com.pulumi.alicloud.ros.inputs.ChangeSetParameterArgs.builder()
            .parameterKey(parameterKey.applyValue({ args0 -> args0 }))
            .parameterValue(parameterValue.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChangeSetParameterArgs].
 */
@PulumiTagMarker
public class ChangeSetParameterArgsBuilder internal constructor() {
    private var parameterKey: Output<String>? = null

    private var parameterValue: Output<String>? = null

    /**
     * @param value The parameter key.
     */
    @JvmName("gawdvdlxrhebmmgm")
    public suspend fun parameterKey(`value`: Output<String>) {
        this.parameterKey = value
    }

    /**
     * @param value The parameter value.
     */
    @JvmName("ushkrrkulgejuauq")
    public suspend fun parameterValue(`value`: Output<String>) {
        this.parameterValue = value
    }

    /**
     * @param value The parameter key.
     */
    @JvmName("oksxnuqirlpekkni")
    public suspend fun parameterKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameterKey = mapped
    }

    /**
     * @param value The parameter value.
     */
    @JvmName("noioihwiftodtqvj")
    public suspend fun parameterValue(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameterValue = mapped
    }

    internal fun build(): ChangeSetParameterArgs = ChangeSetParameterArgs(
        parameterKey = parameterKey ?: throw PulumiNullFieldException("parameterKey"),
        parameterValue = parameterValue ?: throw PulumiNullFieldException("parameterValue"),
    )
}
