@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin.inputs

import com.pulumi.alicloud.ros.inputs.GetRegionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRegions.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetRegionsPlainArgs(
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ros.inputs.GetRegionsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ros.inputs.GetRegionsPlainArgs =
        com.pulumi.alicloud.ros.inputs.GetRegionsPlainArgs.builder()
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRegionsPlainArgs].
 */
@PulumiTagMarker
public class GetRegionsPlainArgsBuilder internal constructor() {
    private var outputFile: String? = null

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("mqkkltgrlxubdcmg")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetRegionsPlainArgs = GetRegionsPlainArgs(
        outputFile = outputFile,
    )
}
