@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin.inputs

import com.pulumi.alicloud.ros.inputs.GetStackGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getStackGroups.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids A list of Stack Group IDs.
 * @property nameRegex A regex string to filter results by Stack Group name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of Stack Group. Valid Values: `ACTIVE`, `DELETED`.
 */
public data class GetStackGroupsPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ros.inputs.GetStackGroupsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ros.inputs.GetStackGroupsPlainArgs =
        com.pulumi.alicloud.ros.inputs.GetStackGroupsPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStackGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetStackGroupsPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("hbhswaotkplegidk")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Stack Group IDs.
     */
    @JvmName("xyqbqjuyuwcdvbpe")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Stack Group IDs.
     */
    @JvmName("xqdxbcfribbdxfqw")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Stack Group name.
     */
    @JvmName("rwvoxubgadeflddg")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("kooqmpygfnexrqrq")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of Stack Group. Valid Values: `ACTIVE`, `DELETED`.
     */
    @JvmName("wmqnddiekyskrjul")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetStackGroupsPlainArgs = GetStackGroupsPlainArgs(
        enableDetails = enableDetails,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
    )
}
