@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin.inputs

import com.pulumi.alicloud.ros.inputs.GetStackInstancesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getStackInstances.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids A list of Stack Instance IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property stackGroupName The name of the stack group.
 * @property stackInstanceAccountId The account to which the stack instance belongs.
 * @property stackInstanceRegionId The region of the stack instance.
 * @property status The status of the stack instance. Valid values: `CURRENT` or `OUTDATED`.
 * * `CURRENT`: The stack corresponding to the stack instance is up to date with the stack group.
 * * `OUTDATED`: The stack corresponding to the stack instance is not up to date with the stack group. The `OUTDATED` state has the following possible causes:
 * * When the CreateStackInstances operation is called to create stack instances, the corresponding stacks fail to be created.
 * * When the UpdateStackInstances or UpdateStackGroup operation is called to update stack instances, the corresponding stacks fail to be updated, or only some of the stack instances are updated.
 * * The create or update operation is not complete.
 */
public data class GetStackInstancesPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val stackGroupName: String,
    public val stackInstanceAccountId: String? = null,
    public val stackInstanceRegionId: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ros.inputs.GetStackInstancesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ros.inputs.GetStackInstancesPlainArgs =
        com.pulumi.alicloud.ros.inputs.GetStackInstancesPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .stackGroupName(stackGroupName.let({ args0 -> args0 }))
            .stackInstanceAccountId(stackInstanceAccountId?.let({ args0 -> args0 }))
            .stackInstanceRegionId(stackInstanceRegionId?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStackInstancesPlainArgs].
 */
@PulumiTagMarker
public class GetStackInstancesPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var stackGroupName: String? = null

    private var stackInstanceAccountId: String? = null

    private var stackInstanceRegionId: String? = null

    private var status: String? = null

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("dvunwqyajfytljia")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Stack Instance IDs.
     */
    @JvmName("qumluwurohwxlivv")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Stack Instance IDs.
     */
    @JvmName("qcdqnwusfagrdniv")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("tsqqguyqwphaignq")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The name of the stack group.
     */
    @JvmName("iuacewbklfulbyvy")
    public suspend fun stackGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.stackGroupName = mapped
    }

    /**
     * @param value The account to which the stack instance belongs.
     */
    @JvmName("wnxirbjppdvghydx")
    public suspend fun stackInstanceAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.stackInstanceAccountId = mapped
    }

    /**
     * @param value The region of the stack instance.
     */
    @JvmName("xqdthhtyupphguls")
    public suspend fun stackInstanceRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.stackInstanceRegionId = mapped
    }

    /**
     * @param value The status of the stack instance. Valid values: `CURRENT` or `OUTDATED`.
     * * `CURRENT`: The stack corresponding to the stack instance is up to date with the stack group.
     * * `OUTDATED`: The stack corresponding to the stack instance is not up to date with the stack group. The `OUTDATED` state has the following possible causes:
     * * When the CreateStackInstances operation is called to create stack instances, the corresponding stacks fail to be created.
     * * When the UpdateStackInstances or UpdateStackGroup operation is called to update stack instances, the corresponding stacks fail to be updated, or only some of the stack instances are updated.
     * * The create or update operation is not complete.
     */
    @JvmName("seqambkmnqhngrkn")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetStackInstancesPlainArgs = GetStackInstancesPlainArgs(
        enableDetails = enableDetails,
        ids = ids,
        outputFile = outputFile,
        stackGroupName = stackGroupName ?: throw PulumiNullFieldException("stackGroupName"),
        stackInstanceAccountId = stackInstanceAccountId,
        stackInstanceRegionId = stackInstanceRegionId,
        status = status,
    )
}
