@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin.inputs

import com.pulumi.alicloud.ros.inputs.GetTemplateScratchesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTemplateScratches.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids A list of Template Scratch IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the resource. Valid Values: `GENERATE_IN_PROGRESS`, `GENERATE_COMPLETE` and `GENERATE_FAILED`.
 * @property templateScratchType The type of the template scratch. Valid Values: `ResourceImport`, `ArchitectureReplication`.
 */
public data class GetTemplateScratchesPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val templateScratchType: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ros.inputs.GetTemplateScratchesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ros.inputs.GetTemplateScratchesPlainArgs =
        com.pulumi.alicloud.ros.inputs.GetTemplateScratchesPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .templateScratchType(templateScratchType?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTemplateScratchesPlainArgs].
 */
@PulumiTagMarker
public class GetTemplateScratchesPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var status: String? = null

    private var templateScratchType: String? = null

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("exxupljwasjukwjw")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Template Scratch IDs.
     */
    @JvmName("ipwqltpxwsxpooiy")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Template Scratch IDs.
     */
    @JvmName("lvxfcgiiysneqrom")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("qvieqfdgkupaeiyu")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the resource. Valid Values: `GENERATE_IN_PROGRESS`, `GENERATE_COMPLETE` and `GENERATE_FAILED`.
     */
    @JvmName("naqtufxevodbssgq")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The type of the template scratch. Valid Values: `ResourceImport`, `ArchitectureReplication`.
     */
    @JvmName("mbbjqnjolwkxouqs")
    public suspend fun templateScratchType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.templateScratchType = mapped
    }

    internal fun build(): GetTemplateScratchesPlainArgs = GetTemplateScratchesPlainArgs(
        enableDetails = enableDetails,
        ids = ids,
        outputFile = outputFile,
        status = status,
        templateScratchType = templateScratchType,
    )
}
