@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin.inputs

import com.pulumi.alicloud.ros.inputs.StackGroupParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property parameterKey The parameter key.
 * @property parameterValue The parameter value.
 */
public data class StackGroupParameterArgs(
    public val parameterKey: Output<String>? = null,
    public val parameterValue: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ros.inputs.StackGroupParameterArgs> {
    override fun toJava(): com.pulumi.alicloud.ros.inputs.StackGroupParameterArgs =
        com.pulumi.alicloud.ros.inputs.StackGroupParameterArgs.builder()
            .parameterKey(parameterKey?.applyValue({ args0 -> args0 }))
            .parameterValue(parameterValue?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StackGroupParameterArgs].
 */
@PulumiTagMarker
public class StackGroupParameterArgsBuilder internal constructor() {
    private var parameterKey: Output<String>? = null

    private var parameterValue: Output<String>? = null

    /**
     * @param value The parameter key.
     */
    @JvmName("fjewtkemthxeccgk")
    public suspend fun parameterKey(`value`: Output<String>) {
        this.parameterKey = value
    }

    /**
     * @param value The parameter value.
     */
    @JvmName("iurnjfsapgcposea")
    public suspend fun parameterValue(`value`: Output<String>) {
        this.parameterValue = value
    }

    /**
     * @param value The parameter key.
     */
    @JvmName("hcyadagmokojuefk")
    public suspend fun parameterKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameterKey = mapped
    }

    /**
     * @param value The parameter value.
     */
    @JvmName("iolguhpcrkyqkonq")
    public suspend fun parameterValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameterValue = mapped
    }

    internal fun build(): StackGroupParameterArgs = StackGroupParameterArgs(
        parameterKey = parameterKey,
        parameterValue = parameterValue,
    )
}
