@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin.inputs

import com.pulumi.alicloud.ros.inputs.StackInstanceParameterOverrideArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property parameterKey The key of override parameter. If you do not specify the key and value of the parameter, ROS uses the key and value that you specified when you created the stack group.
 * @property parameterValue The value of override parameter. If you do not specify the key and value of the parameter, ROS uses the key and value that you specified when you created the stack group.
 */
public data class StackInstanceParameterOverrideArgs(
    public val parameterKey: Output<String>? = null,
    public val parameterValue: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ros.inputs.StackInstanceParameterOverrideArgs> {
    override fun toJava(): com.pulumi.alicloud.ros.inputs.StackInstanceParameterOverrideArgs =
        com.pulumi.alicloud.ros.inputs.StackInstanceParameterOverrideArgs.builder()
            .parameterKey(parameterKey?.applyValue({ args0 -> args0 }))
            .parameterValue(parameterValue?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StackInstanceParameterOverrideArgs].
 */
@PulumiTagMarker
public class StackInstanceParameterOverrideArgsBuilder internal constructor() {
    private var parameterKey: Output<String>? = null

    private var parameterValue: Output<String>? = null

    /**
     * @param value The key of override parameter. If you do not specify the key and value of the parameter, ROS uses the key and value that you specified when you created the stack group.
     */
    @JvmName("yonyjhcmrwoqcxeu")
    public suspend fun parameterKey(`value`: Output<String>) {
        this.parameterKey = value
    }

    /**
     * @param value The value of override parameter. If you do not specify the key and value of the parameter, ROS uses the key and value that you specified when you created the stack group.
     */
    @JvmName("sfhhuehaaxtqpnye")
    public suspend fun parameterValue(`value`: Output<String>) {
        this.parameterValue = value
    }

    /**
     * @param value The key of override parameter. If you do not specify the key and value of the parameter, ROS uses the key and value that you specified when you created the stack group.
     */
    @JvmName("rhuwoheqmvukhvwi")
    public suspend fun parameterKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameterKey = mapped
    }

    /**
     * @param value The value of override parameter. If you do not specify the key and value of the parameter, ROS uses the key and value that you specified when you created the stack group.
     */
    @JvmName("esoiihalyanwuwsl")
    public suspend fun parameterValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameterValue = mapped
    }

    internal fun build(): StackInstanceParameterOverrideArgs = StackInstanceParameterOverrideArgs(
        parameterKey = parameterKey,
        parameterValue = parameterValue,
    )
}
