@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin.inputs

import com.pulumi.alicloud.ros.inputs.StackParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property parameterKey The parameter key.
 * @property parameterValue The parameter value.
 */
public data class StackParameterArgs(
    public val parameterKey: Output<String>? = null,
    public val parameterValue: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.ros.inputs.StackParameterArgs> {
    override fun toJava(): com.pulumi.alicloud.ros.inputs.StackParameterArgs =
        com.pulumi.alicloud.ros.inputs.StackParameterArgs.builder()
            .parameterKey(parameterKey?.applyValue({ args0 -> args0 }))
            .parameterValue(parameterValue.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StackParameterArgs].
 */
@PulumiTagMarker
public class StackParameterArgsBuilder internal constructor() {
    private var parameterKey: Output<String>? = null

    private var parameterValue: Output<String>? = null

    /**
     * @param value The parameter key.
     */
    @JvmName("ytoowbxccwkhsgsp")
    public suspend fun parameterKey(`value`: Output<String>) {
        this.parameterKey = value
    }

    /**
     * @param value The parameter value.
     */
    @JvmName("iapsbqqkfdmlxcvl")
    public suspend fun parameterValue(`value`: Output<String>) {
        this.parameterValue = value
    }

    /**
     * @param value The parameter key.
     */
    @JvmName("iahrrtyoqfixousj")
    public suspend fun parameterKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameterKey = mapped
    }

    /**
     * @param value The parameter value.
     */
    @JvmName("yorakcwsgyitwxpn")
    public suspend fun parameterValue(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameterValue = mapped
    }

    internal fun build(): StackParameterArgs = StackParameterArgs(
        parameterKey = parameterKey,
        parameterValue = parameterValue ?: throw PulumiNullFieldException("parameterValue"),
    )
}
