@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin.inputs

import com.pulumi.alicloud.ros.inputs.TemplateScratchPreferenceParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property parameterKey Priority parameter key. For more information about values, see [supplementary instructions for request parameters](https://www.alibabacloud.com/help/zh/doc-detail/358846.html#h2-url-4).
 * @property parameterValue Priority parameter value. For more information about values, see [supplementary instructions for request parameters](https://www.alibabacloud.com/help/zh/doc-detail/358846.html#h2-url-4).
 */
public data class TemplateScratchPreferenceParameterArgs(
    public val parameterKey: Output<String>,
    public val parameterValue: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.ros.inputs.TemplateScratchPreferenceParameterArgs> {
    override fun toJava(): com.pulumi.alicloud.ros.inputs.TemplateScratchPreferenceParameterArgs =
        com.pulumi.alicloud.ros.inputs.TemplateScratchPreferenceParameterArgs.builder()
            .parameterKey(parameterKey.applyValue({ args0 -> args0 }))
            .parameterValue(parameterValue.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TemplateScratchPreferenceParameterArgs].
 */
@PulumiTagMarker
public class TemplateScratchPreferenceParameterArgsBuilder internal constructor() {
    private var parameterKey: Output<String>? = null

    private var parameterValue: Output<String>? = null

    /**
     * @param value Priority parameter key. For more information about values, see [supplementary instructions for request parameters](https://www.alibabacloud.com/help/zh/doc-detail/358846.html#h2-url-4).
     */
    @JvmName("gwcptwokvxsesdro")
    public suspend fun parameterKey(`value`: Output<String>) {
        this.parameterKey = value
    }

    /**
     * @param value Priority parameter value. For more information about values, see [supplementary instructions for request parameters](https://www.alibabacloud.com/help/zh/doc-detail/358846.html#h2-url-4).
     */
    @JvmName("ldplpyrxxiecpsax")
    public suspend fun parameterValue(`value`: Output<String>) {
        this.parameterValue = value
    }

    /**
     * @param value Priority parameter key. For more information about values, see [supplementary instructions for request parameters](https://www.alibabacloud.com/help/zh/doc-detail/358846.html#h2-url-4).
     */
    @JvmName("crqyboqeicumahgm")
    public suspend fun parameterKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameterKey = mapped
    }

    /**
     * @param value Priority parameter value. For more information about values, see [supplementary instructions for request parameters](https://www.alibabacloud.com/help/zh/doc-detail/358846.html#h2-url-4).
     */
    @JvmName("xpfajqdhucpxpynx")
    public suspend fun parameterValue(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameterValue = mapped
    }

    internal fun build(): TemplateScratchPreferenceParameterArgs =
        TemplateScratchPreferenceParameterArgs(
            parameterKey = parameterKey ?: throw PulumiNullFieldException("parameterKey"),
            parameterValue = parameterValue ?: throw PulumiNullFieldException("parameterValue"),
        )
}
