@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin.inputs

import com.pulumi.alicloud.ros.inputs.TemplateScratchSourceResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceId The ID of the Source Resource.
 * @property resourceType The type of the Source resource.
 */
public data class TemplateScratchSourceResourceArgs(
    public val resourceId: Output<String>,
    public val resourceType: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.ros.inputs.TemplateScratchSourceResourceArgs> {
    override fun toJava(): com.pulumi.alicloud.ros.inputs.TemplateScratchSourceResourceArgs =
        com.pulumi.alicloud.ros.inputs.TemplateScratchSourceResourceArgs.builder()
            .resourceId(resourceId.applyValue({ args0 -> args0 }))
            .resourceType(resourceType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TemplateScratchSourceResourceArgs].
 */
@PulumiTagMarker
public class TemplateScratchSourceResourceArgsBuilder internal constructor() {
    private var resourceId: Output<String>? = null

    private var resourceType: Output<String>? = null

    /**
     * @param value The ID of the Source Resource.
     */
    @JvmName("qpfaxgwjekpqbjcc")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value The type of the Source resource.
     */
    @JvmName("ufrcrxbnajlchqpt")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value The ID of the Source Resource.
     */
    @JvmName("wkfnpjobdngdmvyl")
    public suspend fun resourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value The type of the Source resource.
     */
    @JvmName("ojrojbcfkuyjohuj")
    public suspend fun resourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    internal fun build(): TemplateScratchSourceResourceArgs = TemplateScratchSourceResourceArgs(
        resourceId = resourceId ?: throw PulumiNullFieldException("resourceId"),
        resourceType = resourceType ?: throw PulumiNullFieldException("resourceType"),
    )
}
