@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin.inputs

import com.pulumi.alicloud.ros.inputs.TemplateScratchSourceResourceGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupId The ID of the Source Resource Group.
 * @property resourceTypeFilters
 */
public data class TemplateScratchSourceResourceGroupArgs(
    public val resourceGroupId: Output<String>,
    public val resourceTypeFilters: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ros.inputs.TemplateScratchSourceResourceGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.ros.inputs.TemplateScratchSourceResourceGroupArgs =
        com.pulumi.alicloud.ros.inputs.TemplateScratchSourceResourceGroupArgs.builder()
            .resourceGroupId(resourceGroupId.applyValue({ args0 -> args0 }))
            .resourceTypeFilters(
                resourceTypeFilters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [TemplateScratchSourceResourceGroupArgs].
 */
@PulumiTagMarker
public class TemplateScratchSourceResourceGroupArgsBuilder internal constructor() {
    private var resourceGroupId: Output<String>? = null

    private var resourceTypeFilters: Output<List<String>>? = null

    /**
     * @param value The ID of the Source Resource Group.
     */
    @JvmName("itddvrgsqjdchboa")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value
     */
    @JvmName("pkvfssjfovfudgxs")
    public suspend fun resourceTypeFilters(`value`: Output<List<String>>) {
        this.resourceTypeFilters = value
    }

    @JvmName("tiptjjlqiljqvtyi")
    public suspend fun resourceTypeFilters(vararg values: Output<String>) {
        this.resourceTypeFilters = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("ubycukqfyysljawx")
    public suspend fun resourceTypeFilters(values: List<Output<String>>) {
        this.resourceTypeFilters = Output.all(values)
    }

    /**
     * @param value The ID of the Source Resource Group.
     */
    @JvmName("ytwxvnwymikdaxrt")
    public suspend fun resourceGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value
     */
    @JvmName("hmukyfmimwqiqctm")
    public suspend fun resourceTypeFilters(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceTypeFilters = mapped
    }

    /**
     * @param values
     */
    @JvmName("mxyddpeuptvtccpj")
    public suspend fun resourceTypeFilters(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTypeFilters = mapped
    }

    internal fun build(): TemplateScratchSourceResourceGroupArgs =
        TemplateScratchSourceResourceGroupArgs(
            resourceGroupId = resourceGroupId ?: throw PulumiNullFieldException("resourceGroupId"),
            resourceTypeFilters = resourceTypeFilters,
        )
}
