@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin.inputs

import com.pulumi.alicloud.ros.inputs.TemplateScratchSourceTagArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property resourceTags Source label. **NOTE:** A maximum of 10 source labels can be configured.
 * @property resourceTypeFilters
 */
public data class TemplateScratchSourceTagArgs(
    public val resourceTags: Output<Map<String, String>>,
    public val resourceTypeFilters: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ros.inputs.TemplateScratchSourceTagArgs> {
    override fun toJava(): com.pulumi.alicloud.ros.inputs.TemplateScratchSourceTagArgs =
        com.pulumi.alicloud.ros.inputs.TemplateScratchSourceTagArgs.builder()
            .resourceTags(
                resourceTags.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .resourceTypeFilters(
                resourceTypeFilters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [TemplateScratchSourceTagArgs].
 */
@PulumiTagMarker
public class TemplateScratchSourceTagArgsBuilder internal constructor() {
    private var resourceTags: Output<Map<String, String>>? = null

    private var resourceTypeFilters: Output<List<String>>? = null

    /**
     * @param value Source label. **NOTE:** A maximum of 10 source labels can be configured.
     */
    @JvmName("udklguotoctwacef")
    public suspend fun resourceTags(`value`: Output<Map<String, String>>) {
        this.resourceTags = value
    }

    /**
     * @param value
     */
    @JvmName("tqblwdyhfrmclvwg")
    public suspend fun resourceTypeFilters(`value`: Output<List<String>>) {
        this.resourceTypeFilters = value
    }

    @JvmName("swbkxxgnhdqdenlp")
    public suspend fun resourceTypeFilters(vararg values: Output<String>) {
        this.resourceTypeFilters = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("yxnpqgiscfpsmuys")
    public suspend fun resourceTypeFilters(values: List<Output<String>>) {
        this.resourceTypeFilters = Output.all(values)
    }

    /**
     * @param value Source label. **NOTE:** A maximum of 10 source labels can be configured.
     */
    @JvmName("cvalrgsjhivliuus")
    public suspend fun resourceTags(`value`: Map<String, String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTags = mapped
    }

    /**
     * @param values Source label. **NOTE:** A maximum of 10 source labels can be configured.
     */
    @JvmName("csqtqjhcxcwisiet")
    public fun resourceTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTags = mapped
    }

    /**
     * @param value
     */
    @JvmName("kbqmeffheamgmsvb")
    public suspend fun resourceTypeFilters(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceTypeFilters = mapped
    }

    /**
     * @param values
     */
    @JvmName("syrdlgygkbblcabb")
    public suspend fun resourceTypeFilters(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTypeFilters = mapped
    }

    internal fun build(): TemplateScratchSourceTagArgs = TemplateScratchSourceTagArgs(
        resourceTags = resourceTags ?: throw PulumiNullFieldException("resourceTags"),
        resourceTypeFilters = resourceTypeFilters,
    )
}
