@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getChangeSets.
 * @property changeSetName
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property sets
 * @property stackId
 * @property status
 */
public data class GetChangeSetsResult(
    public val changeSetName: String? = null,
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val sets: List<GetChangeSetsSet>,
    public val stackId: String,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ros.outputs.GetChangeSetsResult): GetChangeSetsResult = GetChangeSetsResult(
            changeSetName = javaType.changeSetName().map({ args0 -> args0 }).orElse(null),
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            sets = javaType.sets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ros.kotlin.outputs.GetChangeSetsSet.Companion.toKotlin(args0)
                })
            }),
            stackId = javaType.stackId(),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
