@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property changeSetId The ID of the change set.
 * @property changeSetName The name of the change set.  The name can be up to 255 characters in length and can contain digits, letters, hyphens (-), and underscores (_). It must start with a digit or letter.
 * @property changeSetType The type of the change set. Valid values:  CREATE: creates a change set for a new stack. UPDATE: creates a change set for an existing stack. IMPORT: creates a change set for a new stack or an existing stack to import non-ROS-managed resources. If you create a change set for a new stack, ROS creates a stack that has a unique stack ID. The stack is in the REVIEW_IN_PROGRESS state until you execute the change set.  You cannot use the UPDATE type to create a change set for a new stack or the CREATE type to create a change set for an existing stack.
 * @property description The description of the change set. The description can be up to 1,024 bytes in length.
 * @property disableRollback Specifies whether to disable rollback on stack creation failure. Default value: false.  Valid values:  true: disables rollback on stack creation failure. false: enables rollback on stack creation failure. Note This parameter takes effect only when ChangeSetType is set to CREATE or IMPORT.
 * @property executionStatus The execution status of change set N. Maximum value of N: 5. Valid values:  UNAVAILABLE AVAILABLE EXECUTE_IN_PROGRESS EXECUTE_COMPLETE EXECUTE_FAILED OBSOLETE.
 * @property id The ID of the Change Set.
 * @property parameters Parameters.
 * @property stackId The ID of the stack for which you want to create the change set. ROS generates the change set by comparing the stack information with the information that you submit, such as a modified template or different inputs.
 * @property stackName The name of the stack for which you want to create the change set.  The name can be up to 255 characters in length and can contain digits, letters, hyphens (-), and underscores (_). It must start with a digit or letter.  Note This parameter takes effect only when ChangeSetType is set to CREATE or IMPORT.
 * @property status The status of the change set.
 * @property templateBody The structure that contains the template body. The template body must be 1 to 524,288 bytes in length.  If the length of the template body is longer than required, we recommend that you add parameters to the HTTP POST request body to avoid request failures due to excessive length of URLs.  You can specify one of TemplateBody or TemplateURL parameters, but you cannot specify both of them.
 * @property timeoutInMinutes Timeout In Minutes.
 */
public data class GetChangeSetsSet(
    public val changeSetId: String,
    public val changeSetName: String,
    public val changeSetType: String,
    public val description: String,
    public val disableRollback: Boolean,
    public val executionStatus: String,
    public val id: String,
    public val parameters: List<GetChangeSetsSetParameter>,
    public val stackId: String,
    public val stackName: String,
    public val status: String,
    public val templateBody: String,
    public val timeoutInMinutes: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ros.outputs.GetChangeSetsSet): GetChangeSetsSet = GetChangeSetsSet(
            changeSetId = javaType.changeSetId(),
            changeSetName = javaType.changeSetName(),
            changeSetType = javaType.changeSetType(),
            description = javaType.description(),
            disableRollback = javaType.disableRollback(),
            executionStatus = javaType.executionStatus(),
            id = javaType.id(),
            parameters = javaType.parameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ros.kotlin.outputs.GetChangeSetsSetParameter.Companion.toKotlin(args0)
                })
            }),
            stackId = javaType.stackId(),
            stackName = javaType.stackName(),
            status = javaType.status(),
            templateBody = javaType.templateBody(),
            timeoutInMinutes = javaType.timeoutInMinutes(),
        )
    }
}
