@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property administrationRoleName The name of the RAM administrator role assumed by ROS.
 * @property description The description of the stack group.
 * @property executionRoleName The name of the RAM execution role assumed by the administrator role.
 * @property id The ID of the Stack Group.
 * @property parameters The parameters.
 * @property stackGroupId The id of Stack Group.
 * @property stackGroupName The name of the stack group..
 * @property status The status of Stack Group.
 * @property templateBody The structure that contains the template body.
 */
public data class GetStackGroupsGroup(
    public val administrationRoleName: String,
    public val description: String,
    public val executionRoleName: String,
    public val id: String,
    public val parameters: List<GetStackGroupsGroupParameter>,
    public val stackGroupId: String,
    public val stackGroupName: String,
    public val status: String,
    public val templateBody: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ros.outputs.GetStackGroupsGroup): GetStackGroupsGroup = GetStackGroupsGroup(
            administrationRoleName = javaType.administrationRoleName(),
            description = javaType.description(),
            executionRoleName = javaType.executionRoleName(),
            id = javaType.id(),
            parameters = javaType.parameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ros.kotlin.outputs.GetStackGroupsGroupParameter.Companion.toKotlin(args0)
                })
            }),
            stackGroupId = javaType.stackGroupId(),
            stackGroupName = javaType.stackGroupName(),
            status = javaType.status(),
            templateBody = javaType.templateBody(),
        )
    }
}
