@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property id The ID of the Stack Instance. The value formats as `<stack_group_name>:<stack_instance_account_id>:<stack_instance_region_id>`.
 * @property parameterOverrides ParameterOverrides.
 * @property stackGroupId The ID of the stack group.
 * @property stackGroupName The name of the stack group.
 * @property stackId The ID of the stack corresponding to the stack instance.
 * @property stackInstanceAccountId The account to which the stack instance belongs.
 * @property stackInstanceRegionId The region of the stack instance.
 * @property status The status of the stack instance. Valid values: `CURRENT` or `OUTDATED`.
 * * `CURRENT`: The stack corresponding to the stack instance is up to date with the stack group.
 * * `OUTDATED`: The stack corresponding to the stack instance is not up to date with the stack group. The `OUTDATED` state has the following possible causes:
 * * When the CreateStackInstances operation is called to create stack instances, the corresponding stacks fail to be created.
 * * When the UpdateStackInstances or UpdateStackGroup operation is called to update stack instances, the corresponding stacks fail to be updated, or only some of the stack instances are updated.
 * * The create or update operation is not complete.
 * @property statusReason The reason why the stack is in its current state.
 */
public data class GetStackInstancesInstance(
    public val id: String,
    public val parameterOverrides: List<GetStackInstancesInstanceParameterOverride>,
    public val stackGroupId: String,
    public val stackGroupName: String,
    public val stackId: String,
    public val stackInstanceAccountId: String,
    public val stackInstanceRegionId: String,
    public val status: String,
    public val statusReason: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ros.outputs.GetStackInstancesInstance): GetStackInstancesInstance = GetStackInstancesInstance(
            id = javaType.id(),
            parameterOverrides = javaType.parameterOverrides().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ros.kotlin.outputs.GetStackInstancesInstanceParameterOverride.Companion.toKotlin(args0)
                })
            }),
            stackGroupId = javaType.stackGroupId(),
            stackGroupName = javaType.stackGroupName(),
            stackId = javaType.stackId(),
            stackInstanceAccountId = javaType.stackInstanceAccountId(),
            stackInstanceRegionId = javaType.stackInstanceRegionId(),
            status = javaType.status(),
            statusReason = javaType.statusReason(),
        )
    }
}
