@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getStackInstances.
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property instances
 * @property outputFile
 * @property stackGroupName
 * @property stackInstanceAccountId
 * @property stackInstanceRegionId
 * @property status
 */
public data class GetStackInstancesResult(
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val instances: List<GetStackInstancesInstance>,
    public val outputFile: String? = null,
    public val stackGroupName: String,
    public val stackInstanceAccountId: String? = null,
    public val stackInstanceRegionId: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ros.outputs.GetStackInstancesResult): GetStackInstancesResult = GetStackInstancesResult(
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instances = javaType.instances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ros.kotlin.outputs.GetStackInstancesInstance.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            stackGroupName = javaType.stackGroupName(),
            stackInstanceAccountId = javaType.stackInstanceAccountId().map({ args0 -> args0 }).orElse(null),
            stackInstanceRegionId = javaType.stackInstanceRegionId().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
