@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getStacks.
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property parentStackId
 * @property showNestedStack
 * @property stackName
 * @property stacks
 * @property status
 * @property tags
 */
public data class GetStacksResult(
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val parentStackId: String? = null,
    public val showNestedStack: Boolean? = null,
    public val stackName: String? = null,
    public val stacks: List<GetStacksStack>,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ros.outputs.GetStacksResult): GetStacksResult = GetStacksResult(
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            parentStackId = javaType.parentStackId().map({ args0 -> args0 }).orElse(null),
            showNestedStack = javaType.showNestedStack().map({ args0 -> args0 }).orElse(null),
            stackName = javaType.stackName().map({ args0 -> args0 }).orElse(null),
            stacks = javaType.stacks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ros.kotlin.outputs.GetStacksStack.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
