@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property deletionProtection Specifies whether to enable deletion protection on the stack.
 * @property description The Description of the Stack.
 * @property disableRollback Specifies whether to disable rollback on stack creation failure..
 * @property driftDetectionTime Drift DetectionTime.
 * @property id The ID of the Stack.
 * @property parameters The parameters.
 * @property parentStackId Parent Stack Id.
 * @property ramRoleName The RamRoleName.
 * @property rootStackId Root Stack Id.
 * @property stackDriftStatus Stack DriftStatus.
 * @property stackId Stack Id.
 * @property stackName Stack Name.
 * @property stackPolicyBody The structure that contains the stack policy body.
 * @property status The status of Stack. Valid Values: `CREATE_COMPLETE`, `CREATE_FAILED`, `CREATE_IN_PROGRESS`, `DELETE_COMPLETE`, `DELETE_FAILED`, `DELETE_IN_PROGRESS`, `ROLLBACK_COMPLETE`, `ROLLBACK_FAILED`, `ROLLBACK_IN_PROGRESS`.
 * @property statusReason Status Reason.
 * @property tags Query the instance bound to the tag. The format of the incoming value is `json` string, including `TagKey` and `TagValue`. `TagKey` cannot be null, and `TagValue` can be empty. Format example `{"key1":"value1"}`.
 * @property templateDescription Template Description.
 * @property timeoutInMinutes Specifies whether to use the values that were passed last time for the parameters that you do not specify in the current request.
 */
public data class GetStacksStack(
    public val deletionProtection: String,
    public val description: String,
    public val disableRollback: Boolean,
    public val driftDetectionTime: String,
    public val id: String,
    public val parameters: List<GetStacksStackParameter>,
    public val parentStackId: String,
    public val ramRoleName: String,
    public val rootStackId: String,
    public val stackDriftStatus: String,
    public val stackId: String,
    public val stackName: String,
    public val stackPolicyBody: String,
    public val status: String,
    public val statusReason: String,
    public val tags: Map<String, String>,
    public val templateDescription: String,
    public val timeoutInMinutes: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ros.outputs.GetStacksStack): GetStacksStack =
            GetStacksStack(
                deletionProtection = javaType.deletionProtection(),
                description = javaType.description(),
                disableRollback = javaType.disableRollback(),
                driftDetectionTime = javaType.driftDetectionTime(),
                id = javaType.id(),
                parameters = javaType.parameters().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.ros.kotlin.outputs.GetStacksStackParameter.Companion.toKotlin(args0)
                    })
                }),
                parentStackId = javaType.parentStackId(),
                ramRoleName = javaType.ramRoleName(),
                rootStackId = javaType.rootStackId(),
                stackDriftStatus = javaType.stackDriftStatus(),
                stackId = javaType.stackId(),
                stackName = javaType.stackName(),
                stackPolicyBody = javaType.stackPolicyBody(),
                status = javaType.status(),
                statusReason = javaType.statusReason(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                templateDescription = javaType.templateDescription(),
                timeoutInMinutes = javaType.timeoutInMinutes(),
            )
    }
}
