@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property createTime The creation time of the resource.
 * @property description The description of the Template Scratch.
 * @property id The ID of the Template Scratch.
 * @property logicalIdStrategy The Logical ID generation strategy of the Template Scratch.
 * @property preferenceParameters Priority parameter.
 * @property sourceResourceGroups Source resource grouping.
 * @property sourceResources Source resource.
 * @property sourceTags The Source label list.
 * @property stacks A list of resource stacks associated with the resource scene.
 * @property status The status of the resource.
 * @property templateScratchId The ID of the Template Scratch.
 * @property templateScratchType The type of the Template Scratch.
 */
public data class GetTemplateScratchesScratch(
    public val createTime: String,
    public val description: String,
    public val id: String,
    public val logicalIdStrategy: String,
    public val preferenceParameters: List<GetTemplateScratchesScratchPreferenceParameter>,
    public val sourceResourceGroups: List<GetTemplateScratchesScratchSourceResourceGroup>,
    public val sourceResources: List<GetTemplateScratchesScratchSourceResource>,
    public val sourceTags: List<GetTemplateScratchesScratchSourceTag>,
    public val stacks: List<GetTemplateScratchesScratchStack>,
    public val status: String,
    public val templateScratchId: String,
    public val templateScratchType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ros.outputs.GetTemplateScratchesScratch): GetTemplateScratchesScratch = GetTemplateScratchesScratch(
            createTime = javaType.createTime(),
            description = javaType.description(),
            id = javaType.id(),
            logicalIdStrategy = javaType.logicalIdStrategy(),
            preferenceParameters = javaType.preferenceParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ros.kotlin.outputs.GetTemplateScratchesScratchPreferenceParameter.Companion.toKotlin(args0)
                })
            }),
            sourceResourceGroups = javaType.sourceResourceGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ros.kotlin.outputs.GetTemplateScratchesScratchSourceResourceGroup.Companion.toKotlin(args0)
                })
            }),
            sourceResources = javaType.sourceResources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ros.kotlin.outputs.GetTemplateScratchesScratchSourceResource.Companion.toKotlin(args0)
                })
            }),
            sourceTags = javaType.sourceTags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ros.kotlin.outputs.GetTemplateScratchesScratchSourceTag.Companion.toKotlin(args0)
                })
            }),
            stacks = javaType.stacks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.ros.kotlin.outputs.GetTemplateScratchesScratchStack.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status(),
            templateScratchId = javaType.templateScratchId(),
            templateScratchType = javaType.templateScratchType(),
        )
    }
}
