@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property changeSetId The ID of the change set.
 * @property description The description of the template. The description can be up to 256 characters in length.
 * @property id The ID of the Template.
 * @property shareType Share Type.
 * @property stackGroupName The name of the stack group. The name must be unique in a region.  The name can be up to 255 characters in length and can contain digits, letters, hyphens (-), and underscores (_). It must start with a digit or letter.
 * @property stackId The ID of the stack.
 * @property tags Tags.
 * @property templateBody The structure that contains the template body. The template body must be 1 to 524,288 bytes in length.  If the length of the template body is longer than required, we recommend that you add parameters to the HTTP POST request body to avoid request failures due to excessive length of URLs.  You must specify one of the TemplateBody and TemplateURL parameters, but you cannot specify both of them.
 * @property templateId The ID of the template.
 * @property templateName The name of the template.  The name can be up to 255 characters in length and can contain digits, letters, hyphens (-), and underscores (_). It must start with a digit or letter.
 * @property templateVersion Template Version.
 */
public data class GetTemplatesTemplate(
    public val changeSetId: String,
    public val description: String,
    public val id: String,
    public val shareType: String,
    public val stackGroupName: String,
    public val stackId: String,
    public val tags: Map<String, String>,
    public val templateBody: String,
    public val templateId: String,
    public val templateName: String,
    public val templateVersion: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ros.outputs.GetTemplatesTemplate): GetTemplatesTemplate = GetTemplatesTemplate(
            changeSetId = javaType.changeSetId(),
            description = javaType.description(),
            id = javaType.id(),
            shareType = javaType.shareType(),
            stackGroupName = javaType.stackGroupName(),
            stackId = javaType.stackId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            templateBody = javaType.templateBody(),
            templateId = javaType.templateId(),
            templateName = javaType.templateName(),
            templateVersion = javaType.templateVersion(),
        )
    }
}
