@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property parameterKey The key of override parameter. If you do not specify the key and value of the parameter, ROS uses the key and value that you specified when you created the stack group.
 * @property parameterValue The value of override parameter. If you do not specify the key and value of the parameter, ROS uses the key and value that you specified when you created the stack group.
 */
public data class StackInstanceParameterOverride(
    public val parameterKey: String? = null,
    public val parameterValue: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ros.outputs.StackInstanceParameterOverride): StackInstanceParameterOverride = StackInstanceParameterOverride(
            parameterKey = javaType.parameterKey().map({ args0 -> args0 }).orElse(null),
            parameterValue = javaType.parameterValue().map({ args0 -> args0 }).orElse(null),
        )
    }
}
