@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property parameterKey The parameter key.
 * @property parameterValue The parameter value.
 */
public data class StackParameter(
    public val parameterKey: String? = null,
    public val parameterValue: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ros.outputs.StackParameter): StackParameter =
            StackParameter(
                parameterKey = javaType.parameterKey().map({ args0 -> args0 }).orElse(null),
                parameterValue = javaType.parameterValue(),
            )
    }
}
