@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property parameterKey Priority parameter key. For more information about values, see [supplementary instructions for request parameters](https://www.alibabacloud.com/help/zh/doc-detail/358846.html#h2-url-4).
 * @property parameterValue Priority parameter value. For more information about values, see [supplementary instructions for request parameters](https://www.alibabacloud.com/help/zh/doc-detail/358846.html#h2-url-4).
 */
public data class TemplateScratchPreferenceParameter(
    public val parameterKey: String,
    public val parameterValue: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ros.outputs.TemplateScratchPreferenceParameter): TemplateScratchPreferenceParameter = TemplateScratchPreferenceParameter(
            parameterKey = javaType.parameterKey(),
            parameterValue = javaType.parameterValue(),
        )
    }
}
