@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property resourceId The ID of the Source Resource.
 * @property resourceType The type of the Source resource.
 */
public data class TemplateScratchSourceResource(
    public val resourceId: String,
    public val resourceType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ros.outputs.TemplateScratchSourceResource): TemplateScratchSourceResource = TemplateScratchSourceResource(
            resourceId = javaType.resourceId(),
            resourceType = javaType.resourceType(),
        )
    }
}
