@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ros.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property resourceTags Source label. **NOTE:** A maximum of 10 source labels can be configured.
 * @property resourceTypeFilters
 */
public data class TemplateScratchSourceTag(
    public val resourceTags: Map<String, String>,
    public val resourceTypeFilters: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ros.outputs.TemplateScratchSourceTag): TemplateScratchSourceTag = TemplateScratchSourceTag(
            resourceTags = javaType.resourceTags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            resourceTypeFilters = javaType.resourceTypeFilters().map({ args0 -> args0 }),
        )
    }
}
