@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin

import com.pulumi.alicloud.sae.kotlin.outputs.ApplicationConfigMapMountDescV2
import com.pulumi.alicloud.sae.kotlin.outputs.ApplicationCustomHostAliasV2
import com.pulumi.alicloud.sae.kotlin.outputs.ApplicationKafkaConfigs
import com.pulumi.alicloud.sae.kotlin.outputs.ApplicationLivenessV2
import com.pulumi.alicloud.sae.kotlin.outputs.ApplicationNasConfig
import com.pulumi.alicloud.sae.kotlin.outputs.ApplicationOssMountDescsV2
import com.pulumi.alicloud.sae.kotlin.outputs.ApplicationPostStartV2
import com.pulumi.alicloud.sae.kotlin.outputs.ApplicationPreStopV2
import com.pulumi.alicloud.sae.kotlin.outputs.ApplicationPvtzDiscoverySvc
import com.pulumi.alicloud.sae.kotlin.outputs.ApplicationReadinessV2
import com.pulumi.alicloud.sae.kotlin.outputs.ApplicationTomcatConfigV2
import com.pulumi.alicloud.sae.kotlin.outputs.ApplicationUpdateStrategyV2
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.sae.kotlin.outputs.ApplicationConfigMapMountDescV2.Companion.toKotlin as applicationConfigMapMountDescV2ToKotlin
import com.pulumi.alicloud.sae.kotlin.outputs.ApplicationCustomHostAliasV2.Companion.toKotlin as applicationCustomHostAliasV2ToKotlin
import com.pulumi.alicloud.sae.kotlin.outputs.ApplicationKafkaConfigs.Companion.toKotlin as applicationKafkaConfigsToKotlin
import com.pulumi.alicloud.sae.kotlin.outputs.ApplicationLivenessV2.Companion.toKotlin as applicationLivenessV2ToKotlin
import com.pulumi.alicloud.sae.kotlin.outputs.ApplicationNasConfig.Companion.toKotlin as applicationNasConfigToKotlin
import com.pulumi.alicloud.sae.kotlin.outputs.ApplicationOssMountDescsV2.Companion.toKotlin as applicationOssMountDescsV2ToKotlin
import com.pulumi.alicloud.sae.kotlin.outputs.ApplicationPostStartV2.Companion.toKotlin as applicationPostStartV2ToKotlin
import com.pulumi.alicloud.sae.kotlin.outputs.ApplicationPreStopV2.Companion.toKotlin as applicationPreStopV2ToKotlin
import com.pulumi.alicloud.sae.kotlin.outputs.ApplicationPvtzDiscoverySvc.Companion.toKotlin as applicationPvtzDiscoverySvcToKotlin
import com.pulumi.alicloud.sae.kotlin.outputs.ApplicationReadinessV2.Companion.toKotlin as applicationReadinessV2ToKotlin
import com.pulumi.alicloud.sae.kotlin.outputs.ApplicationTomcatConfigV2.Companion.toKotlin as applicationTomcatConfigV2ToKotlin
import com.pulumi.alicloud.sae.kotlin.outputs.ApplicationUpdateStrategyV2.Companion.toKotlin as applicationUpdateStrategyV2ToKotlin

/**
 * Builder for [Application].
 */
@PulumiTagMarker
public class ApplicationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApplicationArgs = ApplicationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApplicationArgsBuilder.() -> Unit) {
        val builder = ApplicationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Application {
        val builtJavaResource = com.pulumi.alicloud.sae.Application(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Application(builtJavaResource)
    }
}

/**
 * Provides a Serverless App Engine (SAE) Application resource.
 * For information about Serverless App Engine (SAE) Application and how to use it, see [What is Application](https://www.alibabacloud.com/help/en/sae/latest/createapplication).
 * > **NOTE:** Available since v1.161.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const region = config.get("region") || "cn-hangzhou";
 * const name = config.get("name") || "tf-example";
 * const defaultInteger = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const default = alicloud.getRegions({
 *     current: true,
 * });
 * const defaultGetZones = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "10.4.0.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: defaultGetZones.then(defaultGetZones => defaultGetZones.zones?.[0]?.id),
 * });
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {vpcId: defaultNetwork.id});
 * const defaultNamespace = new alicloud.sae.Namespace("default", {
 *     namespaceId: _default.then(_default => `${_default.regions?.[0]?.id}:example${defaultInteger.result}`),
 *     namespaceName: name,
 *     namespaceDescription: name,
 *     enableMicroRegistration: false,
 * });
 * const defaultApplication = new alicloud.sae.Application("default", {
 *     appDescription: name,
 *     appName: `${name}-${defaultInteger.result}`,
 *     namespaceId: defaultNamespace.id,
 *     imageUrl: _default.then(_default => `registry-vpc.${_default.regions?.[0]?.id}.aliyuncs.com/sae-demo-image/consumer:1.0`),
 *     packageType: "Image",
 *     securityGroupId: defaultSecurityGroup.id,
 *     vpcId: defaultNetwork.id,
 *     vswitchId: defaultSwitch.id,
 *     timezone: "Asia/Beijing",
 *     replicas: 5,
 *     cpu: 500,
 *     memory: 2048,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * region = config.get("region")
 * if region is None:
 *     region = "cn-hangzhou"
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default_integer = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * default = alicloud.get_regions(current=True)
 * default_get_zones = alicloud.get_zones(available_resource_creation="VSwitch")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="10.4.0.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=default_get_zones.zones[0].id)
 * default_security_group = alicloud.ecs.SecurityGroup("default", vpc_id=default_network.id)
 * default_namespace = alicloud.sae.Namespace("default",
 *     namespace_id=f"{default.regions[0]&#46;id}:example{default_integer['result']}",
 *     namespace_name=name,
 *     namespace_description=name,
 *     enable_micro_registration=False)
 * default_application = alicloud.sae.Application("default",
 *     app_description=name,
 *     app_name=f"{name}-{default_integer['result']}",
 *     namespace_id=default_namespace.id,
 *     image_url=f"registry-vpc.{default.regions[0].id}.aliyuncs.com/sae-demo-image/consumer:1.0",
 *     package_type="Image",
 *     security_group_id=default_security_group.id,
 *     vpc_id=default_network.id,
 *     vswitch_id=default_switch.id,
 *     timezone="Asia/Beijing",
 *     replicas=5,
 *     cpu=500,
 *     memory=2048)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var region = config.Get("region") ?? "cn-hangzhou";
 *     var name = config.Get("name") ?? "tf-example";
 *     var defaultInteger = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var @default = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var defaultGetZones = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.4.0.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = defaultGetZones.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultNamespace = new AliCloud.Sae.Namespace("default", new()
 *     {
 *         NamespaceId = @default.Apply(@default => $"{@default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)}:example{defaultInteger.Result}"),
 *         NamespaceName = name,
 *         NamespaceDescription = name,
 *         EnableMicroRegistration = false,
 *     });
 *     var defaultApplication = new AliCloud.Sae.Application("default", new()
 *     {
 *         AppDescription = name,
 *         AppName = $"{name}-{defaultInteger.Result}",
 *         NamespaceId = defaultNamespace.Id,
 *         ImageUrl = @default.Apply(@default => $"registry-vpc.{@default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)}.aliyuncs.com/sae-demo-image/consumer:1.0"),
 *         PackageType = "Image",
 *         SecurityGroupId = defaultSecurityGroup.Id,
 *         VpcId = defaultNetwork.Id,
 *         VswitchId = defaultSwitch.Id,
 *         Timezone = "Asia/Beijing",
 *         Replicas = 5,
 *         Cpu = 500,
 *         Memory = 2048,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/sae"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		region := "cn-hangzhou"
 * 		if param := cfg.Get("region"); param != "" {
 * 			region = param
 * 		}
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		defaultInteger, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_default, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetZones, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.4.0.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(defaultGetZones.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			VpcId: defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNamespace, err := sae.NewNamespace(ctx, "default", &sae.NamespaceArgs{
 * 			NamespaceId:             pulumi.Sprintf("%v:example%v", _default.Regions[0].Id, defaultInteger.Result),
 * 			NamespaceName:           pulumi.String(name),
 * 			NamespaceDescription:    pulumi.String(name),
 * 			EnableMicroRegistration: pulumi.Bool(false),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = sae.NewApplication(ctx, "default", &sae.ApplicationArgs{
 * 			AppDescription:  pulumi.String(name),
 * 			AppName:         pulumi.Sprintf("%v-%v", name, defaultInteger.Result),
 * 			NamespaceId:     defaultNamespace.ID(),
 * 			ImageUrl:        pulumi.Sprintf("registry-vpc.%v.aliyuncs.com/sae-demo-image/consumer:1.0", _default.Regions[0].Id),
 * 			PackageType:     pulumi.String("Image"),
 * 			SecurityGroupId: defaultSecurityGroup.ID(),
 * 			VpcId:           defaultNetwork.ID(),
 * 			VswitchId:       defaultSwitch.ID(),
 * 			Timezone:        pulumi.String("Asia/Beijing"),
 * 			Replicas:        pulumi.Int(5),
 * 			Cpu:             pulumi.Int(500),
 * 			Memory:          pulumi.Int(2048),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.sae.Namespace;
 * import com.pulumi.alicloud.sae.NamespaceArgs;
 * import com.pulumi.alicloud.sae.Application;
 * import com.pulumi.alicloud.sae.ApplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var region = config.get("region").orElse("cn-hangzhou");
 *         final var name = config.get("name").orElse("tf-example");
 *         var defaultInteger = new Integer("defaultInteger", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         final var default = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         final var defaultGetZones = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.4.0.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(defaultGetZones.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         var defaultNamespace = new Namespace("defaultNamespace", NamespaceArgs.builder()
 *             .namespaceId(String.format("%s:example%s", default_.regions()[0].id(),defaultInteger.result()))
 *             .namespaceName(name)
 *             .namespaceDescription(name)
 *             .enableMicroRegistration(false)
 *             .build());
 *         var defaultApplication = new Application("defaultApplication", ApplicationArgs.builder()
 *             .appDescription(name)
 *             .appName(String.format("%s-%s", name,defaultInteger.result()))
 *             .namespaceId(defaultNamespace.id())
 *             .imageUrl(String.format("registry-vpc.%s.aliyuncs.com/sae-demo-image/consumer:1.0", default_.regions()[0].id()))
 *             .packageType("Image")
 *             .securityGroupId(defaultSecurityGroup.id())
 *             .vpcId(defaultNetwork.id())
 *             .vswitchId(defaultSwitch.id())
 *             .timezone("Asia/Beijing")
 *             .replicas("5")
 *             .cpu("500")
 *             .memory("2048")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   region:
 *     type: string
 *     default: cn-hangzhou
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultInteger:
 *     type: random:integer
 *     name: default
 *     properties:
 *       max: 99999
 *       min: 10000
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.4.0.0/24
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${defaultGetZones.zones[0].id}
 *   defaultSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *   defaultNamespace:
 *     type: alicloud:sae:Namespace
 *     name: default
 *     properties:
 *       namespaceId: ${default.regions[0].id}:example${defaultInteger.result}
 *       namespaceName: ${name}
 *       namespaceDescription: ${name}
 *       enableMicroRegistration: false
 *   defaultApplication:
 *     type: alicloud:sae:Application
 *     name: default
 *     properties:
 *       appDescription: ${name}
 *       appName: ${name}-${defaultInteger.result}
 *       namespaceId: ${defaultNamespace.id}
 *       imageUrl: registry-vpc.${default.regions[0].id}.aliyuncs.com/sae-demo-image/consumer:1.0
 *       packageType: Image
 *       securityGroupId: ${defaultSecurityGroup.id}
 *       vpcId: ${defaultNetwork.id}
 *       vswitchId: ${defaultSwitch.id}
 *       timezone: Asia/Beijing
 *       replicas: '5'
 *       cpu: '500'
 *       memory: '2048'
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 *   defaultGetZones:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Serverless App Engine (SAE) Application can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:sae/application:Application example <id>
 * ```
 */
public class Application internal constructor(
    override val javaResource: com.pulumi.alicloud.sae.Application,
) : KotlinCustomResource(javaResource, ApplicationMapper) {
    /**
     * The ARN of the RAM role required when pulling images across accounts. Only necessary if the image_url is pointing to an ACR EE instance.
     */
    public val acrAssumeRoleArn: Output<String>?
        get() = javaResource.acrAssumeRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the ACR EE instance. Only necessary if the image_url is pointing to an ACR EE instance.
     */
    public val acrInstanceId: Output<String>?
        get() = javaResource.acrInstanceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Application description information. No more than 1024 characters. **NOTE:** From version 1.211.0, `app_description` can be modified.
     */
    public val appDescription: Output<String>?
        get() = javaResource.appDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Application Name. Combinations of numbers, letters, and dashes (-) are allowed. It must start with a letter and the maximum length is 36 characters.
     */
    public val appName: Output<String>
        get() = javaResource.appName().applyValue({ args0 -> args0 })

    /**
     * The auto config. Valid values: `true`, `false`.
     */
    public val autoConfig: Output<Boolean>?
        get() = javaResource.autoConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The auto enable application scaling rule. Valid values: `true`, `false`.
     */
    public val autoEnableApplicationScalingRule: Output<Boolean>?
        get() = javaResource.autoEnableApplicationScalingRule().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The batch wait time.
     */
    public val batchWaitTime: Output<Int>
        get() = javaResource.batchWaitTime().applyValue({ args0 -> args0 })

    /**
     * The change order desc.
     */
    public val changeOrderDesc: Output<String>?
        get() = javaResource.changeOrderDesc().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Mirror start command. The command must be an executable object in the container. For example: sleep. Setting this command will cause the original startup command of the mirror to become invalid.
     */
    public val command: Output<String>?
        get() = javaResource.command().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Mirror startup command parameters. The parameters required for the above start command. For example: 1d. **NOTE:** Field `command_args` has been deprecated from provider version 1.211.0. New field `command_args_v2` instead.
     */
    @Deprecated(
        message = """
  Field `command_args` has been deprecated from provider version 1.211.0. New field
      `command_args_v2` instead.
  """,
    )
    public val commandArgs: Output<String>
        get() = javaResource.commandArgs().applyValue({ args0 -> args0 })

    /**
     * The parameters of the image startup command.
     */
    public val commandArgsV2s: Output<List<String>>
        get() = javaResource.commandArgsV2s().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * ConfigMap mount description. **NOTE:** Field `config_map_mount_desc` has been deprecated from provider version 1.211.0. New field `config_map_mount_desc_v2` instead.
     */
    @Deprecated(
        message = """
  Field `config_map_mount_desc` has been deprecated from provider version 1.211.0. New field
      `config_map_mount_desc_v2` instead.
  """,
    )
    public val configMapMountDesc: Output<String>
        get() = javaResource.configMapMountDesc().applyValue({ args0 -> args0 })

    /**
     * The description of the ConfigMap that is mounted to the application. A ConfigMap that is created on the ConfigMaps page of a namespace is used to inject configurations into containers. See `config_map_mount_desc_v2` below.
     */
    public val configMapMountDescV2s: Output<List<ApplicationConfigMapMountDescV2>>
        get() = javaResource.configMapMountDescV2s().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> applicationConfigMapMountDescV2ToKotlin(args0) })
            })
        })

    /**
     * The CPU required for each instance, in millicores, cannot be 0. Valid values: `500`, `1000`, `2000`, `4000`, `8000`, `16000`, `32000`.
     */
    public val cpu: Output<Int>?
        get() = javaResource.cpu().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Custom host mapping in the container. For example: [{`hostName`:`samplehost`,`ip`:`127&#46;0&#46;0&#46;1`}]. **NOTE:** Field `custom_host_alias` has been deprecated from provider version 1.211.0. New field `custom_host_alias_v2` instead.
     */
    @Deprecated(
        message = """
  Field `custom_host_alias` has been deprecated from provider version 1.211.0. New field
      `custom_host_alias_v2` instead.
  """,
    )
    public val customHostAlias: Output<String>
        get() = javaResource.customHostAlias().applyValue({ args0 -> args0 })

    /**
     * The custom mapping between the hostname and IP address in the container. See `custom_host_alias_v2` below.
     */
    public val customHostAliasV2s: Output<List<ApplicationCustomHostAliasV2>>
        get() = javaResource.customHostAliasV2s().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> applicationCustomHostAliasV2ToKotlin(args0) })
            })
        })

    /**
     * The deploy. Valid values: `true`, `false`.
     */
    public val deploy: Output<Boolean>?
        get() = javaResource.deploy().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The operating environment used by the Pandora application.
     */
    public val edasContainerVersion: Output<String>?
        get() = javaResource.edasContainerVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The enable ahas. Valid values: `true`, `false`.
     */
    public val enableAhas: Output<String>
        get() = javaResource.enableAhas().applyValue({ args0 -> args0 })

    /**
     * The enable grey tag route. Default value: `false`. Valid values:
     */
    public val enableGreyTagRoute: Output<Boolean>
        get() = javaResource.enableGreyTagRoute().applyValue({ args0 -> args0 })

    /**
     * Container environment variable parameters. For example,`	[{"name":"envtmp","value":"0"}]`. The value description is as follows:
     */
    public val envs: Output<String>
        get() = javaResource.envs().applyValue({ args0 -> args0 })

    /**
     * The ID of the corresponding Secret.
     */
    public val imagePullSecrets: Output<String>?
        get() = javaResource.imagePullSecrets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Mirror address. Only Image type applications can configure the mirror address.
     */
    public val imageUrl: Output<String>?
        get() = javaResource.imageUrl().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The JAR package starts application parameters. Application default startup command: $JAVA_HOME/bin/java $JarStartOptions -jar $CATALINA_OPTS "$package_path" $JarStartArgs.
     */
    public val jarStartArgs: Output<String>?
        get() = javaResource.jarStartArgs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The JAR package starts the application option. Application default startup command: $JAVA_HOME/bin/java $JarStartOptions -jar $CATALINA_OPTS "$package_path" $JarStartArgs.
     */
    public val jarStartOptions: Output<String>?
        get() = javaResource.jarStartOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The JDK version that the deployment package depends on. Image type applications are not supported.
     */
    public val jdk: Output<String>?
        get() = javaResource.jdk().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The logging configurations of ApsaraMQ for Kafka. See `kafka_configs` below.
     */
    public val kafkaConfigs: Output<ApplicationKafkaConfigs>?
        get() = javaResource.kafkaConfigs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    applicationKafkaConfigsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Container health check. Containers that fail the health check will be shut down and restored. Currently, only the method of issuing commands in the container is supported.
     * **NOTE:** Field `liveness` has been deprecated from provider version 1.211.0. New field `liveness_v2` instead.
     */
    @Deprecated(
        message = """
  Field `liveness` has been deprecated from provider version 1.211.0. New field `liveness_v2`
      instead.
  """,
    )
    public val liveness: Output<String>
        get() = javaResource.liveness().applyValue({ args0 -> args0 })

    /**
     * The liveness check settings of the container. See `liveness_v2` below.
     */
    public val livenessV2: Output<ApplicationLivenessV2>
        get() = javaResource.livenessV2().applyValue({ args0 ->
            args0.let({ args0 ->
                applicationLivenessV2ToKotlin(args0)
            })
        })

    /**
     * The memory required for each instance, in MB, cannot be 0. One-to-one correspondence with CPU. Valid values: `1024`, `2048`, `4096`, `8192`, `12288`, `16384`, `24576`, `32768`, `65536`, `131072`.
     */
    public val memory: Output<Int>?
        get() = javaResource.memory().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Select the Nacos registry. Valid values: `0`, `1`, `2`.
     */
    public val microRegistration: Output<String>?
        get() = javaResource.microRegistration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Minimum Survival Instance Percentage. **NOTE:** When `min_ready_instances` and `min_ready_instance_ratio` are passed at the same time, and the value of `min_ready_instance_ratio` is not -1, the `min_ready_instance_ratio` parameter shall prevail. Assuming that `min_ready_instances` is 5 and `min_ready_instance_ratio` is 50, 50 is used to calculate the minimum number of surviving instances.The value description is as follows:
     * * `-1`: Initialization value, indicating that percentages are not used.
     * * `0~100`: The unit is percentage, rounded up. For example, if it is set to 50%, if there are currently 5 instances, the minimum number of surviving instances is 3.
     */
    public val minReadyInstanceRatio: Output<Int>
        get() = javaResource.minReadyInstanceRatio().applyValue({ args0 -> args0 })

    /**
     * The Minimum Available Instance. On the Change Had Promised during the Available Number of Instances to Be.
     */
    public val minReadyInstances: Output<Int>
        get() = javaResource.minReadyInstances().applyValue({ args0 -> args0 })

    /**
     * SAE namespace ID. Only namespaces whose names are lowercase letters and dashes (-) are supported, and must start with a letter. The namespace can be obtained by calling the DescribeNamespaceList interface.
     */
    public val namespaceId: Output<String>?
        get() = javaResource.namespaceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The configurations for mounting the NAS file system. See `nas_configs` below.
     */
    public val nasConfigs: Output<List<ApplicationNasConfig>>?
        get() = javaResource.nasConfigs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> applicationNasConfigToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * OSS AccessKey ID.
     */
    public val ossAkId: Output<String>?
        get() = javaResource.ossAkId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * OSS  AccessKey Secret.
     */
    public val ossAkSecret: Output<String>?
        get() = javaResource.ossAkSecret().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * OSS mount description information. **NOTE:** Field `oss_mount_descs` has been deprecated from provider version 1.211.0. New field `oss_mount_descs_v2` instead.
     */
    @Deprecated(
        message = """
  Field `oss_mount_descs` has been deprecated from provider version 1.211.0. New field
      `oss_mount_descs_v2` instead.
  """,
    )
    public val ossMountDescs: Output<String>
        get() = javaResource.ossMountDescs().applyValue({ args0 -> args0 })

    /**
     * The description of the mounted Object Storage Service (OSS) bucket. See `oss_mount_descs_v2` below.
     */
    public val ossMountDescsV2s: Output<List<ApplicationOssMountDescsV2>>
        get() = javaResource.ossMountDescsV2s().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> applicationOssMountDescsV2ToKotlin(args0) })
            })
        })

    /**
     * Application package type. Valid values: `FatJar`, `War`, `Image`, `PhpZip`, `IMAGE_PHP_5_4`, `IMAGE_PHP_5_4_ALPINE`, `IMAGE_PHP_5_5`, `IMAGE_PHP_5_5_ALPINE`, `IMAGE_PHP_5_6`, `IMAGE_PHP_5_6_ALPINE`, `IMAGE_PHP_7_0`, `IMAGE_PHP_7_0_ALPINE`, `IMAGE_PHP_7_1`, `IMAGE_PHP_7_1_ALPINE`, `IMAGE_PHP_7_2`, `IMAGE_PHP_7_2_ALPINE`, `IMAGE_PHP_7_3`, `IMAGE_PHP_7_3_ALPINE`, `PythonZip`.
     */
    public val packageType: Output<String>
        get() = javaResource.packageType().applyValue({ args0 -> args0 })

    /**
     * Deployment package address. Only FatJar or War type applications can configure the deployment package address.
     */
    public val packageUrl: Output<String>?
        get() = javaResource.packageUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The version number of the deployment package. Required when the Package Type is War and FatJar.
     */
    public val packageVersion: Output<String>
        get() = javaResource.packageVersion().applyValue({ args0 -> args0 })

    /**
     * The Php environment.
     */
    public val php: Output<String>?
        get() = javaResource.php().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The PHP application monitors the mount path, and you need to ensure that the PHP server will load the configuration file of this path. You don't need to pay attention to the configuration content, SAE will automatically render the correct configuration file.
     */
    public val phpArmsConfigLocation: Output<String>
        get() = javaResource.phpArmsConfigLocation().applyValue({ args0 -> args0 })

    /**
     * PHP configuration file content.
     */
    public val phpConfig: Output<String>?
        get() = javaResource.phpConfig().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * PHP application startup configuration mount path, you need to ensure that the PHP server will start using this configuration file.
     */
    public val phpConfigLocation: Output<String>?
        get() = javaResource.phpConfigLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Execute the script after startup, the format is like: {`exec`:{`command`:[`cat`,"/etc/group"]}}. **NOTE:** Field `post_start` has been deprecated from provider version 1.211.0. New field `post_start_v2` instead.
     */
    @Deprecated(
        message = """
  Field `post_start` has been deprecated from provider version 1.211.0. New field `post_start_v2`
      instead.
  """,
    )
    public val postStart: Output<String>
        get() = javaResource.postStart().applyValue({ args0 -> args0 })

    /**
     * The script that is run immediately after the container is started. See `post_start_v2` below.
     */
    public val postStartV2: Output<ApplicationPostStartV2>
        get() = javaResource.postStartV2().applyValue({ args0 ->
            args0.let({ args0 ->
                applicationPostStartV2ToKotlin(args0)
            })
        })

    /**
     * Execute the script before stopping, the format is like: {`exec`:{`command`:[`cat`,"/etc/group"]}}. **NOTE:** Field `pre_stop` has been deprecated from provider version 1.211.0. New field `pre_stop_v2` instead.
     */
    @Deprecated(
        message = """
  Field `pre_stop` has been deprecated from provider version 1.211.0. New field `pre_stop_v2`
      instead.
  """,
    )
    public val preStop: Output<String>
        get() = javaResource.preStop().applyValue({ args0 -> args0 })

    /**
     * The script that is run before the container is stopped. See `pre_stop_v2` below.
     */
    public val preStopV2: Output<ApplicationPreStopV2>
        get() = javaResource.preStopV2().applyValue({ args0 ->
            args0.let({ args0 ->
                applicationPreStopV2ToKotlin(args0)
            })
        })

    /**
     * The programming language that is used to create the application. Valid values: `java`, `php`, `other`.
     */
    public val programmingLanguage: Output<String>
        get() = javaResource.programmingLanguage().applyValue({ args0 -> args0 })

    /**
     * The configurations of Kubernetes Service-based service registration and discovery. See `pvtz_discovery_svc` below.
     */
    public val pvtzDiscoverySvc: Output<ApplicationPvtzDiscoverySvc>?
        get() = javaResource.pvtzDiscoverySvc().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> applicationPvtzDiscoverySvcToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Application startup status checks, containers that fail multiple health checks will be shut down and restarted. Containers that do not pass the health check will not receive SLB traffic. For example: {`exec`:{`command`:[`sh`,"-c","cat /home/admin/start&#46;sh"]},`initialDelaySeconds`:30,`periodSeconds`:30,"timeoutSeconds ":2}. Valid values: `command`, `initialDelaySeconds`, `periodSeconds`, `timeoutSeconds`.
     * **NOTE:** Field `readiness` has been deprecated from provider version 1.211.0. New field `readiness_v2` instead.
     */
    @Deprecated(
        message = """
  Field `readiness` has been deprecated from provider version 1.211.0. New field `readiness_v2`
      instead.
  """,
    )
    public val readiness: Output<String>
        get() = javaResource.readiness().applyValue({ args0 -> args0 })

    /**
     * The readiness check settings of the container. If a container fails this health check multiple times, the container is stopped and then restarted. See `readiness_v2` below.
     */
    public val readinessV2: Output<ApplicationReadinessV2>
        get() = javaResource.readinessV2().applyValue({ args0 ->
            args0.let({ args0 ->
                applicationReadinessV2ToKotlin(args0)
            })
        })

    /**
     * Initial number of instances.
     */
    public val replicas: Output<Int>
        get() = javaResource.replicas().applyValue({ args0 -> args0 })

    /**
     * Security group ID.
     */
    public val securityGroupId: Output<String>
        get() = javaResource.securityGroupId().applyValue({ args0 -> args0 })

    /**
     * SLS  configuration.
     */
    public val slsConfigs: Output<String>?
        get() = javaResource.slsConfigs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of the resource. Valid values: `RUNNING`, `STOPPED`, `UNKNOWN`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Graceful offline timeout, the default is 30, the unit is seconds. The value range is 1~60. Valid values: [1,60].
     */
    public val terminationGracePeriodSeconds: Output<Int>
        get() = javaResource.terminationGracePeriodSeconds().applyValue({ args0 -> args0 })

    /**
     * Time zone. Default value: `Asia/Shanghai`.
     */
    public val timezone: Output<String>
        get() = javaResource.timezone().applyValue({ args0 -> args0 })

    /**
     * Tomcat file configuration, set to "{}" means to delete the configuration:  useDefaultConfig: Whether to use a custom configuration, if it is true, it means that the custom configuration is not used; if it is false, it means that the custom configuration is used. If you do not use custom configuration, the following parameter configuration will not take effect.  contextInputType: Select the access path of the application.  war: No need to fill in the custom path, the access path of the application is the WAR package name. root: No need to fill in the custom path, the access path of the application is /. custom: You need to fill in the custom path in the custom path below. contextPath: custom path, this parameter only needs to be configured when the contextInputType type is custom.  httpPort: The port range is 1024~65535. Ports less than 1024 need Root permission to operate. Because the container is configured with Admin permissions, please fill in a port greater than 1024. If not configured, the default is 8080. maxThreads: Configure the number of connections in the connection pool, the default size is 400. uriEncoding: Tomcat encoding format, including UTF-8, ISO-8859-1, GBK and GB2312. If not set, the default is ISO-8859-1. useBodyEncoding: Whether to use BodyEncoding for URL. Valid values: `contextInputType`, `contextPath`, `httpPort`, `maxThreads`, `uriEncoding`, `useBodyEncoding`, `useDefaultConfig`.
     * **NOTE:** Field `tomcat_config` has been deprecated from provider version 1.211.0. New field `tomcat_config_v2` instead.
     */
    @Deprecated(
        message = """
  Field `tomcat_config` has been deprecated from provider version 1.211.0. New field
      `tomcat_config_v2` instead.
  """,
    )
    public val tomcatConfig: Output<String>
        get() = javaResource.tomcatConfig().applyValue({ args0 -> args0 })

    /**
     * The Tomcat configuration. See `tomcat_config_v2` below.
     */
    public val tomcatConfigV2: Output<ApplicationTomcatConfigV2>
        get() = javaResource.tomcatConfigV2().applyValue({ args0 ->
            args0.let({ args0 ->
                applicationTomcatConfigV2ToKotlin(args0)
            })
        })

    /**
     * The update strategy. **NOTE:** Field `update_strategy` has been deprecated from provider version 1.211.0. New field `update_strategy_v2` instead.
     */
    @Deprecated(
        message = """
  Field `update_strategy` has been deprecated from provider version 1.211.0. New field
      `update_strategy_v2` instead.
  """,
    )
    public val updateStrategy: Output<String>
        get() = javaResource.updateStrategy().applyValue({ args0 -> args0 })

    /**
     * The release policy. See `update_strategy_v2` below.
     */
    public val updateStrategyV2: Output<ApplicationUpdateStrategyV2>
        get() = javaResource.updateStrategyV2().applyValue({ args0 ->
            args0.let({ args0 ->
                applicationUpdateStrategyV2ToKotlin(args0)
            })
        })

    /**
     * The vpc id.
     */
    public val vpcId: Output<String>?
        get() = javaResource.vpcId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The vswitch id. **NOTE:** From version 1.211.0, `vswitch_id` can be modified.
     */
    public val vswitchId: Output<String>?
        get() = javaResource.vswitchId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * WAR package launch application option. Application default startup command: java $JAVA_OPTS $CATALINA_OPTS [-Options] org.apache.catalina.startup.Bootstrap "$@" start.
     */
    public val warStartOptions: Output<String>?
        get() = javaResource.warStartOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The version of tomcat that the deployment package depends on. Image type applications are not supported.
     */
    public val webContainer: Output<String>?
        get() = javaResource.webContainer().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object ApplicationMapper : ResourceMapper<Application> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.sae.Application::class == javaResource::class

    override fun map(javaResource: Resource): Application = Application(
        javaResource as
            com.pulumi.alicloud.sae.Application,
    )
}

/**
 * @see [Application].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Application].
 */
public suspend fun application(name: String, block: suspend ApplicationResourceBuilder.() -> Unit): Application {
    val builder = ApplicationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Application].
 * @param name The _unique_ name of the resulting resource.
 */
public fun application(name: String): Application {
    val builder = ApplicationResourceBuilder()
    builder.name(name)
    return builder.build()
}
