@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin

import com.pulumi.alicloud.sae.ApplicationArgs.builder
import com.pulumi.alicloud.sae.kotlin.inputs.ApplicationConfigMapMountDescV2Args
import com.pulumi.alicloud.sae.kotlin.inputs.ApplicationConfigMapMountDescV2ArgsBuilder
import com.pulumi.alicloud.sae.kotlin.inputs.ApplicationCustomHostAliasV2Args
import com.pulumi.alicloud.sae.kotlin.inputs.ApplicationCustomHostAliasV2ArgsBuilder
import com.pulumi.alicloud.sae.kotlin.inputs.ApplicationKafkaConfigsArgs
import com.pulumi.alicloud.sae.kotlin.inputs.ApplicationKafkaConfigsArgsBuilder
import com.pulumi.alicloud.sae.kotlin.inputs.ApplicationLivenessV2Args
import com.pulumi.alicloud.sae.kotlin.inputs.ApplicationLivenessV2ArgsBuilder
import com.pulumi.alicloud.sae.kotlin.inputs.ApplicationNasConfigArgs
import com.pulumi.alicloud.sae.kotlin.inputs.ApplicationNasConfigArgsBuilder
import com.pulumi.alicloud.sae.kotlin.inputs.ApplicationOssMountDescsV2Args
import com.pulumi.alicloud.sae.kotlin.inputs.ApplicationOssMountDescsV2ArgsBuilder
import com.pulumi.alicloud.sae.kotlin.inputs.ApplicationPostStartV2Args
import com.pulumi.alicloud.sae.kotlin.inputs.ApplicationPostStartV2ArgsBuilder
import com.pulumi.alicloud.sae.kotlin.inputs.ApplicationPreStopV2Args
import com.pulumi.alicloud.sae.kotlin.inputs.ApplicationPreStopV2ArgsBuilder
import com.pulumi.alicloud.sae.kotlin.inputs.ApplicationPvtzDiscoverySvcArgs
import com.pulumi.alicloud.sae.kotlin.inputs.ApplicationPvtzDiscoverySvcArgsBuilder
import com.pulumi.alicloud.sae.kotlin.inputs.ApplicationReadinessV2Args
import com.pulumi.alicloud.sae.kotlin.inputs.ApplicationReadinessV2ArgsBuilder
import com.pulumi.alicloud.sae.kotlin.inputs.ApplicationTomcatConfigV2Args
import com.pulumi.alicloud.sae.kotlin.inputs.ApplicationTomcatConfigV2ArgsBuilder
import com.pulumi.alicloud.sae.kotlin.inputs.ApplicationUpdateStrategyV2Args
import com.pulumi.alicloud.sae.kotlin.inputs.ApplicationUpdateStrategyV2ArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Serverless App Engine (SAE) Application resource.
 * For information about Serverless App Engine (SAE) Application and how to use it, see [What is Application](https://www.alibabacloud.com/help/en/sae/latest/createapplication).
 * > **NOTE:** Available since v1.161.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const region = config.get("region") || "cn-hangzhou";
 * const name = config.get("name") || "tf-example";
 * const defaultInteger = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const default = alicloud.getRegions({
 *     current: true,
 * });
 * const defaultGetZones = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vswitchName: name,
 *     cidrBlock: "10.4.0.0/24",
 *     vpcId: defaultNetwork.id,
 *     zoneId: defaultGetZones.then(defaultGetZones => defaultGetZones.zones?.[0]?.id),
 * });
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {vpcId: defaultNetwork.id});
 * const defaultNamespace = new alicloud.sae.Namespace("default", {
 *     namespaceId: _default.then(_default => `${_default.regions?.[0]?.id}:example${defaultInteger.result}`),
 *     namespaceName: name,
 *     namespaceDescription: name,
 *     enableMicroRegistration: false,
 * });
 * const defaultApplication = new alicloud.sae.Application("default", {
 *     appDescription: name,
 *     appName: `${name}-${defaultInteger.result}`,
 *     namespaceId: defaultNamespace.id,
 *     imageUrl: _default.then(_default => `registry-vpc.${_default.regions?.[0]?.id}.aliyuncs.com/sae-demo-image/consumer:1.0`),
 *     packageType: "Image",
 *     securityGroupId: defaultSecurityGroup.id,
 *     vpcId: defaultNetwork.id,
 *     vswitchId: defaultSwitch.id,
 *     timezone: "Asia/Beijing",
 *     replicas: 5,
 *     cpu: 500,
 *     memory: 2048,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * region = config.get("region")
 * if region is None:
 *     region = "cn-hangzhou"
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default_integer = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * default = alicloud.get_regions(current=True)
 * default_get_zones = alicloud.get_zones(available_resource_creation="VSwitch")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vswitch_name=name,
 *     cidr_block="10.4.0.0/24",
 *     vpc_id=default_network.id,
 *     zone_id=default_get_zones.zones[0].id)
 * default_security_group = alicloud.ecs.SecurityGroup("default", vpc_id=default_network.id)
 * default_namespace = alicloud.sae.Namespace("default",
 *     namespace_id=f"{default.regions[0]&#46;id}:example{default_integer['result']}",
 *     namespace_name=name,
 *     namespace_description=name,
 *     enable_micro_registration=False)
 * default_application = alicloud.sae.Application("default",
 *     app_description=name,
 *     app_name=f"{name}-{default_integer['result']}",
 *     namespace_id=default_namespace.id,
 *     image_url=f"registry-vpc.{default.regions[0].id}.aliyuncs.com/sae-demo-image/consumer:1.0",
 *     package_type="Image",
 *     security_group_id=default_security_group.id,
 *     vpc_id=default_network.id,
 *     vswitch_id=default_switch.id,
 *     timezone="Asia/Beijing",
 *     replicas=5,
 *     cpu=500,
 *     memory=2048)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var region = config.Get("region") ?? "cn-hangzhou";
 *     var name = config.Get("name") ?? "tf-example";
 *     var defaultInteger = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var @default = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var defaultGetZones = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.4.0.0/24",
 *         VpcId = defaultNetwork.Id,
 *         ZoneId = defaultGetZones.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultNamespace = new AliCloud.Sae.Namespace("default", new()
 *     {
 *         NamespaceId = @default.Apply(@default => $"{@default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)}:example{defaultInteger.Result}"),
 *         NamespaceName = name,
 *         NamespaceDescription = name,
 *         EnableMicroRegistration = false,
 *     });
 *     var defaultApplication = new AliCloud.Sae.Application("default", new()
 *     {
 *         AppDescription = name,
 *         AppName = $"{name}-{defaultInteger.Result}",
 *         NamespaceId = defaultNamespace.Id,
 *         ImageUrl = @default.Apply(@default => $"registry-vpc.{@default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)}.aliyuncs.com/sae-demo-image/consumer:1.0"),
 *         PackageType = "Image",
 *         SecurityGroupId = defaultSecurityGroup.Id,
 *         VpcId = defaultNetwork.Id,
 *         VswitchId = defaultSwitch.Id,
 *         Timezone = "Asia/Beijing",
 *         Replicas = 5,
 *         Cpu = 500,
 *         Memory = 2048,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/sae"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		region := "cn-hangzhou"
 * 		if param := cfg.Get("region"); param != "" {
 * 			region = param
 * 		}
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		defaultInteger, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_default, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetZones, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.4.0.0/24"),
 * 			VpcId:       defaultNetwork.ID(),
 * 			ZoneId:      pulumi.String(defaultGetZones.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			VpcId: defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNamespace, err := sae.NewNamespace(ctx, "default", &sae.NamespaceArgs{
 * 			NamespaceId:             pulumi.Sprintf("%v:example%v", _default.Regions[0].Id, defaultInteger.Result),
 * 			NamespaceName:           pulumi.String(name),
 * 			NamespaceDescription:    pulumi.String(name),
 * 			EnableMicroRegistration: pulumi.Bool(false),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = sae.NewApplication(ctx, "default", &sae.ApplicationArgs{
 * 			AppDescription:  pulumi.String(name),
 * 			AppName:         pulumi.Sprintf("%v-%v", name, defaultInteger.Result),
 * 			NamespaceId:     defaultNamespace.ID(),
 * 			ImageUrl:        pulumi.Sprintf("registry-vpc.%v.aliyuncs.com/sae-demo-image/consumer:1.0", _default.Regions[0].Id),
 * 			PackageType:     pulumi.String("Image"),
 * 			SecurityGroupId: defaultSecurityGroup.ID(),
 * 			VpcId:           defaultNetwork.ID(),
 * 			VswitchId:       defaultSwitch.ID(),
 * 			Timezone:        pulumi.String("Asia/Beijing"),
 * 			Replicas:        pulumi.Int(5),
 * 			Cpu:             pulumi.Int(500),
 * 			Memory:          pulumi.Int(2048),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.sae.Namespace;
 * import com.pulumi.alicloud.sae.NamespaceArgs;
 * import com.pulumi.alicloud.sae.Application;
 * import com.pulumi.alicloud.sae.ApplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var region = config.get("region").orElse("cn-hangzhou");
 *         final var name = config.get("name").orElse("tf-example");
 *         var defaultInteger = new Integer("defaultInteger", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         final var default = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         final var defaultGetZones = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.4.0.0/24")
 *             .vpcId(defaultNetwork.id())
 *             .zoneId(defaultGetZones.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         var defaultNamespace = new Namespace("defaultNamespace", NamespaceArgs.builder()
 *             .namespaceId(String.format("%s:example%s", default_.regions()[0].id(),defaultInteger.result()))
 *             .namespaceName(name)
 *             .namespaceDescription(name)
 *             .enableMicroRegistration(false)
 *             .build());
 *         var defaultApplication = new Application("defaultApplication", ApplicationArgs.builder()
 *             .appDescription(name)
 *             .appName(String.format("%s-%s", name,defaultInteger.result()))
 *             .namespaceId(defaultNamespace.id())
 *             .imageUrl(String.format("registry-vpc.%s.aliyuncs.com/sae-demo-image/consumer:1.0", default_.regions()[0].id()))
 *             .packageType("Image")
 *             .securityGroupId(defaultSecurityGroup.id())
 *             .vpcId(defaultNetwork.id())
 *             .vswitchId(defaultSwitch.id())
 *             .timezone("Asia/Beijing")
 *             .replicas("5")
 *             .cpu("500")
 *             .memory("2048")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   region:
 *     type: string
 *     default: cn-hangzhou
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultInteger:
 *     type: random:integer
 *     name: default
 *     properties:
 *       max: 99999
 *       min: 10000
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.4.0.0/24
 *       vpcId: ${defaultNetwork.id}
 *       zoneId: ${defaultGetZones.zones[0].id}
 *   defaultSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *   defaultNamespace:
 *     type: alicloud:sae:Namespace
 *     name: default
 *     properties:
 *       namespaceId: ${default.regions[0].id}:example${defaultInteger.result}
 *       namespaceName: ${name}
 *       namespaceDescription: ${name}
 *       enableMicroRegistration: false
 *   defaultApplication:
 *     type: alicloud:sae:Application
 *     name: default
 *     properties:
 *       appDescription: ${name}
 *       appName: ${name}-${defaultInteger.result}
 *       namespaceId: ${defaultNamespace.id}
 *       imageUrl: registry-vpc.${default.regions[0].id}.aliyuncs.com/sae-demo-image/consumer:1.0
 *       packageType: Image
 *       securityGroupId: ${defaultSecurityGroup.id}
 *       vpcId: ${defaultNetwork.id}
 *       vswitchId: ${defaultSwitch.id}
 *       timezone: Asia/Beijing
 *       replicas: '5'
 *       cpu: '500'
 *       memory: '2048'
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 *   defaultGetZones:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Serverless App Engine (SAE) Application can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:sae/application:Application example <id>
 * ```
 * @property acrAssumeRoleArn The ARN of the RAM role required when pulling images across accounts. Only necessary if the image_url is pointing to an ACR EE instance.
 * @property acrInstanceId The ID of the ACR EE instance. Only necessary if the image_url is pointing to an ACR EE instance.
 * @property appDescription Application description information. No more than 1024 characters. **NOTE:** From version 1.211.0, `app_description` can be modified.
 * @property appName Application Name. Combinations of numbers, letters, and dashes (-) are allowed. It must start with a letter and the maximum length is 36 characters.
 * @property autoConfig The auto config. Valid values: `true`, `false`.
 * @property autoEnableApplicationScalingRule The auto enable application scaling rule. Valid values: `true`, `false`.
 * @property batchWaitTime The batch wait time.
 * @property changeOrderDesc The change order desc.
 * @property command Mirror start command. The command must be an executable object in the container. For example: sleep. Setting this command will cause the original startup command of the mirror to become invalid.
 * @property commandArgs Mirror startup command parameters. The parameters required for the above start command. For example: 1d. **NOTE:** Field `command_args` has been deprecated from provider version 1.211.0. New field `command_args_v2` instead.
 * @property commandArgsV2s The parameters of the image startup command.
 * @property configMapMountDesc ConfigMap mount description. **NOTE:** Field `config_map_mount_desc` has been deprecated from provider version 1.211.0. New field `config_map_mount_desc_v2` instead.
 * @property configMapMountDescV2s The description of the ConfigMap that is mounted to the application. A ConfigMap that is created on the ConfigMaps page of a namespace is used to inject configurations into containers. See `config_map_mount_desc_v2` below.
 * @property cpu The CPU required for each instance, in millicores, cannot be 0. Valid values: `500`, `1000`, `2000`, `4000`, `8000`, `16000`, `32000`.
 * @property customHostAlias Custom host mapping in the container. For example: [{`hostName`:`samplehost`,`ip`:`127&#46;0&#46;0&#46;1`}]. **NOTE:** Field `custom_host_alias` has been deprecated from provider version 1.211.0. New field `custom_host_alias_v2` instead.
 * @property customHostAliasV2s The custom mapping between the hostname and IP address in the container. See `custom_host_alias_v2` below.
 * @property deploy The deploy. Valid values: `true`, `false`.
 * @property edasContainerVersion The operating environment used by the Pandora application.
 * @property enableAhas The enable ahas. Valid values: `true`, `false`.
 * @property enableGreyTagRoute The enable grey tag route. Default value: `false`. Valid values:
 * @property envs Container environment variable parameters. For example,`	[{"name":"envtmp","value":"0"}]`. The value description is as follows:
 * @property imagePullSecrets The ID of the corresponding Secret.
 * @property imageUrl Mirror address. Only Image type applications can configure the mirror address.
 * @property jarStartArgs The JAR package starts application parameters. Application default startup command: $JAVA_HOME/bin/java $JarStartOptions -jar $CATALINA_OPTS "$package_path" $JarStartArgs.
 * @property jarStartOptions The JAR package starts the application option. Application default startup command: $JAVA_HOME/bin/java $JarStartOptions -jar $CATALINA_OPTS "$package_path" $JarStartArgs.
 * @property jdk The JDK version that the deployment package depends on. Image type applications are not supported.
 * @property kafkaConfigs The logging configurations of ApsaraMQ for Kafka. See `kafka_configs` below.
 * @property liveness Container health check. Containers that fail the health check will be shut down and restored. Currently, only the method of issuing commands in the container is supported.
 * **NOTE:** Field `liveness` has been deprecated from provider version 1.211.0. New field `liveness_v2` instead.
 * @property livenessV2 The liveness check settings of the container. See `liveness_v2` below.
 * @property memory The memory required for each instance, in MB, cannot be 0. One-to-one correspondence with CPU. Valid values: `1024`, `2048`, `4096`, `8192`, `12288`, `16384`, `24576`, `32768`, `65536`, `131072`.
 * @property microRegistration Select the Nacos registry. Valid values: `0`, `1`, `2`.
 * @property minReadyInstanceRatio Minimum Survival Instance Percentage. **NOTE:** When `min_ready_instances` and `min_ready_instance_ratio` are passed at the same time, and the value of `min_ready_instance_ratio` is not -1, the `min_ready_instance_ratio` parameter shall prevail. Assuming that `min_ready_instances` is 5 and `min_ready_instance_ratio` is 50, 50 is used to calculate the minimum number of surviving instances.The value description is as follows:
 * * `-1`: Initialization value, indicating that percentages are not used.
 * * `0~100`: The unit is percentage, rounded up. For example, if it is set to 50%, if there are currently 5 instances, the minimum number of surviving instances is 3.
 * @property minReadyInstances The Minimum Available Instance. On the Change Had Promised during the Available Number of Instances to Be.
 * @property namespaceId SAE namespace ID. Only namespaces whose names are lowercase letters and dashes (-) are supported, and must start with a letter. The namespace can be obtained by calling the DescribeNamespaceList interface.
 * @property nasConfigs The configurations for mounting the NAS file system. See `nas_configs` below.
 * @property ossAkId OSS AccessKey ID.
 * @property ossAkSecret OSS  AccessKey Secret.
 * @property ossMountDescs OSS mount description information. **NOTE:** Field `oss_mount_descs` has been deprecated from provider version 1.211.0. New field `oss_mount_descs_v2` instead.
 * @property ossMountDescsV2s The description of the mounted Object Storage Service (OSS) bucket. See `oss_mount_descs_v2` below.
 * @property packageType Application package type. Valid values: `FatJar`, `War`, `Image`, `PhpZip`, `IMAGE_PHP_5_4`, `IMAGE_PHP_5_4_ALPINE`, `IMAGE_PHP_5_5`, `IMAGE_PHP_5_5_ALPINE`, `IMAGE_PHP_5_6`, `IMAGE_PHP_5_6_ALPINE`, `IMAGE_PHP_7_0`, `IMAGE_PHP_7_0_ALPINE`, `IMAGE_PHP_7_1`, `IMAGE_PHP_7_1_ALPINE`, `IMAGE_PHP_7_2`, `IMAGE_PHP_7_2_ALPINE`, `IMAGE_PHP_7_3`, `IMAGE_PHP_7_3_ALPINE`, `PythonZip`.
 * @property packageUrl Deployment package address. Only FatJar or War type applications can configure the deployment package address.
 * @property packageVersion The version number of the deployment package. Required when the Package Type is War and FatJar.
 * @property php The Php environment.
 * @property phpArmsConfigLocation The PHP application monitors the mount path, and you need to ensure that the PHP server will load the configuration file of this path. You don't need to pay attention to the configuration content, SAE will automatically render the correct configuration file.
 * @property phpConfig PHP configuration file content.
 * @property phpConfigLocation PHP application startup configuration mount path, you need to ensure that the PHP server will start using this configuration file.
 * @property postStart Execute the script after startup, the format is like: {`exec`:{`command`:[`cat`,"/etc/group"]}}. **NOTE:** Field `post_start` has been deprecated from provider version 1.211.0. New field `post_start_v2` instead.
 * @property postStartV2 The script that is run immediately after the container is started. See `post_start_v2` below.
 * @property preStop Execute the script before stopping, the format is like: {`exec`:{`command`:[`cat`,"/etc/group"]}}. **NOTE:** Field `pre_stop` has been deprecated from provider version 1.211.0. New field `pre_stop_v2` instead.
 * @property preStopV2 The script that is run before the container is stopped. See `pre_stop_v2` below.
 * @property programmingLanguage The programming language that is used to create the application. Valid values: `java`, `php`, `other`.
 * @property pvtzDiscoverySvc The configurations of Kubernetes Service-based service registration and discovery. See `pvtz_discovery_svc` below.
 * @property readiness Application startup status checks, containers that fail multiple health checks will be shut down and restarted. Containers that do not pass the health check will not receive SLB traffic. For example: {`exec`:{`command`:[`sh`,"-c","cat /home/admin/start&#46;sh"]},`initialDelaySeconds`:30,`periodSeconds`:30,"timeoutSeconds ":2}. Valid values: `command`, `initialDelaySeconds`, `periodSeconds`, `timeoutSeconds`.
 * **NOTE:** Field `readiness` has been deprecated from provider version 1.211.0. New field `readiness_v2` instead.
 * @property readinessV2 The readiness check settings of the container. If a container fails this health check multiple times, the container is stopped and then restarted. See `readiness_v2` below.
 * @property replicas Initial number of instances.
 * @property securityGroupId Security group ID.
 * @property slsConfigs SLS  configuration.
 * @property status The status of the resource. Valid values: `RUNNING`, `STOPPED`, `UNKNOWN`.
 * @property tags A mapping of tags to assign to the resource.
 * @property terminationGracePeriodSeconds Graceful offline timeout, the default is 30, the unit is seconds. The value range is 1~60. Valid values: [1,60].
 * @property timezone Time zone. Default value: `Asia/Shanghai`.
 * @property tomcatConfig Tomcat file configuration, set to "{}" means to delete the configuration:  useDefaultConfig: Whether to use a custom configuration, if it is true, it means that the custom configuration is not used; if it is false, it means that the custom configuration is used. If you do not use custom configuration, the following parameter configuration will not take effect.  contextInputType: Select the access path of the application.  war: No need to fill in the custom path, the access path of the application is the WAR package name. root: No need to fill in the custom path, the access path of the application is /. custom: You need to fill in the custom path in the custom path below. contextPath: custom path, this parameter only needs to be configured when the contextInputType type is custom.  httpPort: The port range is 1024~65535. Ports less than 1024 need Root permission to operate. Because the container is configured with Admin permissions, please fill in a port greater than 1024. If not configured, the default is 8080. maxThreads: Configure the number of connections in the connection pool, the default size is 400. uriEncoding: Tomcat encoding format, including UTF-8, ISO-8859-1, GBK and GB2312. If not set, the default is ISO-8859-1. useBodyEncoding: Whether to use BodyEncoding for URL. Valid values: `contextInputType`, `contextPath`, `httpPort`, `maxThreads`, `uriEncoding`, `useBodyEncoding`, `useDefaultConfig`.
 * **NOTE:** Field `tomcat_config` has been deprecated from provider version 1.211.0. New field `tomcat_config_v2` instead.
 * @property tomcatConfigV2 The Tomcat configuration. See `tomcat_config_v2` below.
 * @property updateStrategy The update strategy. **NOTE:** Field `update_strategy` has been deprecated from provider version 1.211.0. New field `update_strategy_v2` instead.
 * @property updateStrategyV2 The release policy. See `update_strategy_v2` below.
 * @property vpcId The vpc id.
 * @property vswitchId The vswitch id. **NOTE:** From version 1.211.0, `vswitch_id` can be modified.
 * @property warStartOptions WAR package launch application option. Application default startup command: java $JAVA_OPTS $CATALINA_OPTS [-Options] org.apache.catalina.startup.Bootstrap "$@" start.
 * @property webContainer The version of tomcat that the deployment package depends on. Image type applications are not supported.
 */
public data class ApplicationArgs(
    public val acrAssumeRoleArn: Output<String>? = null,
    public val acrInstanceId: Output<String>? = null,
    public val appDescription: Output<String>? = null,
    public val appName: Output<String>? = null,
    public val autoConfig: Output<Boolean>? = null,
    public val autoEnableApplicationScalingRule: Output<Boolean>? = null,
    public val batchWaitTime: Output<Int>? = null,
    public val changeOrderDesc: Output<String>? = null,
    public val command: Output<String>? = null,
    @Deprecated(
        message = """
  Field `command_args` has been deprecated from provider version 1.211.0. New field
      `command_args_v2` instead.
  """,
    )
    public val commandArgs: Output<String>? = null,
    public val commandArgsV2s: Output<List<String>>? = null,
    @Deprecated(
        message = """
  Field `config_map_mount_desc` has been deprecated from provider version 1.211.0. New field
      `config_map_mount_desc_v2` instead.
  """,
    )
    public val configMapMountDesc: Output<String>? = null,
    public val configMapMountDescV2s: Output<List<ApplicationConfigMapMountDescV2Args>>? = null,
    public val cpu: Output<Int>? = null,
    @Deprecated(
        message = """
  Field `custom_host_alias` has been deprecated from provider version 1.211.0. New field
      `custom_host_alias_v2` instead.
  """,
    )
    public val customHostAlias: Output<String>? = null,
    public val customHostAliasV2s: Output<List<ApplicationCustomHostAliasV2Args>>? = null,
    public val deploy: Output<Boolean>? = null,
    public val edasContainerVersion: Output<String>? = null,
    public val enableAhas: Output<String>? = null,
    public val enableGreyTagRoute: Output<Boolean>? = null,
    public val envs: Output<String>? = null,
    public val imagePullSecrets: Output<String>? = null,
    public val imageUrl: Output<String>? = null,
    public val jarStartArgs: Output<String>? = null,
    public val jarStartOptions: Output<String>? = null,
    public val jdk: Output<String>? = null,
    public val kafkaConfigs: Output<ApplicationKafkaConfigsArgs>? = null,
    @Deprecated(
        message = """
  Field `liveness` has been deprecated from provider version 1.211.0. New field `liveness_v2`
      instead.
  """,
    )
    public val liveness: Output<String>? = null,
    public val livenessV2: Output<ApplicationLivenessV2Args>? = null,
    public val memory: Output<Int>? = null,
    public val microRegistration: Output<String>? = null,
    public val minReadyInstanceRatio: Output<Int>? = null,
    public val minReadyInstances: Output<Int>? = null,
    public val namespaceId: Output<String>? = null,
    public val nasConfigs: Output<List<ApplicationNasConfigArgs>>? = null,
    public val ossAkId: Output<String>? = null,
    public val ossAkSecret: Output<String>? = null,
    @Deprecated(
        message = """
  Field `oss_mount_descs` has been deprecated from provider version 1.211.0. New field
      `oss_mount_descs_v2` instead.
  """,
    )
    public val ossMountDescs: Output<String>? = null,
    public val ossMountDescsV2s: Output<List<ApplicationOssMountDescsV2Args>>? = null,
    public val packageType: Output<String>? = null,
    public val packageUrl: Output<String>? = null,
    public val packageVersion: Output<String>? = null,
    public val php: Output<String>? = null,
    public val phpArmsConfigLocation: Output<String>? = null,
    public val phpConfig: Output<String>? = null,
    public val phpConfigLocation: Output<String>? = null,
    @Deprecated(
        message = """
  Field `post_start` has been deprecated from provider version 1.211.0. New field `post_start_v2`
      instead.
  """,
    )
    public val postStart: Output<String>? = null,
    public val postStartV2: Output<ApplicationPostStartV2Args>? = null,
    @Deprecated(
        message = """
  Field `pre_stop` has been deprecated from provider version 1.211.0. New field `pre_stop_v2`
      instead.
  """,
    )
    public val preStop: Output<String>? = null,
    public val preStopV2: Output<ApplicationPreStopV2Args>? = null,
    public val programmingLanguage: Output<String>? = null,
    public val pvtzDiscoverySvc: Output<ApplicationPvtzDiscoverySvcArgs>? = null,
    @Deprecated(
        message = """
  Field `readiness` has been deprecated from provider version 1.211.0. New field `readiness_v2`
      instead.
  """,
    )
    public val readiness: Output<String>? = null,
    public val readinessV2: Output<ApplicationReadinessV2Args>? = null,
    public val replicas: Output<Int>? = null,
    public val securityGroupId: Output<String>? = null,
    public val slsConfigs: Output<String>? = null,
    public val status: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val terminationGracePeriodSeconds: Output<Int>? = null,
    public val timezone: Output<String>? = null,
    @Deprecated(
        message = """
  Field `tomcat_config` has been deprecated from provider version 1.211.0. New field
      `tomcat_config_v2` instead.
  """,
    )
    public val tomcatConfig: Output<String>? = null,
    public val tomcatConfigV2: Output<ApplicationTomcatConfigV2Args>? = null,
    @Deprecated(
        message = """
  Field `update_strategy` has been deprecated from provider version 1.211.0. New field
      `update_strategy_v2` instead.
  """,
    )
    public val updateStrategy: Output<String>? = null,
    public val updateStrategyV2: Output<ApplicationUpdateStrategyV2Args>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
    public val warStartOptions: Output<String>? = null,
    public val webContainer: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sae.ApplicationArgs> {
    override fun toJava(): com.pulumi.alicloud.sae.ApplicationArgs =
        com.pulumi.alicloud.sae.ApplicationArgs.builder()
            .acrAssumeRoleArn(acrAssumeRoleArn?.applyValue({ args0 -> args0 }))
            .acrInstanceId(acrInstanceId?.applyValue({ args0 -> args0 }))
            .appDescription(appDescription?.applyValue({ args0 -> args0 }))
            .appName(appName?.applyValue({ args0 -> args0 }))
            .autoConfig(autoConfig?.applyValue({ args0 -> args0 }))
            .autoEnableApplicationScalingRule(autoEnableApplicationScalingRule?.applyValue({ args0 -> args0 }))
            .batchWaitTime(batchWaitTime?.applyValue({ args0 -> args0 }))
            .changeOrderDesc(changeOrderDesc?.applyValue({ args0 -> args0 }))
            .command(command?.applyValue({ args0 -> args0 }))
            .commandArgs(commandArgs?.applyValue({ args0 -> args0 }))
            .commandArgsV2s(commandArgsV2s?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .configMapMountDesc(configMapMountDesc?.applyValue({ args0 -> args0 }))
            .configMapMountDescV2s(
                configMapMountDescV2s?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .cpu(cpu?.applyValue({ args0 -> args0 }))
            .customHostAlias(customHostAlias?.applyValue({ args0 -> args0 }))
            .customHostAliasV2s(
                customHostAliasV2s?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .deploy(deploy?.applyValue({ args0 -> args0 }))
            .edasContainerVersion(edasContainerVersion?.applyValue({ args0 -> args0 }))
            .enableAhas(enableAhas?.applyValue({ args0 -> args0 }))
            .enableGreyTagRoute(enableGreyTagRoute?.applyValue({ args0 -> args0 }))
            .envs(envs?.applyValue({ args0 -> args0 }))
            .imagePullSecrets(imagePullSecrets?.applyValue({ args0 -> args0 }))
            .imageUrl(imageUrl?.applyValue({ args0 -> args0 }))
            .jarStartArgs(jarStartArgs?.applyValue({ args0 -> args0 }))
            .jarStartOptions(jarStartOptions?.applyValue({ args0 -> args0 }))
            .jdk(jdk?.applyValue({ args0 -> args0 }))
            .kafkaConfigs(kafkaConfigs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .liveness(liveness?.applyValue({ args0 -> args0 }))
            .livenessV2(livenessV2?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .memory(memory?.applyValue({ args0 -> args0 }))
            .microRegistration(microRegistration?.applyValue({ args0 -> args0 }))
            .minReadyInstanceRatio(minReadyInstanceRatio?.applyValue({ args0 -> args0 }))
            .minReadyInstances(minReadyInstances?.applyValue({ args0 -> args0 }))
            .namespaceId(namespaceId?.applyValue({ args0 -> args0 }))
            .nasConfigs(
                nasConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ossAkId(ossAkId?.applyValue({ args0 -> args0 }))
            .ossAkSecret(ossAkSecret?.applyValue({ args0 -> args0 }))
            .ossMountDescs(ossMountDescs?.applyValue({ args0 -> args0 }))
            .ossMountDescsV2s(
                ossMountDescsV2s?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .packageType(packageType?.applyValue({ args0 -> args0 }))
            .packageUrl(packageUrl?.applyValue({ args0 -> args0 }))
            .packageVersion(packageVersion?.applyValue({ args0 -> args0 }))
            .php(php?.applyValue({ args0 -> args0 }))
            .phpArmsConfigLocation(phpArmsConfigLocation?.applyValue({ args0 -> args0 }))
            .phpConfig(phpConfig?.applyValue({ args0 -> args0 }))
            .phpConfigLocation(phpConfigLocation?.applyValue({ args0 -> args0 }))
            .postStart(postStart?.applyValue({ args0 -> args0 }))
            .postStartV2(postStartV2?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .preStop(preStop?.applyValue({ args0 -> args0 }))
            .preStopV2(preStopV2?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .programmingLanguage(programmingLanguage?.applyValue({ args0 -> args0 }))
            .pvtzDiscoverySvc(pvtzDiscoverySvc?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .readiness(readiness?.applyValue({ args0 -> args0 }))
            .readinessV2(readinessV2?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .replicas(replicas?.applyValue({ args0 -> args0 }))
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .slsConfigs(slsConfigs?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .terminationGracePeriodSeconds(terminationGracePeriodSeconds?.applyValue({ args0 -> args0 }))
            .timezone(timezone?.applyValue({ args0 -> args0 }))
            .tomcatConfig(tomcatConfig?.applyValue({ args0 -> args0 }))
            .tomcatConfigV2(tomcatConfigV2?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .updateStrategy(updateStrategy?.applyValue({ args0 -> args0 }))
            .updateStrategyV2(updateStrategyV2?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .warStartOptions(warStartOptions?.applyValue({ args0 -> args0 }))
            .webContainer(webContainer?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationArgs].
 */
@PulumiTagMarker
public class ApplicationArgsBuilder internal constructor() {
    private var acrAssumeRoleArn: Output<String>? = null

    private var acrInstanceId: Output<String>? = null

    private var appDescription: Output<String>? = null

    private var appName: Output<String>? = null

    private var autoConfig: Output<Boolean>? = null

    private var autoEnableApplicationScalingRule: Output<Boolean>? = null

    private var batchWaitTime: Output<Int>? = null

    private var changeOrderDesc: Output<String>? = null

    private var command: Output<String>? = null

    private var commandArgs: Output<String>? = null

    private var commandArgsV2s: Output<List<String>>? = null

    private var configMapMountDesc: Output<String>? = null

    private var configMapMountDescV2s: Output<List<ApplicationConfigMapMountDescV2Args>>? = null

    private var cpu: Output<Int>? = null

    private var customHostAlias: Output<String>? = null

    private var customHostAliasV2s: Output<List<ApplicationCustomHostAliasV2Args>>? = null

    private var deploy: Output<Boolean>? = null

    private var edasContainerVersion: Output<String>? = null

    private var enableAhas: Output<String>? = null

    private var enableGreyTagRoute: Output<Boolean>? = null

    private var envs: Output<String>? = null

    private var imagePullSecrets: Output<String>? = null

    private var imageUrl: Output<String>? = null

    private var jarStartArgs: Output<String>? = null

    private var jarStartOptions: Output<String>? = null

    private var jdk: Output<String>? = null

    private var kafkaConfigs: Output<ApplicationKafkaConfigsArgs>? = null

    private var liveness: Output<String>? = null

    private var livenessV2: Output<ApplicationLivenessV2Args>? = null

    private var memory: Output<Int>? = null

    private var microRegistration: Output<String>? = null

    private var minReadyInstanceRatio: Output<Int>? = null

    private var minReadyInstances: Output<Int>? = null

    private var namespaceId: Output<String>? = null

    private var nasConfigs: Output<List<ApplicationNasConfigArgs>>? = null

    private var ossAkId: Output<String>? = null

    private var ossAkSecret: Output<String>? = null

    private var ossMountDescs: Output<String>? = null

    private var ossMountDescsV2s: Output<List<ApplicationOssMountDescsV2Args>>? = null

    private var packageType: Output<String>? = null

    private var packageUrl: Output<String>? = null

    private var packageVersion: Output<String>? = null

    private var php: Output<String>? = null

    private var phpArmsConfigLocation: Output<String>? = null

    private var phpConfig: Output<String>? = null

    private var phpConfigLocation: Output<String>? = null

    private var postStart: Output<String>? = null

    private var postStartV2: Output<ApplicationPostStartV2Args>? = null

    private var preStop: Output<String>? = null

    private var preStopV2: Output<ApplicationPreStopV2Args>? = null

    private var programmingLanguage: Output<String>? = null

    private var pvtzDiscoverySvc: Output<ApplicationPvtzDiscoverySvcArgs>? = null

    private var readiness: Output<String>? = null

    private var readinessV2: Output<ApplicationReadinessV2Args>? = null

    private var replicas: Output<Int>? = null

    private var securityGroupId: Output<String>? = null

    private var slsConfigs: Output<String>? = null

    private var status: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var terminationGracePeriodSeconds: Output<Int>? = null

    private var timezone: Output<String>? = null

    private var tomcatConfig: Output<String>? = null

    private var tomcatConfigV2: Output<ApplicationTomcatConfigV2Args>? = null

    private var updateStrategy: Output<String>? = null

    private var updateStrategyV2: Output<ApplicationUpdateStrategyV2Args>? = null

    private var vpcId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    private var warStartOptions: Output<String>? = null

    private var webContainer: Output<String>? = null

    /**
     * @param value The ARN of the RAM role required when pulling images across accounts. Only necessary if the image_url is pointing to an ACR EE instance.
     */
    @JvmName("odtkwahgroesrxss")
    public suspend fun acrAssumeRoleArn(`value`: Output<String>) {
        this.acrAssumeRoleArn = value
    }

    /**
     * @param value The ID of the ACR EE instance. Only necessary if the image_url is pointing to an ACR EE instance.
     */
    @JvmName("jfaowpaxhyamtsfd")
    public suspend fun acrInstanceId(`value`: Output<String>) {
        this.acrInstanceId = value
    }

    /**
     * @param value Application description information. No more than 1024 characters. **NOTE:** From version 1.211.0, `app_description` can be modified.
     */
    @JvmName("srvukrrcpfekedkw")
    public suspend fun appDescription(`value`: Output<String>) {
        this.appDescription = value
    }

    /**
     * @param value Application Name. Combinations of numbers, letters, and dashes (-) are allowed. It must start with a letter and the maximum length is 36 characters.
     */
    @JvmName("kgucdrpkoltgwcod")
    public suspend fun appName(`value`: Output<String>) {
        this.appName = value
    }

    /**
     * @param value The auto config. Valid values: `true`, `false`.
     */
    @JvmName("rahwciuuqadttmfs")
    public suspend fun autoConfig(`value`: Output<Boolean>) {
        this.autoConfig = value
    }

    /**
     * @param value The auto enable application scaling rule. Valid values: `true`, `false`.
     */
    @JvmName("soyyumqaipqnjjnm")
    public suspend fun autoEnableApplicationScalingRule(`value`: Output<Boolean>) {
        this.autoEnableApplicationScalingRule = value
    }

    /**
     * @param value The batch wait time.
     */
    @JvmName("ffhcqsueeseetypi")
    public suspend fun batchWaitTime(`value`: Output<Int>) {
        this.batchWaitTime = value
    }

    /**
     * @param value The change order desc.
     */
    @JvmName("fsqiatoeotclnnft")
    public suspend fun changeOrderDesc(`value`: Output<String>) {
        this.changeOrderDesc = value
    }

    /**
     * @param value Mirror start command. The command must be an executable object in the container. For example: sleep. Setting this command will cause the original startup command of the mirror to become invalid.
     */
    @JvmName("omfeuwbsvgcrnorc")
    public suspend fun command(`value`: Output<String>) {
        this.command = value
    }

    /**
     * @param value Mirror startup command parameters. The parameters required for the above start command. For example: 1d. **NOTE:** Field `command_args` has been deprecated from provider version 1.211.0. New field `command_args_v2` instead.
     */
    @Deprecated(
        message = """
  Field `command_args` has been deprecated from provider version 1.211.0. New field
      `command_args_v2` instead.
  """,
    )
    @JvmName("wyehpflvbqixhxbc")
    public suspend fun commandArgs(`value`: Output<String>) {
        this.commandArgs = value
    }

    /**
     * @param value The parameters of the image startup command.
     */
    @JvmName("ufytivtfluuemfvu")
    public suspend fun commandArgsV2s(`value`: Output<List<String>>) {
        this.commandArgsV2s = value
    }

    @JvmName("omynfqsckvbgwyxw")
    public suspend fun commandArgsV2s(vararg values: Output<String>) {
        this.commandArgsV2s = Output.all(values.asList())
    }

    /**
     * @param values The parameters of the image startup command.
     */
    @JvmName("gwwapiimfttnyccu")
    public suspend fun commandArgsV2s(values: List<Output<String>>) {
        this.commandArgsV2s = Output.all(values)
    }

    /**
     * @param value ConfigMap mount description. **NOTE:** Field `config_map_mount_desc` has been deprecated from provider version 1.211.0. New field `config_map_mount_desc_v2` instead.
     */
    @Deprecated(
        message = """
  Field `config_map_mount_desc` has been deprecated from provider version 1.211.0. New field
      `config_map_mount_desc_v2` instead.
  """,
    )
    @JvmName("ucaqywboqkbtutlt")
    public suspend fun configMapMountDesc(`value`: Output<String>) {
        this.configMapMountDesc = value
    }

    /**
     * @param value The description of the ConfigMap that is mounted to the application. A ConfigMap that is created on the ConfigMaps page of a namespace is used to inject configurations into containers. See `config_map_mount_desc_v2` below.
     */
    @JvmName("mqvosjlbmoqkivtj")
    public suspend fun configMapMountDescV2s(`value`: Output<List<ApplicationConfigMapMountDescV2Args>>) {
        this.configMapMountDescV2s = value
    }

    @JvmName("efxrrecvefpdwcas")
    public suspend fun configMapMountDescV2s(vararg values: Output<ApplicationConfigMapMountDescV2Args>) {
        this.configMapMountDescV2s = Output.all(values.asList())
    }

    /**
     * @param values The description of the ConfigMap that is mounted to the application. A ConfigMap that is created on the ConfigMaps page of a namespace is used to inject configurations into containers. See `config_map_mount_desc_v2` below.
     */
    @JvmName("dtvwogltmclmxxjk")
    public suspend fun configMapMountDescV2s(values: List<Output<ApplicationConfigMapMountDescV2Args>>) {
        this.configMapMountDescV2s = Output.all(values)
    }

    /**
     * @param value The CPU required for each instance, in millicores, cannot be 0. Valid values: `500`, `1000`, `2000`, `4000`, `8000`, `16000`, `32000`.
     */
    @JvmName("iwlqeepjfkhpxsep")
    public suspend fun cpu(`value`: Output<Int>) {
        this.cpu = value
    }

    /**
     * @param value Custom host mapping in the container. For example: [{`hostName`:`samplehost`,`ip`:`127&#46;0&#46;0&#46;1`}]. **NOTE:** Field `custom_host_alias` has been deprecated from provider version 1.211.0. New field `custom_host_alias_v2` instead.
     */
    @Deprecated(
        message = """
  Field `custom_host_alias` has been deprecated from provider version 1.211.0. New field
      `custom_host_alias_v2` instead.
  """,
    )
    @JvmName("txtgmghgwdjifpvb")
    public suspend fun customHostAlias(`value`: Output<String>) {
        this.customHostAlias = value
    }

    /**
     * @param value The custom mapping between the hostname and IP address in the container. See `custom_host_alias_v2` below.
     */
    @JvmName("xisfwsbxfvqlcppt")
    public suspend fun customHostAliasV2s(`value`: Output<List<ApplicationCustomHostAliasV2Args>>) {
        this.customHostAliasV2s = value
    }

    @JvmName("byecnnvcfqpmuqbu")
    public suspend fun customHostAliasV2s(vararg values: Output<ApplicationCustomHostAliasV2Args>) {
        this.customHostAliasV2s = Output.all(values.asList())
    }

    /**
     * @param values The custom mapping between the hostname and IP address in the container. See `custom_host_alias_v2` below.
     */
    @JvmName("ofrlgffybkxshwov")
    public suspend fun customHostAliasV2s(values: List<Output<ApplicationCustomHostAliasV2Args>>) {
        this.customHostAliasV2s = Output.all(values)
    }

    /**
     * @param value The deploy. Valid values: `true`, `false`.
     */
    @JvmName("gmihfsxesdfbkcba")
    public suspend fun deploy(`value`: Output<Boolean>) {
        this.deploy = value
    }

    /**
     * @param value The operating environment used by the Pandora application.
     */
    @JvmName("cqtqnepvmrgmgpyc")
    public suspend fun edasContainerVersion(`value`: Output<String>) {
        this.edasContainerVersion = value
    }

    /**
     * @param value The enable ahas. Valid values: `true`, `false`.
     */
    @JvmName("ggclndyrarwcvkvu")
    public suspend fun enableAhas(`value`: Output<String>) {
        this.enableAhas = value
    }

    /**
     * @param value The enable grey tag route. Default value: `false`. Valid values:
     */
    @JvmName("jmbonahjjexiyskc")
    public suspend fun enableGreyTagRoute(`value`: Output<Boolean>) {
        this.enableGreyTagRoute = value
    }

    /**
     * @param value Container environment variable parameters. For example,`	[{"name":"envtmp","value":"0"}]`. The value description is as follows:
     */
    @JvmName("lmqgxpkrshnmebom")
    public suspend fun envs(`value`: Output<String>) {
        this.envs = value
    }

    /**
     * @param value The ID of the corresponding Secret.
     */
    @JvmName("xinknsmhiljbgbab")
    public suspend fun imagePullSecrets(`value`: Output<String>) {
        this.imagePullSecrets = value
    }

    /**
     * @param value Mirror address. Only Image type applications can configure the mirror address.
     */
    @JvmName("hkuwnrojgaxcmjoo")
    public suspend fun imageUrl(`value`: Output<String>) {
        this.imageUrl = value
    }

    /**
     * @param value The JAR package starts application parameters. Application default startup command: $JAVA_HOME/bin/java $JarStartOptions -jar $CATALINA_OPTS "$package_path" $JarStartArgs.
     */
    @JvmName("btmsjermammwbccf")
    public suspend fun jarStartArgs(`value`: Output<String>) {
        this.jarStartArgs = value
    }

    /**
     * @param value The JAR package starts the application option. Application default startup command: $JAVA_HOME/bin/java $JarStartOptions -jar $CATALINA_OPTS "$package_path" $JarStartArgs.
     */
    @JvmName("nqihktuncdblgnqt")
    public suspend fun jarStartOptions(`value`: Output<String>) {
        this.jarStartOptions = value
    }

    /**
     * @param value The JDK version that the deployment package depends on. Image type applications are not supported.
     */
    @JvmName("daeshjaerlrrrdup")
    public suspend fun jdk(`value`: Output<String>) {
        this.jdk = value
    }

    /**
     * @param value The logging configurations of ApsaraMQ for Kafka. See `kafka_configs` below.
     */
    @JvmName("elgwqwkvrbopefrd")
    public suspend fun kafkaConfigs(`value`: Output<ApplicationKafkaConfigsArgs>) {
        this.kafkaConfigs = value
    }

    /**
     * @param value Container health check. Containers that fail the health check will be shut down and restored. Currently, only the method of issuing commands in the container is supported.
     * **NOTE:** Field `liveness` has been deprecated from provider version 1.211.0. New field `liveness_v2` instead.
     */
    @Deprecated(
        message = """
  Field `liveness` has been deprecated from provider version 1.211.0. New field `liveness_v2`
      instead.
  """,
    )
    @JvmName("eljhtddergcfemkx")
    public suspend fun liveness(`value`: Output<String>) {
        this.liveness = value
    }

    /**
     * @param value The liveness check settings of the container. See `liveness_v2` below.
     */
    @JvmName("amsnobirvriewots")
    public suspend fun livenessV2(`value`: Output<ApplicationLivenessV2Args>) {
        this.livenessV2 = value
    }

    /**
     * @param value The memory required for each instance, in MB, cannot be 0. One-to-one correspondence with CPU. Valid values: `1024`, `2048`, `4096`, `8192`, `12288`, `16384`, `24576`, `32768`, `65536`, `131072`.
     */
    @JvmName("euagjyupjrcjuimq")
    public suspend fun memory(`value`: Output<Int>) {
        this.memory = value
    }

    /**
     * @param value Select the Nacos registry. Valid values: `0`, `1`, `2`.
     */
    @JvmName("clusybjcudxpydjw")
    public suspend fun microRegistration(`value`: Output<String>) {
        this.microRegistration = value
    }

    /**
     * @param value Minimum Survival Instance Percentage. **NOTE:** When `min_ready_instances` and `min_ready_instance_ratio` are passed at the same time, and the value of `min_ready_instance_ratio` is not -1, the `min_ready_instance_ratio` parameter shall prevail. Assuming that `min_ready_instances` is 5 and `min_ready_instance_ratio` is 50, 50 is used to calculate the minimum number of surviving instances.The value description is as follows:
     * * `-1`: Initialization value, indicating that percentages are not used.
     * * `0~100`: The unit is percentage, rounded up. For example, if it is set to 50%, if there are currently 5 instances, the minimum number of surviving instances is 3.
     */
    @JvmName("rwntjhabsfklrfcg")
    public suspend fun minReadyInstanceRatio(`value`: Output<Int>) {
        this.minReadyInstanceRatio = value
    }

    /**
     * @param value The Minimum Available Instance. On the Change Had Promised during the Available Number of Instances to Be.
     */
    @JvmName("rlhbskakekfbvetm")
    public suspend fun minReadyInstances(`value`: Output<Int>) {
        this.minReadyInstances = value
    }

    /**
     * @param value SAE namespace ID. Only namespaces whose names are lowercase letters and dashes (-) are supported, and must start with a letter. The namespace can be obtained by calling the DescribeNamespaceList interface.
     */
    @JvmName("dsbfxlxcmfshmgca")
    public suspend fun namespaceId(`value`: Output<String>) {
        this.namespaceId = value
    }

    /**
     * @param value The configurations for mounting the NAS file system. See `nas_configs` below.
     */
    @JvmName("euvqlkvrywpfimgr")
    public suspend fun nasConfigs(`value`: Output<List<ApplicationNasConfigArgs>>) {
        this.nasConfigs = value
    }

    @JvmName("cdbkfbwqnvdqglar")
    public suspend fun nasConfigs(vararg values: Output<ApplicationNasConfigArgs>) {
        this.nasConfigs = Output.all(values.asList())
    }

    /**
     * @param values The configurations for mounting the NAS file system. See `nas_configs` below.
     */
    @JvmName("evyfurkjvrdjbeqd")
    public suspend fun nasConfigs(values: List<Output<ApplicationNasConfigArgs>>) {
        this.nasConfigs = Output.all(values)
    }

    /**
     * @param value OSS AccessKey ID.
     */
    @JvmName("becqiiablcfgvkky")
    public suspend fun ossAkId(`value`: Output<String>) {
        this.ossAkId = value
    }

    /**
     * @param value OSS  AccessKey Secret.
     */
    @JvmName("afebdqvdwnfdtaut")
    public suspend fun ossAkSecret(`value`: Output<String>) {
        this.ossAkSecret = value
    }

    /**
     * @param value OSS mount description information. **NOTE:** Field `oss_mount_descs` has been deprecated from provider version 1.211.0. New field `oss_mount_descs_v2` instead.
     */
    @Deprecated(
        message = """
  Field `oss_mount_descs` has been deprecated from provider version 1.211.0. New field
      `oss_mount_descs_v2` instead.
  """,
    )
    @JvmName("ejbuwhcqafxkpqft")
    public suspend fun ossMountDescs(`value`: Output<String>) {
        this.ossMountDescs = value
    }

    /**
     * @param value The description of the mounted Object Storage Service (OSS) bucket. See `oss_mount_descs_v2` below.
     */
    @JvmName("bhdvmgxyhqfdooca")
    public suspend fun ossMountDescsV2s(`value`: Output<List<ApplicationOssMountDescsV2Args>>) {
        this.ossMountDescsV2s = value
    }

    @JvmName("ihtypxpktueotfjq")
    public suspend fun ossMountDescsV2s(vararg values: Output<ApplicationOssMountDescsV2Args>) {
        this.ossMountDescsV2s = Output.all(values.asList())
    }

    /**
     * @param values The description of the mounted Object Storage Service (OSS) bucket. See `oss_mount_descs_v2` below.
     */
    @JvmName("gaeapgummmentdgn")
    public suspend fun ossMountDescsV2s(values: List<Output<ApplicationOssMountDescsV2Args>>) {
        this.ossMountDescsV2s = Output.all(values)
    }

    /**
     * @param value Application package type. Valid values: `FatJar`, `War`, `Image`, `PhpZip`, `IMAGE_PHP_5_4`, `IMAGE_PHP_5_4_ALPINE`, `IMAGE_PHP_5_5`, `IMAGE_PHP_5_5_ALPINE`, `IMAGE_PHP_5_6`, `IMAGE_PHP_5_6_ALPINE`, `IMAGE_PHP_7_0`, `IMAGE_PHP_7_0_ALPINE`, `IMAGE_PHP_7_1`, `IMAGE_PHP_7_1_ALPINE`, `IMAGE_PHP_7_2`, `IMAGE_PHP_7_2_ALPINE`, `IMAGE_PHP_7_3`, `IMAGE_PHP_7_3_ALPINE`, `PythonZip`.
     */
    @JvmName("syptchhoxytmsvyq")
    public suspend fun packageType(`value`: Output<String>) {
        this.packageType = value
    }

    /**
     * @param value Deployment package address. Only FatJar or War type applications can configure the deployment package address.
     */
    @JvmName("agvocrckeyglbhgy")
    public suspend fun packageUrl(`value`: Output<String>) {
        this.packageUrl = value
    }

    /**
     * @param value The version number of the deployment package. Required when the Package Type is War and FatJar.
     */
    @JvmName("ctyiqsjqersjxhpg")
    public suspend fun packageVersion(`value`: Output<String>) {
        this.packageVersion = value
    }

    /**
     * @param value The Php environment.
     */
    @JvmName("ouncpwterwqgxurw")
    public suspend fun php(`value`: Output<String>) {
        this.php = value
    }

    /**
     * @param value The PHP application monitors the mount path, and you need to ensure that the PHP server will load the configuration file of this path. You don't need to pay attention to the configuration content, SAE will automatically render the correct configuration file.
     */
    @JvmName("frtljhwtqatycudt")
    public suspend fun phpArmsConfigLocation(`value`: Output<String>) {
        this.phpArmsConfigLocation = value
    }

    /**
     * @param value PHP configuration file content.
     */
    @JvmName("fgpmuxflemecousn")
    public suspend fun phpConfig(`value`: Output<String>) {
        this.phpConfig = value
    }

    /**
     * @param value PHP application startup configuration mount path, you need to ensure that the PHP server will start using this configuration file.
     */
    @JvmName("rlebrlcjeauheany")
    public suspend fun phpConfigLocation(`value`: Output<String>) {
        this.phpConfigLocation = value
    }

    /**
     * @param value Execute the script after startup, the format is like: {`exec`:{`command`:[`cat`,"/etc/group"]}}. **NOTE:** Field `post_start` has been deprecated from provider version 1.211.0. New field `post_start_v2` instead.
     */
    @Deprecated(
        message = """
  Field `post_start` has been deprecated from provider version 1.211.0. New field `post_start_v2`
      instead.
  """,
    )
    @JvmName("ivbcocecsycseoqi")
    public suspend fun postStart(`value`: Output<String>) {
        this.postStart = value
    }

    /**
     * @param value The script that is run immediately after the container is started. See `post_start_v2` below.
     */
    @JvmName("qaskwsrwvxxmiuyr")
    public suspend fun postStartV2(`value`: Output<ApplicationPostStartV2Args>) {
        this.postStartV2 = value
    }

    /**
     * @param value Execute the script before stopping, the format is like: {`exec`:{`command`:[`cat`,"/etc/group"]}}. **NOTE:** Field `pre_stop` has been deprecated from provider version 1.211.0. New field `pre_stop_v2` instead.
     */
    @Deprecated(
        message = """
  Field `pre_stop` has been deprecated from provider version 1.211.0. New field `pre_stop_v2`
      instead.
  """,
    )
    @JvmName("hxsnxferoyqiixwo")
    public suspend fun preStop(`value`: Output<String>) {
        this.preStop = value
    }

    /**
     * @param value The script that is run before the container is stopped. See `pre_stop_v2` below.
     */
    @JvmName("mpkyfythfcqfriwg")
    public suspend fun preStopV2(`value`: Output<ApplicationPreStopV2Args>) {
        this.preStopV2 = value
    }

    /**
     * @param value The programming language that is used to create the application. Valid values: `java`, `php`, `other`.
     */
    @JvmName("tbwatudteebvuotj")
    public suspend fun programmingLanguage(`value`: Output<String>) {
        this.programmingLanguage = value
    }

    /**
     * @param value The configurations of Kubernetes Service-based service registration and discovery. See `pvtz_discovery_svc` below.
     */
    @JvmName("ixusseusmqsnwbas")
    public suspend fun pvtzDiscoverySvc(`value`: Output<ApplicationPvtzDiscoverySvcArgs>) {
        this.pvtzDiscoverySvc = value
    }

    /**
     * @param value Application startup status checks, containers that fail multiple health checks will be shut down and restarted. Containers that do not pass the health check will not receive SLB traffic. For example: {`exec`:{`command`:[`sh`,"-c","cat /home/admin/start&#46;sh"]},`initialDelaySeconds`:30,`periodSeconds`:30,"timeoutSeconds ":2}. Valid values: `command`, `initialDelaySeconds`, `periodSeconds`, `timeoutSeconds`.
     * **NOTE:** Field `readiness` has been deprecated from provider version 1.211.0. New field `readiness_v2` instead.
     */
    @Deprecated(
        message = """
  Field `readiness` has been deprecated from provider version 1.211.0. New field `readiness_v2`
      instead.
  """,
    )
    @JvmName("qmfarrrbjikvcfne")
    public suspend fun readiness(`value`: Output<String>) {
        this.readiness = value
    }

    /**
     * @param value The readiness check settings of the container. If a container fails this health check multiple times, the container is stopped and then restarted. See `readiness_v2` below.
     */
    @JvmName("gnnsmkqsmcscltkv")
    public suspend fun readinessV2(`value`: Output<ApplicationReadinessV2Args>) {
        this.readinessV2 = value
    }

    /**
     * @param value Initial number of instances.
     */
    @JvmName("ktttoqfbgempequh")
    public suspend fun replicas(`value`: Output<Int>) {
        this.replicas = value
    }

    /**
     * @param value Security group ID.
     */
    @JvmName("fidnmaoywpaxrcex")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value SLS  configuration.
     */
    @JvmName("uklckgqlaefujmwo")
    public suspend fun slsConfigs(`value`: Output<String>) {
        this.slsConfigs = value
    }

    /**
     * @param value The status of the resource. Valid values: `RUNNING`, `STOPPED`, `UNKNOWN`.
     */
    @JvmName("phluojuppjscjfpd")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("ihlsquewlmiwyscf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Graceful offline timeout, the default is 30, the unit is seconds. The value range is 1~60. Valid values: [1,60].
     */
    @JvmName("jomkbbnasqcxptgk")
    public suspend fun terminationGracePeriodSeconds(`value`: Output<Int>) {
        this.terminationGracePeriodSeconds = value
    }

    /**
     * @param value Time zone. Default value: `Asia/Shanghai`.
     */
    @JvmName("tcrqpwdnelncksmc")
    public suspend fun timezone(`value`: Output<String>) {
        this.timezone = value
    }

    /**
     * @param value Tomcat file configuration, set to "{}" means to delete the configuration:  useDefaultConfig: Whether to use a custom configuration, if it is true, it means that the custom configuration is not used; if it is false, it means that the custom configuration is used. If you do not use custom configuration, the following parameter configuration will not take effect.  contextInputType: Select the access path of the application.  war: No need to fill in the custom path, the access path of the application is the WAR package name. root: No need to fill in the custom path, the access path of the application is /. custom: You need to fill in the custom path in the custom path below. contextPath: custom path, this parameter only needs to be configured when the contextInputType type is custom.  httpPort: The port range is 1024~65535. Ports less than 1024 need Root permission to operate. Because the container is configured with Admin permissions, please fill in a port greater than 1024. If not configured, the default is 8080. maxThreads: Configure the number of connections in the connection pool, the default size is 400. uriEncoding: Tomcat encoding format, including UTF-8, ISO-8859-1, GBK and GB2312. If not set, the default is ISO-8859-1. useBodyEncoding: Whether to use BodyEncoding for URL. Valid values: `contextInputType`, `contextPath`, `httpPort`, `maxThreads`, `uriEncoding`, `useBodyEncoding`, `useDefaultConfig`.
     * **NOTE:** Field `tomcat_config` has been deprecated from provider version 1.211.0. New field `tomcat_config_v2` instead.
     */
    @Deprecated(
        message = """
  Field `tomcat_config` has been deprecated from provider version 1.211.0. New field
      `tomcat_config_v2` instead.
  """,
    )
    @JvmName("yuohqdexhmrpovdp")
    public suspend fun tomcatConfig(`value`: Output<String>) {
        this.tomcatConfig = value
    }

    /**
     * @param value The Tomcat configuration. See `tomcat_config_v2` below.
     */
    @JvmName("gubqmbwrtgfimfcl")
    public suspend fun tomcatConfigV2(`value`: Output<ApplicationTomcatConfigV2Args>) {
        this.tomcatConfigV2 = value
    }

    /**
     * @param value The update strategy. **NOTE:** Field `update_strategy` has been deprecated from provider version 1.211.0. New field `update_strategy_v2` instead.
     */
    @Deprecated(
        message = """
  Field `update_strategy` has been deprecated from provider version 1.211.0. New field
      `update_strategy_v2` instead.
  """,
    )
    @JvmName("efiikvegdjacpvgc")
    public suspend fun updateStrategy(`value`: Output<String>) {
        this.updateStrategy = value
    }

    /**
     * @param value The release policy. See `update_strategy_v2` below.
     */
    @JvmName("ktnppsnqcnefvsob")
    public suspend fun updateStrategyV2(`value`: Output<ApplicationUpdateStrategyV2Args>) {
        this.updateStrategyV2 = value
    }

    /**
     * @param value The vpc id.
     */
    @JvmName("uqqxnieowegqxbno")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The vswitch id. **NOTE:** From version 1.211.0, `vswitch_id` can be modified.
     */
    @JvmName("tofjjgmsmjoywuqs")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value WAR package launch application option. Application default startup command: java $JAVA_OPTS $CATALINA_OPTS [-Options] org.apache.catalina.startup.Bootstrap "$@" start.
     */
    @JvmName("gfgsttrpnfordhmi")
    public suspend fun warStartOptions(`value`: Output<String>) {
        this.warStartOptions = value
    }

    /**
     * @param value The version of tomcat that the deployment package depends on. Image type applications are not supported.
     */
    @JvmName("raecoumofcmtkmjr")
    public suspend fun webContainer(`value`: Output<String>) {
        this.webContainer = value
    }

    /**
     * @param value The ARN of the RAM role required when pulling images across accounts. Only necessary if the image_url is pointing to an ACR EE instance.
     */
    @JvmName("iocvbcmgiealekat")
    public suspend fun acrAssumeRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acrAssumeRoleArn = mapped
    }

    /**
     * @param value The ID of the ACR EE instance. Only necessary if the image_url is pointing to an ACR EE instance.
     */
    @JvmName("nmeyrkfxdlgybtin")
    public suspend fun acrInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acrInstanceId = mapped
    }

    /**
     * @param value Application description information. No more than 1024 characters. **NOTE:** From version 1.211.0, `app_description` can be modified.
     */
    @JvmName("nonrnojqqwrwupai")
    public suspend fun appDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appDescription = mapped
    }

    /**
     * @param value Application Name. Combinations of numbers, letters, and dashes (-) are allowed. It must start with a letter and the maximum length is 36 characters.
     */
    @JvmName("decafdhelknqgpjo")
    public suspend fun appName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appName = mapped
    }

    /**
     * @param value The auto config. Valid values: `true`, `false`.
     */
    @JvmName("tqirulnwgpsjyycc")
    public suspend fun autoConfig(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoConfig = mapped
    }

    /**
     * @param value The auto enable application scaling rule. Valid values: `true`, `false`.
     */
    @JvmName("bgkegtpabqnuwvqw")
    public suspend fun autoEnableApplicationScalingRule(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoEnableApplicationScalingRule = mapped
    }

    /**
     * @param value The batch wait time.
     */
    @JvmName("cdgvjsqyjictbfor")
    public suspend fun batchWaitTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batchWaitTime = mapped
    }

    /**
     * @param value The change order desc.
     */
    @JvmName("urghykixeywjtfmy")
    public suspend fun changeOrderDesc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.changeOrderDesc = mapped
    }

    /**
     * @param value Mirror start command. The command must be an executable object in the container. For example: sleep. Setting this command will cause the original startup command of the mirror to become invalid.
     */
    @JvmName("kskyjxltassktmpw")
    public suspend fun command(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.command = mapped
    }

    /**
     * @param value Mirror startup command parameters. The parameters required for the above start command. For example: 1d. **NOTE:** Field `command_args` has been deprecated from provider version 1.211.0. New field `command_args_v2` instead.
     */
    @Deprecated(
        message = """
  Field `command_args` has been deprecated from provider version 1.211.0. New field
      `command_args_v2` instead.
  """,
    )
    @JvmName("gmnpmsvaxqyivjer")
    public suspend fun commandArgs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commandArgs = mapped
    }

    /**
     * @param value The parameters of the image startup command.
     */
    @JvmName("xdyqimhpmscnppab")
    public suspend fun commandArgsV2s(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commandArgsV2s = mapped
    }

    /**
     * @param values The parameters of the image startup command.
     */
    @JvmName("epsaenvofqdsarqc")
    public suspend fun commandArgsV2s(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.commandArgsV2s = mapped
    }

    /**
     * @param value ConfigMap mount description. **NOTE:** Field `config_map_mount_desc` has been deprecated from provider version 1.211.0. New field `config_map_mount_desc_v2` instead.
     */
    @Deprecated(
        message = """
  Field `config_map_mount_desc` has been deprecated from provider version 1.211.0. New field
      `config_map_mount_desc_v2` instead.
  """,
    )
    @JvmName("jmexuwqcjgxrtgox")
    public suspend fun configMapMountDesc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configMapMountDesc = mapped
    }

    /**
     * @param value The description of the ConfigMap that is mounted to the application. A ConfigMap that is created on the ConfigMaps page of a namespace is used to inject configurations into containers. See `config_map_mount_desc_v2` below.
     */
    @JvmName("pcfqruqhhrbhfwun")
    public suspend fun configMapMountDescV2s(`value`: List<ApplicationConfigMapMountDescV2Args>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configMapMountDescV2s = mapped
    }

    /**
     * @param argument The description of the ConfigMap that is mounted to the application. A ConfigMap that is created on the ConfigMaps page of a namespace is used to inject configurations into containers. See `config_map_mount_desc_v2` below.
     */
    @JvmName("guuvnxhbnebritym")
    public suspend fun configMapMountDescV2s(argument: List<suspend ApplicationConfigMapMountDescV2ArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationConfigMapMountDescV2ArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.configMapMountDescV2s = mapped
    }

    /**
     * @param argument The description of the ConfigMap that is mounted to the application. A ConfigMap that is created on the ConfigMaps page of a namespace is used to inject configurations into containers. See `config_map_mount_desc_v2` below.
     */
    @JvmName("ewufwroaelnyycku")
    public suspend fun configMapMountDescV2s(vararg argument: suspend ApplicationConfigMapMountDescV2ArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ApplicationConfigMapMountDescV2ArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.configMapMountDescV2s = mapped
    }

    /**
     * @param argument The description of the ConfigMap that is mounted to the application. A ConfigMap that is created on the ConfigMaps page of a namespace is used to inject configurations into containers. See `config_map_mount_desc_v2` below.
     */
    @JvmName("ybiikjfdodnhoftf")
    public suspend fun configMapMountDescV2s(argument: suspend ApplicationConfigMapMountDescV2ArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationConfigMapMountDescV2ArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.configMapMountDescV2s = mapped
    }

    /**
     * @param values The description of the ConfigMap that is mounted to the application. A ConfigMap that is created on the ConfigMaps page of a namespace is used to inject configurations into containers. See `config_map_mount_desc_v2` below.
     */
    @JvmName("ddkvbmxplahmvkeh")
    public suspend fun configMapMountDescV2s(vararg values: ApplicationConfigMapMountDescV2Args) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configMapMountDescV2s = mapped
    }

    /**
     * @param value The CPU required for each instance, in millicores, cannot be 0. Valid values: `500`, `1000`, `2000`, `4000`, `8000`, `16000`, `32000`.
     */
    @JvmName("qhtvuwcywymbanfc")
    public suspend fun cpu(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpu = mapped
    }

    /**
     * @param value Custom host mapping in the container. For example: [{`hostName`:`samplehost`,`ip`:`127&#46;0&#46;0&#46;1`}]. **NOTE:** Field `custom_host_alias` has been deprecated from provider version 1.211.0. New field `custom_host_alias_v2` instead.
     */
    @Deprecated(
        message = """
  Field `custom_host_alias` has been deprecated from provider version 1.211.0. New field
      `custom_host_alias_v2` instead.
  """,
    )
    @JvmName("nkpqchtytfpoiekw")
    public suspend fun customHostAlias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customHostAlias = mapped
    }

    /**
     * @param value The custom mapping between the hostname and IP address in the container. See `custom_host_alias_v2` below.
     */
    @JvmName("qmstxoedpshomoeb")
    public suspend fun customHostAliasV2s(`value`: List<ApplicationCustomHostAliasV2Args>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customHostAliasV2s = mapped
    }

    /**
     * @param argument The custom mapping between the hostname and IP address in the container. See `custom_host_alias_v2` below.
     */
    @JvmName("rsmgkeashjpvdijp")
    public suspend fun customHostAliasV2s(argument: List<suspend ApplicationCustomHostAliasV2ArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationCustomHostAliasV2ArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customHostAliasV2s = mapped
    }

    /**
     * @param argument The custom mapping between the hostname and IP address in the container. See `custom_host_alias_v2` below.
     */
    @JvmName("qttabdahhxmiejow")
    public suspend fun customHostAliasV2s(vararg argument: suspend ApplicationCustomHostAliasV2ArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ApplicationCustomHostAliasV2ArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customHostAliasV2s = mapped
    }

    /**
     * @param argument The custom mapping between the hostname and IP address in the container. See `custom_host_alias_v2` below.
     */
    @JvmName("savtbvxmdrcamxit")
    public suspend fun customHostAliasV2s(argument: suspend ApplicationCustomHostAliasV2ArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationCustomHostAliasV2ArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.customHostAliasV2s = mapped
    }

    /**
     * @param values The custom mapping between the hostname and IP address in the container. See `custom_host_alias_v2` below.
     */
    @JvmName("cnuwgmhadolqxbqr")
    public suspend fun customHostAliasV2s(vararg values: ApplicationCustomHostAliasV2Args) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customHostAliasV2s = mapped
    }

    /**
     * @param value The deploy. Valid values: `true`, `false`.
     */
    @JvmName("atuypqlitxforgvu")
    public suspend fun deploy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploy = mapped
    }

    /**
     * @param value The operating environment used by the Pandora application.
     */
    @JvmName("nxstbmvbjxwyooyd")
    public suspend fun edasContainerVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.edasContainerVersion = mapped
    }

    /**
     * @param value The enable ahas. Valid values: `true`, `false`.
     */
    @JvmName("vggfrivcteidcklm")
    public suspend fun enableAhas(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAhas = mapped
    }

    /**
     * @param value The enable grey tag route. Default value: `false`. Valid values:
     */
    @JvmName("acfofqpxytxpbgln")
    public suspend fun enableGreyTagRoute(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableGreyTagRoute = mapped
    }

    /**
     * @param value Container environment variable parameters. For example,`	[{"name":"envtmp","value":"0"}]`. The value description is as follows:
     */
    @JvmName("sqkamkhdvfahphex")
    public suspend fun envs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.envs = mapped
    }

    /**
     * @param value The ID of the corresponding Secret.
     */
    @JvmName("xxastsaeyorvwjof")
    public suspend fun imagePullSecrets(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imagePullSecrets = mapped
    }

    /**
     * @param value Mirror address. Only Image type applications can configure the mirror address.
     */
    @JvmName("xldfwmrrtprouhbm")
    public suspend fun imageUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageUrl = mapped
    }

    /**
     * @param value The JAR package starts application parameters. Application default startup command: $JAVA_HOME/bin/java $JarStartOptions -jar $CATALINA_OPTS "$package_path" $JarStartArgs.
     */
    @JvmName("njitsfsjhtqxbyfc")
    public suspend fun jarStartArgs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jarStartArgs = mapped
    }

    /**
     * @param value The JAR package starts the application option. Application default startup command: $JAVA_HOME/bin/java $JarStartOptions -jar $CATALINA_OPTS "$package_path" $JarStartArgs.
     */
    @JvmName("pavuxkxftoiiatsm")
    public suspend fun jarStartOptions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jarStartOptions = mapped
    }

    /**
     * @param value The JDK version that the deployment package depends on. Image type applications are not supported.
     */
    @JvmName("ijlsayahvfcnqqiv")
    public suspend fun jdk(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jdk = mapped
    }

    /**
     * @param value The logging configurations of ApsaraMQ for Kafka. See `kafka_configs` below.
     */
    @JvmName("crlvggqwopyskyec")
    public suspend fun kafkaConfigs(`value`: ApplicationKafkaConfigsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kafkaConfigs = mapped
    }

    /**
     * @param argument The logging configurations of ApsaraMQ for Kafka. See `kafka_configs` below.
     */
    @JvmName("bugfqsipuepdachp")
    public suspend fun kafkaConfigs(argument: suspend ApplicationKafkaConfigsArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationKafkaConfigsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.kafkaConfigs = mapped
    }

    /**
     * @param value Container health check. Containers that fail the health check will be shut down and restored. Currently, only the method of issuing commands in the container is supported.
     * **NOTE:** Field `liveness` has been deprecated from provider version 1.211.0. New field `liveness_v2` instead.
     */
    @Deprecated(
        message = """
  Field `liveness` has been deprecated from provider version 1.211.0. New field `liveness_v2`
      instead.
  """,
    )
    @JvmName("jgootsmkjymlipxs")
    public suspend fun liveness(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.liveness = mapped
    }

    /**
     * @param value The liveness check settings of the container. See `liveness_v2` below.
     */
    @JvmName("fpcgmgytbbwpsjuu")
    public suspend fun livenessV2(`value`: ApplicationLivenessV2Args?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.livenessV2 = mapped
    }

    /**
     * @param argument The liveness check settings of the container. See `liveness_v2` below.
     */
    @JvmName("krckxgkruleiomnt")
    public suspend fun livenessV2(argument: suspend ApplicationLivenessV2ArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationLivenessV2ArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.livenessV2 = mapped
    }

    /**
     * @param value The memory required for each instance, in MB, cannot be 0. One-to-one correspondence with CPU. Valid values: `1024`, `2048`, `4096`, `8192`, `12288`, `16384`, `24576`, `32768`, `65536`, `131072`.
     */
    @JvmName("wrhgwpxuowynctlu")
    public suspend fun memory(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memory = mapped
    }

    /**
     * @param value Select the Nacos registry. Valid values: `0`, `1`, `2`.
     */
    @JvmName("gstxbtjhfjhbspyd")
    public suspend fun microRegistration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.microRegistration = mapped
    }

    /**
     * @param value Minimum Survival Instance Percentage. **NOTE:** When `min_ready_instances` and `min_ready_instance_ratio` are passed at the same time, and the value of `min_ready_instance_ratio` is not -1, the `min_ready_instance_ratio` parameter shall prevail. Assuming that `min_ready_instances` is 5 and `min_ready_instance_ratio` is 50, 50 is used to calculate the minimum number of surviving instances.The value description is as follows:
     * * `-1`: Initialization value, indicating that percentages are not used.
     * * `0~100`: The unit is percentage, rounded up. For example, if it is set to 50%, if there are currently 5 instances, the minimum number of surviving instances is 3.
     */
    @JvmName("krlppadebeasrfhg")
    public suspend fun minReadyInstanceRatio(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minReadyInstanceRatio = mapped
    }

    /**
     * @param value The Minimum Available Instance. On the Change Had Promised during the Available Number of Instances to Be.
     */
    @JvmName("wehpnahypgldldof")
    public suspend fun minReadyInstances(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minReadyInstances = mapped
    }

    /**
     * @param value SAE namespace ID. Only namespaces whose names are lowercase letters and dashes (-) are supported, and must start with a letter. The namespace can be obtained by calling the DescribeNamespaceList interface.
     */
    @JvmName("lxrjqdhujtlmxlcs")
    public suspend fun namespaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceId = mapped
    }

    /**
     * @param value The configurations for mounting the NAS file system. See `nas_configs` below.
     */
    @JvmName("pwjecdnqgmieavtv")
    public suspend fun nasConfigs(`value`: List<ApplicationNasConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nasConfigs = mapped
    }

    /**
     * @param argument The configurations for mounting the NAS file system. See `nas_configs` below.
     */
    @JvmName("pkrmgigoucnxqtns")
    public suspend fun nasConfigs(argument: List<suspend ApplicationNasConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationNasConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.nasConfigs = mapped
    }

    /**
     * @param argument The configurations for mounting the NAS file system. See `nas_configs` below.
     */
    @JvmName("jipckgiebbnrhkps")
    public suspend fun nasConfigs(vararg argument: suspend ApplicationNasConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ApplicationNasConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.nasConfigs = mapped
    }

    /**
     * @param argument The configurations for mounting the NAS file system. See `nas_configs` below.
     */
    @JvmName("rchykebqhbbrsdqy")
    public suspend fun nasConfigs(argument: suspend ApplicationNasConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ApplicationNasConfigArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.nasConfigs = mapped
    }

    /**
     * @param values The configurations for mounting the NAS file system. See `nas_configs` below.
     */
    @JvmName("hvbvlfnddmgchdtn")
    public suspend fun nasConfigs(vararg values: ApplicationNasConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nasConfigs = mapped
    }

    /**
     * @param value OSS AccessKey ID.
     */
    @JvmName("oeprdaaedygialkp")
    public suspend fun ossAkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ossAkId = mapped
    }

    /**
     * @param value OSS  AccessKey Secret.
     */
    @JvmName("wcfgysrtldirdkqp")
    public suspend fun ossAkSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ossAkSecret = mapped
    }

    /**
     * @param value OSS mount description information. **NOTE:** Field `oss_mount_descs` has been deprecated from provider version 1.211.0. New field `oss_mount_descs_v2` instead.
     */
    @Deprecated(
        message = """
  Field `oss_mount_descs` has been deprecated from provider version 1.211.0. New field
      `oss_mount_descs_v2` instead.
  """,
    )
    @JvmName("oopewhkcdijvdxco")
    public suspend fun ossMountDescs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ossMountDescs = mapped
    }

    /**
     * @param value The description of the mounted Object Storage Service (OSS) bucket. See `oss_mount_descs_v2` below.
     */
    @JvmName("obdsjhocmmystkfc")
    public suspend fun ossMountDescsV2s(`value`: List<ApplicationOssMountDescsV2Args>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ossMountDescsV2s = mapped
    }

    /**
     * @param argument The description of the mounted Object Storage Service (OSS) bucket. See `oss_mount_descs_v2` below.
     */
    @JvmName("joarwhvvxmhpseod")
    public suspend fun ossMountDescsV2s(argument: List<suspend ApplicationOssMountDescsV2ArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationOssMountDescsV2ArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ossMountDescsV2s = mapped
    }

    /**
     * @param argument The description of the mounted Object Storage Service (OSS) bucket. See `oss_mount_descs_v2` below.
     */
    @JvmName("gjryocjulihfmnxf")
    public suspend fun ossMountDescsV2s(vararg argument: suspend ApplicationOssMountDescsV2ArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ApplicationOssMountDescsV2ArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ossMountDescsV2s = mapped
    }

    /**
     * @param argument The description of the mounted Object Storage Service (OSS) bucket. See `oss_mount_descs_v2` below.
     */
    @JvmName("nyjxyyntuefofvxy")
    public suspend fun ossMountDescsV2s(argument: suspend ApplicationOssMountDescsV2ArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationOssMountDescsV2ArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ossMountDescsV2s = mapped
    }

    /**
     * @param values The description of the mounted Object Storage Service (OSS) bucket. See `oss_mount_descs_v2` below.
     */
    @JvmName("clhywjxtfrxtubwu")
    public suspend fun ossMountDescsV2s(vararg values: ApplicationOssMountDescsV2Args) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ossMountDescsV2s = mapped
    }

    /**
     * @param value Application package type. Valid values: `FatJar`, `War`, `Image`, `PhpZip`, `IMAGE_PHP_5_4`, `IMAGE_PHP_5_4_ALPINE`, `IMAGE_PHP_5_5`, `IMAGE_PHP_5_5_ALPINE`, `IMAGE_PHP_5_6`, `IMAGE_PHP_5_6_ALPINE`, `IMAGE_PHP_7_0`, `IMAGE_PHP_7_0_ALPINE`, `IMAGE_PHP_7_1`, `IMAGE_PHP_7_1_ALPINE`, `IMAGE_PHP_7_2`, `IMAGE_PHP_7_2_ALPINE`, `IMAGE_PHP_7_3`, `IMAGE_PHP_7_3_ALPINE`, `PythonZip`.
     */
    @JvmName("qcjlcnmlnxwtgoge")
    public suspend fun packageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageType = mapped
    }

    /**
     * @param value Deployment package address. Only FatJar or War type applications can configure the deployment package address.
     */
    @JvmName("ffxeghjytvdgomfy")
    public suspend fun packageUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageUrl = mapped
    }

    /**
     * @param value The version number of the deployment package. Required when the Package Type is War and FatJar.
     */
    @JvmName("jpwjmxfqqvlybqbw")
    public suspend fun packageVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageVersion = mapped
    }

    /**
     * @param value The Php environment.
     */
    @JvmName("mvaolmwaownqcxcu")
    public suspend fun php(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.php = mapped
    }

    /**
     * @param value The PHP application monitors the mount path, and you need to ensure that the PHP server will load the configuration file of this path. You don't need to pay attention to the configuration content, SAE will automatically render the correct configuration file.
     */
    @JvmName("tfynypsnsuadlerv")
    public suspend fun phpArmsConfigLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.phpArmsConfigLocation = mapped
    }

    /**
     * @param value PHP configuration file content.
     */
    @JvmName("uitgxfwupruxanmr")
    public suspend fun phpConfig(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.phpConfig = mapped
    }

    /**
     * @param value PHP application startup configuration mount path, you need to ensure that the PHP server will start using this configuration file.
     */
    @JvmName("gaobkxkokvllekmv")
    public suspend fun phpConfigLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.phpConfigLocation = mapped
    }

    /**
     * @param value Execute the script after startup, the format is like: {`exec`:{`command`:[`cat`,"/etc/group"]}}. **NOTE:** Field `post_start` has been deprecated from provider version 1.211.0. New field `post_start_v2` instead.
     */
    @Deprecated(
        message = """
  Field `post_start` has been deprecated from provider version 1.211.0. New field `post_start_v2`
      instead.
  """,
    )
    @JvmName("cornlcdxthfoximy")
    public suspend fun postStart(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.postStart = mapped
    }

    /**
     * @param value The script that is run immediately after the container is started. See `post_start_v2` below.
     */
    @JvmName("xujjqcpwnupltoth")
    public suspend fun postStartV2(`value`: ApplicationPostStartV2Args?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.postStartV2 = mapped
    }

    /**
     * @param argument The script that is run immediately after the container is started. See `post_start_v2` below.
     */
    @JvmName("hdcdlsfiygwndwvp")
    public suspend fun postStartV2(argument: suspend ApplicationPostStartV2ArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationPostStartV2ArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.postStartV2 = mapped
    }

    /**
     * @param value Execute the script before stopping, the format is like: {`exec`:{`command`:[`cat`,"/etc/group"]}}. **NOTE:** Field `pre_stop` has been deprecated from provider version 1.211.0. New field `pre_stop_v2` instead.
     */
    @Deprecated(
        message = """
  Field `pre_stop` has been deprecated from provider version 1.211.0. New field `pre_stop_v2`
      instead.
  """,
    )
    @JvmName("mwycffibvtuuiaey")
    public suspend fun preStop(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preStop = mapped
    }

    /**
     * @param value The script that is run before the container is stopped. See `pre_stop_v2` below.
     */
    @JvmName("katayxvsvbuahvwt")
    public suspend fun preStopV2(`value`: ApplicationPreStopV2Args?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preStopV2 = mapped
    }

    /**
     * @param argument The script that is run before the container is stopped. See `pre_stop_v2` below.
     */
    @JvmName("frgxwnxdwoaaiiqi")
    public suspend fun preStopV2(argument: suspend ApplicationPreStopV2ArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationPreStopV2ArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.preStopV2 = mapped
    }

    /**
     * @param value The programming language that is used to create the application. Valid values: `java`, `php`, `other`.
     */
    @JvmName("niofcexfefwpxsxj")
    public suspend fun programmingLanguage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.programmingLanguage = mapped
    }

    /**
     * @param value The configurations of Kubernetes Service-based service registration and discovery. See `pvtz_discovery_svc` below.
     */
    @JvmName("irifnntedapsrjuc")
    public suspend fun pvtzDiscoverySvc(`value`: ApplicationPvtzDiscoverySvcArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pvtzDiscoverySvc = mapped
    }

    /**
     * @param argument The configurations of Kubernetes Service-based service registration and discovery. See `pvtz_discovery_svc` below.
     */
    @JvmName("trmgeqxhlocefhyv")
    public suspend fun pvtzDiscoverySvc(argument: suspend ApplicationPvtzDiscoverySvcArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationPvtzDiscoverySvcArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.pvtzDiscoverySvc = mapped
    }

    /**
     * @param value Application startup status checks, containers that fail multiple health checks will be shut down and restarted. Containers that do not pass the health check will not receive SLB traffic. For example: {`exec`:{`command`:[`sh`,"-c","cat /home/admin/start&#46;sh"]},`initialDelaySeconds`:30,`periodSeconds`:30,"timeoutSeconds ":2}. Valid values: `command`, `initialDelaySeconds`, `periodSeconds`, `timeoutSeconds`.
     * **NOTE:** Field `readiness` has been deprecated from provider version 1.211.0. New field `readiness_v2` instead.
     */
    @Deprecated(
        message = """
  Field `readiness` has been deprecated from provider version 1.211.0. New field `readiness_v2`
      instead.
  """,
    )
    @JvmName("ekxnhieiqysxqjrq")
    public suspend fun readiness(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readiness = mapped
    }

    /**
     * @param value The readiness check settings of the container. If a container fails this health check multiple times, the container is stopped and then restarted. See `readiness_v2` below.
     */
    @JvmName("gqypbktxdnuvoupc")
    public suspend fun readinessV2(`value`: ApplicationReadinessV2Args?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readinessV2 = mapped
    }

    /**
     * @param argument The readiness check settings of the container. If a container fails this health check multiple times, the container is stopped and then restarted. See `readiness_v2` below.
     */
    @JvmName("aphqxmlaotfnwhjh")
    public suspend fun readinessV2(argument: suspend ApplicationReadinessV2ArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationReadinessV2ArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.readinessV2 = mapped
    }

    /**
     * @param value Initial number of instances.
     */
    @JvmName("skwtygdwkwjvoijm")
    public suspend fun replicas(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicas = mapped
    }

    /**
     * @param value Security group ID.
     */
    @JvmName("swkgylxaxeyygvhk")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value SLS  configuration.
     */
    @JvmName("trchetdchjifuidv")
    public suspend fun slsConfigs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slsConfigs = mapped
    }

    /**
     * @param value The status of the resource. Valid values: `RUNNING`, `STOPPED`, `UNKNOWN`.
     */
    @JvmName("lffxxxsmofwanuky")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("oywnelnnfiyntqwi")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("pdgytlpotsxuxtee")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Graceful offline timeout, the default is 30, the unit is seconds. The value range is 1~60. Valid values: [1,60].
     */
    @JvmName("cajmfomwffgnxnyy")
    public suspend fun terminationGracePeriodSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.terminationGracePeriodSeconds = mapped
    }

    /**
     * @param value Time zone. Default value: `Asia/Shanghai`.
     */
    @JvmName("xqdnsyvyebrbovsr")
    public suspend fun timezone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timezone = mapped
    }

    /**
     * @param value Tomcat file configuration, set to "{}" means to delete the configuration:  useDefaultConfig: Whether to use a custom configuration, if it is true, it means that the custom configuration is not used; if it is false, it means that the custom configuration is used. If you do not use custom configuration, the following parameter configuration will not take effect.  contextInputType: Select the access path of the application.  war: No need to fill in the custom path, the access path of the application is the WAR package name. root: No need to fill in the custom path, the access path of the application is /. custom: You need to fill in the custom path in the custom path below. contextPath: custom path, this parameter only needs to be configured when the contextInputType type is custom.  httpPort: The port range is 1024~65535. Ports less than 1024 need Root permission to operate. Because the container is configured with Admin permissions, please fill in a port greater than 1024. If not configured, the default is 8080. maxThreads: Configure the number of connections in the connection pool, the default size is 400. uriEncoding: Tomcat encoding format, including UTF-8, ISO-8859-1, GBK and GB2312. If not set, the default is ISO-8859-1. useBodyEncoding: Whether to use BodyEncoding for URL. Valid values: `contextInputType`, `contextPath`, `httpPort`, `maxThreads`, `uriEncoding`, `useBodyEncoding`, `useDefaultConfig`.
     * **NOTE:** Field `tomcat_config` has been deprecated from provider version 1.211.0. New field `tomcat_config_v2` instead.
     */
    @Deprecated(
        message = """
  Field `tomcat_config` has been deprecated from provider version 1.211.0. New field
      `tomcat_config_v2` instead.
  """,
    )
    @JvmName("iekhjdbwkjqeytdb")
    public suspend fun tomcatConfig(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tomcatConfig = mapped
    }

    /**
     * @param value The Tomcat configuration. See `tomcat_config_v2` below.
     */
    @JvmName("mbttrbvypmsakqyy")
    public suspend fun tomcatConfigV2(`value`: ApplicationTomcatConfigV2Args?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tomcatConfigV2 = mapped
    }

    /**
     * @param argument The Tomcat configuration. See `tomcat_config_v2` below.
     */
    @JvmName("utfcuxeplvnmlalf")
    public suspend fun tomcatConfigV2(argument: suspend ApplicationTomcatConfigV2ArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationTomcatConfigV2ArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tomcatConfigV2 = mapped
    }

    /**
     * @param value The update strategy. **NOTE:** Field `update_strategy` has been deprecated from provider version 1.211.0. New field `update_strategy_v2` instead.
     */
    @Deprecated(
        message = """
  Field `update_strategy` has been deprecated from provider version 1.211.0. New field
      `update_strategy_v2` instead.
  """,
    )
    @JvmName("bpqyfcbqmiusabyt")
    public suspend fun updateStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.updateStrategy = mapped
    }

    /**
     * @param value The release policy. See `update_strategy_v2` below.
     */
    @JvmName("jhdybkuwyhfqfsmh")
    public suspend fun updateStrategyV2(`value`: ApplicationUpdateStrategyV2Args?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.updateStrategyV2 = mapped
    }

    /**
     * @param argument The release policy. See `update_strategy_v2` below.
     */
    @JvmName("pbcovduhieyjytun")
    public suspend fun updateStrategyV2(argument: suspend ApplicationUpdateStrategyV2ArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationUpdateStrategyV2ArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.updateStrategyV2 = mapped
    }

    /**
     * @param value The vpc id.
     */
    @JvmName("pwishcepdvpdshgg")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The vswitch id. **NOTE:** From version 1.211.0, `vswitch_id` can be modified.
     */
    @JvmName("fapiungcwvmcyhab")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value WAR package launch application option. Application default startup command: java $JAVA_OPTS $CATALINA_OPTS [-Options] org.apache.catalina.startup.Bootstrap "$@" start.
     */
    @JvmName("fidmfjokicdlbvkq")
    public suspend fun warStartOptions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.warStartOptions = mapped
    }

    /**
     * @param value The version of tomcat that the deployment package depends on. Image type applications are not supported.
     */
    @JvmName("kjqahjtwexohtwml")
    public suspend fun webContainer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webContainer = mapped
    }

    internal fun build(): ApplicationArgs = ApplicationArgs(
        acrAssumeRoleArn = acrAssumeRoleArn,
        acrInstanceId = acrInstanceId,
        appDescription = appDescription,
        appName = appName,
        autoConfig = autoConfig,
        autoEnableApplicationScalingRule = autoEnableApplicationScalingRule,
        batchWaitTime = batchWaitTime,
        changeOrderDesc = changeOrderDesc,
        command = command,
        commandArgs = commandArgs,
        commandArgsV2s = commandArgsV2s,
        configMapMountDesc = configMapMountDesc,
        configMapMountDescV2s = configMapMountDescV2s,
        cpu = cpu,
        customHostAlias = customHostAlias,
        customHostAliasV2s = customHostAliasV2s,
        deploy = deploy,
        edasContainerVersion = edasContainerVersion,
        enableAhas = enableAhas,
        enableGreyTagRoute = enableGreyTagRoute,
        envs = envs,
        imagePullSecrets = imagePullSecrets,
        imageUrl = imageUrl,
        jarStartArgs = jarStartArgs,
        jarStartOptions = jarStartOptions,
        jdk = jdk,
        kafkaConfigs = kafkaConfigs,
        liveness = liveness,
        livenessV2 = livenessV2,
        memory = memory,
        microRegistration = microRegistration,
        minReadyInstanceRatio = minReadyInstanceRatio,
        minReadyInstances = minReadyInstances,
        namespaceId = namespaceId,
        nasConfigs = nasConfigs,
        ossAkId = ossAkId,
        ossAkSecret = ossAkSecret,
        ossMountDescs = ossMountDescs,
        ossMountDescsV2s = ossMountDescsV2s,
        packageType = packageType,
        packageUrl = packageUrl,
        packageVersion = packageVersion,
        php = php,
        phpArmsConfigLocation = phpArmsConfigLocation,
        phpConfig = phpConfig,
        phpConfigLocation = phpConfigLocation,
        postStart = postStart,
        postStartV2 = postStartV2,
        preStop = preStop,
        preStopV2 = preStopV2,
        programmingLanguage = programmingLanguage,
        pvtzDiscoverySvc = pvtzDiscoverySvc,
        readiness = readiness,
        readinessV2 = readinessV2,
        replicas = replicas,
        securityGroupId = securityGroupId,
        slsConfigs = slsConfigs,
        status = status,
        tags = tags,
        terminationGracePeriodSeconds = terminationGracePeriodSeconds,
        timezone = timezone,
        tomcatConfig = tomcatConfig,
        tomcatConfigV2 = tomcatConfigV2,
        updateStrategy = updateStrategy,
        updateStrategyV2 = updateStrategyV2,
        vpcId = vpcId,
        vswitchId = vswitchId,
        warStartOptions = warStartOptions,
        webContainer = webContainer,
    )
}
