@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin

import com.pulumi.alicloud.sae.ConfigMapArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Serverless App Engine (SAE) Config Map resource.
 * For information about Serverless App Engine (SAE) Config Map and how to use it, see [What is Config Map](https://www.alibabacloud.com/help/en/sae/latest/create-configmap).
 * > **NOTE:** Available since v1.130.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.getRegions({
 *     current: true,
 * });
 * const defaultInteger = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const defaultNamespace = new alicloud.sae.Namespace("default", {
 *     namespaceId: _default.then(_default => `${_default.regions?.[0]?.id}:example${defaultInteger.result}`),
 *     namespaceName: name,
 *     namespaceDescription: name,
 *     enableMicroRegistration: false,
 * });
 * const defaultConfigMap = new alicloud.sae.ConfigMap("default", {
 *     data: JSON.stringify({
 *         "env.home": "/root",
 *         "env.shell": "/bin/sh",
 *     }),
 *     name: name,
 *     namespaceId: defaultNamespace.namespaceId,
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.get_regions(current=True)
 * default_integer = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * default_namespace = alicloud.sae.Namespace("default",
 *     namespace_id=f"{default.regions[0]&#46;id}:example{default_integer['result']}",
 *     namespace_name=name,
 *     namespace_description=name,
 *     enable_micro_registration=False)
 * default_config_map = alicloud.sae.ConfigMap("default",
 *     data=json.dumps({
 *         "env.home": "/root",
 *         "env.shell": "/bin/sh",
 *     }),
 *     name=name,
 *     namespace_id=default_namespace.namespace_id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var defaultInteger = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var defaultNamespace = new AliCloud.Sae.Namespace("default", new()
 *     {
 *         NamespaceId = @default.Apply(@default => $"{@default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)}:example{defaultInteger.Result}"),
 *         NamespaceName = name,
 *         NamespaceDescription = name,
 *         EnableMicroRegistration = false,
 *     });
 *     var defaultConfigMap = new AliCloud.Sae.ConfigMap("default", new()
 *     {
 *         Data = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["env&#46;home"] = "/root",
 *             ["env&#46;shell"] = "/bin/sh",
 *         }),
 *         Name = name,
 *         NamespaceId = defaultNamespace.NamespaceId,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/sae"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInteger, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNamespace, err := sae.NewNamespace(ctx, "default", &sae.NamespaceArgs{
 * 			NamespaceId:             pulumi.Sprintf("%v:example%v", _default.Regions[0].Id, defaultInteger.Result),
 * 			NamespaceName:           pulumi.String(name),
 * 			NamespaceDescription:    pulumi.String(name),
 * 			EnableMicroRegistration: pulumi.Bool(false),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"env.home":  "/root",
 * 			"env.shell": "/bin/sh",
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = sae.NewConfigMap(ctx, "default", &sae.ConfigMapArgs{
 * 			Data:        pulumi.String(json0),
 * 			Name:        pulumi.String(name),
 * 			NamespaceId: defaultNamespace.NamespaceId,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.sae.Namespace;
 * import com.pulumi.alicloud.sae.NamespaceArgs;
 * import com.pulumi.alicloud.sae.ConfigMap;
 * import com.pulumi.alicloud.sae.ConfigMapArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         var defaultInteger = new Integer("defaultInteger", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var defaultNamespace = new Namespace("defaultNamespace", NamespaceArgs.builder()
 *             .namespaceId(String.format("%s:example%s", default_.regions()[0].id(),defaultInteger.result()))
 *             .namespaceName(name)
 *             .namespaceDescription(name)
 *             .enableMicroRegistration(false)
 *             .build());
 *         var defaultConfigMap = new ConfigMap("defaultConfigMap", ConfigMapArgs.builder()
 *             .data(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("env.home", "/root"),
 *                     jsonProperty("env.shell", "/bin/sh")
 *                 )))
 *             .name(name)
 *             .namespaceId(defaultNamespace.namespaceId())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultInteger:
 *     type: random:integer
 *     name: default
 *     properties:
 *       max: 99999
 *       min: 10000
 *   defaultNamespace:
 *     type: alicloud:sae:Namespace
 *     name: default
 *     properties:
 *       namespaceId: ${default.regions[0].id}:example${defaultInteger.result}
 *       namespaceName: ${name}
 *       namespaceDescription: ${name}
 *       enableMicroRegistration: false
 *   defaultConfigMap:
 *     type: alicloud:sae:ConfigMap
 *     name: default
 *     properties:
 *       data:
 *         fn::toJSON:
 *           env.home: /root
 *           env.shell: /bin/sh
 *       name: ${name}
 *       namespaceId: ${defaultNamespace.namespaceId}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Serverless App Engine (SAE) Config Map can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:sae/configMap:ConfigMap example <id>
 * ```
 * @property data ConfigMap instance data.
 * @property description The Description of ConfigMap.
 * @property name ConfigMap instance name.
 * @property namespaceId The NamespaceId of ConfigMap.It can contain 2 to 32 lowercase characters.The value is in format `{RegionId}:{namespace}`
 */
public data class ConfigMapArgs(
    public val `data`: Output<String>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val namespaceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sae.ConfigMapArgs> {
    override fun toJava(): com.pulumi.alicloud.sae.ConfigMapArgs =
        com.pulumi.alicloud.sae.ConfigMapArgs.builder()
            .`data`(`data`?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namespaceId(namespaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigMapArgs].
 */
@PulumiTagMarker
public class ConfigMapArgsBuilder internal constructor() {
    private var `data`: Output<String>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var namespaceId: Output<String>? = null

    /**
     * @param value ConfigMap instance data.
     */
    @JvmName("gecvaqlxgkanvhuw")
    public suspend fun `data`(`value`: Output<String>) {
        this.`data` = value
    }

    /**
     * @param value The Description of ConfigMap.
     */
    @JvmName("vrwcanxvgysdemsc")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value ConfigMap instance name.
     */
    @JvmName("rykkkomvxtejskae")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The NamespaceId of ConfigMap.It can contain 2 to 32 lowercase characters.The value is in format `{RegionId}:{namespace}`
     */
    @JvmName("agyowskpjvywmyjq")
    public suspend fun namespaceId(`value`: Output<String>) {
        this.namespaceId = value
    }

    /**
     * @param value ConfigMap instance data.
     */
    @JvmName("vvoxhuqjacdgulkc")
    public suspend fun `data`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`data` = mapped
    }

    /**
     * @param value The Description of ConfigMap.
     */
    @JvmName("fanpjyohrfgprejg")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value ConfigMap instance name.
     */
    @JvmName("revtmdyvpkinfwbv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The NamespaceId of ConfigMap.It can contain 2 to 32 lowercase characters.The value is in format `{RegionId}:{namespace}`
     */
    @JvmName("qntotemsydehiwmo")
    public suspend fun namespaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceId = mapped
    }

    internal fun build(): ConfigMapArgs = ConfigMapArgs(
        `data` = `data`,
        description = description,
        name = name,
        namespaceId = namespaceId,
    )
}
