@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin

import com.pulumi.alicloud.sae.NamespaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Serverless App Engine (SAE) Namespace resource.
 * For information about SAE Namespace and how to use it, see [What is Namespace](https://www.alibabacloud.com/help/en/sae/latest/createnamespace).
 * > **NOTE:** Available since v1.129.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.getRegions({
 *     current: true,
 * });
 * const defaultInteger = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const example = new alicloud.sae.Namespace("example", {
 *     namespaceId: _default.then(_default => `${_default.regions?.[0]?.id}:example${defaultInteger.result}`),
 *     namespaceName: name,
 *     namespaceDescription: name,
 *     enableMicroRegistration: false,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.get_regions(current=True)
 * default_integer = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * example = alicloud.sae.Namespace("example",
 *     namespace_id=f"{default.regions[0]&#46;id}:example{default_integer['result']}",
 *     namespace_name=name,
 *     namespace_description=name,
 *     enable_micro_registration=False)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var defaultInteger = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var example = new AliCloud.Sae.Namespace("example", new()
 *     {
 *         NamespaceId = @default.Apply(@default => $"{@default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)}:example{defaultInteger.Result}"),
 *         NamespaceName = name,
 *         NamespaceDescription = name,
 *         EnableMicroRegistration = false,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/sae"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultInteger, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = sae.NewNamespace(ctx, "example", &sae.NamespaceArgs{
 * 			NamespaceId:             pulumi.Sprintf("%v:example%v", _default.Regions[0].Id, defaultInteger.Result),
 * 			NamespaceName:           pulumi.String(name),
 * 			NamespaceDescription:    pulumi.String(name),
 * 			EnableMicroRegistration: pulumi.Bool(false),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.sae.Namespace;
 * import com.pulumi.alicloud.sae.NamespaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         var defaultInteger = new Integer("defaultInteger", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var example = new Namespace("example", NamespaceArgs.builder()
 *             .namespaceId(String.format("%s:example%s", default_.regions()[0].id(),defaultInteger.result()))
 *             .namespaceName(name)
 *             .namespaceDescription(name)
 *             .enableMicroRegistration(false)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultInteger:
 *     type: random:integer
 *     name: default
 *     properties:
 *       max: 99999
 *       min: 10000
 *   example:
 *     type: alicloud:sae:Namespace
 *     properties:
 *       namespaceId: ${default.regions[0].id}:example${defaultInteger.result}
 *       namespaceName: ${name}
 *       namespaceDescription: ${name}
 *       enableMicroRegistration: false
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Serverless App Engine (SAE) Namespace can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:sae/namespace:Namespace example <namespace_id>
 * ```
 * @property enableMicroRegistration Specifies whether to enable the SAE built-in registry. If you do not use the built-in registry, you can set `enable_micro_registration` to `false` to accelerate the creation of the namespace. Default value: `true`. Valid values:
 * @property namespaceDescription The Description of Namespace.
 * @property namespaceId The ID of the Namespace. It can contain 2 to 32 lowercase characters. The value is in format `{RegionId}:{namespace}`.
 * @property namespaceName The Name of Namespace.
 * @property namespaceShortId The short ID of the Namespace. You do not need to specify a region ID. The value of `namespace_short_id` can be up to 20 characters in length and can contain only lowercase letters and digits.
 */
public data class NamespaceArgs(
    public val enableMicroRegistration: Output<Boolean>? = null,
    public val namespaceDescription: Output<String>? = null,
    public val namespaceId: Output<String>? = null,
    public val namespaceName: Output<String>? = null,
    public val namespaceShortId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sae.NamespaceArgs> {
    override fun toJava(): com.pulumi.alicloud.sae.NamespaceArgs =
        com.pulumi.alicloud.sae.NamespaceArgs.builder()
            .enableMicroRegistration(enableMicroRegistration?.applyValue({ args0 -> args0 }))
            .namespaceDescription(namespaceDescription?.applyValue({ args0 -> args0 }))
            .namespaceId(namespaceId?.applyValue({ args0 -> args0 }))
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .namespaceShortId(namespaceShortId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NamespaceArgs].
 */
@PulumiTagMarker
public class NamespaceArgsBuilder internal constructor() {
    private var enableMicroRegistration: Output<Boolean>? = null

    private var namespaceDescription: Output<String>? = null

    private var namespaceId: Output<String>? = null

    private var namespaceName: Output<String>? = null

    private var namespaceShortId: Output<String>? = null

    /**
     * @param value Specifies whether to enable the SAE built-in registry. If you do not use the built-in registry, you can set `enable_micro_registration` to `false` to accelerate the creation of the namespace. Default value: `true`. Valid values:
     */
    @JvmName("bifrhwqfqeccdgmy")
    public suspend fun enableMicroRegistration(`value`: Output<Boolean>) {
        this.enableMicroRegistration = value
    }

    /**
     * @param value The Description of Namespace.
     */
    @JvmName("anqwivablvvdoajh")
    public suspend fun namespaceDescription(`value`: Output<String>) {
        this.namespaceDescription = value
    }

    /**
     * @param value The ID of the Namespace. It can contain 2 to 32 lowercase characters. The value is in format `{RegionId}:{namespace}`.
     */
    @JvmName("sqqrbmcygedlwggr")
    public suspend fun namespaceId(`value`: Output<String>) {
        this.namespaceId = value
    }

    /**
     * @param value The Name of Namespace.
     */
    @JvmName("syxnmplewjvjwkby")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value The short ID of the Namespace. You do not need to specify a region ID. The value of `namespace_short_id` can be up to 20 characters in length and can contain only lowercase letters and digits.
     */
    @JvmName("fysjsguqdbrxabrb")
    public suspend fun namespaceShortId(`value`: Output<String>) {
        this.namespaceShortId = value
    }

    /**
     * @param value Specifies whether to enable the SAE built-in registry. If you do not use the built-in registry, you can set `enable_micro_registration` to `false` to accelerate the creation of the namespace. Default value: `true`. Valid values:
     */
    @JvmName("oqbilcoxntbccyjh")
    public suspend fun enableMicroRegistration(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableMicroRegistration = mapped
    }

    /**
     * @param value The Description of Namespace.
     */
    @JvmName("dmiqlfyowkostkmx")
    public suspend fun namespaceDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceDescription = mapped
    }

    /**
     * @param value The ID of the Namespace. It can contain 2 to 32 lowercase characters. The value is in format `{RegionId}:{namespace}`.
     */
    @JvmName("ycixdnhptiaufclt")
    public suspend fun namespaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceId = mapped
    }

    /**
     * @param value The Name of Namespace.
     */
    @JvmName("lmdylphyahyxumbl")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value The short ID of the Namespace. You do not need to specify a region ID. The value of `namespace_short_id` can be up to 20 characters in length and can contain only lowercase letters and digits.
     */
    @JvmName("vyiwxulnwhdgskes")
    public suspend fun namespaceShortId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceShortId = mapped
    }

    internal fun build(): NamespaceArgs = NamespaceArgs(
        enableMicroRegistration = enableMicroRegistration,
        namespaceDescription = namespaceDescription,
        namespaceId = namespaceId,
        namespaceName = namespaceName,
        namespaceShortId = namespaceShortId,
    )
}
