@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin

import com.pulumi.alicloud.sae.SaeFunctions.getApplicationScalingRulesPlain
import com.pulumi.alicloud.sae.SaeFunctions.getApplicationsPlain
import com.pulumi.alicloud.sae.SaeFunctions.getConfigMapsPlain
import com.pulumi.alicloud.sae.SaeFunctions.getGreyTagRoutesPlain
import com.pulumi.alicloud.sae.SaeFunctions.getIngressesPlain
import com.pulumi.alicloud.sae.SaeFunctions.getInstanceSpecificationsPlain
import com.pulumi.alicloud.sae.SaeFunctions.getNamespacesPlain
import com.pulumi.alicloud.sae.SaeFunctions.getServicePlain
import com.pulumi.alicloud.sae.kotlin.inputs.GetApplicationScalingRulesPlainArgs
import com.pulumi.alicloud.sae.kotlin.inputs.GetApplicationScalingRulesPlainArgsBuilder
import com.pulumi.alicloud.sae.kotlin.inputs.GetApplicationsPlainArgs
import com.pulumi.alicloud.sae.kotlin.inputs.GetApplicationsPlainArgsBuilder
import com.pulumi.alicloud.sae.kotlin.inputs.GetConfigMapsPlainArgs
import com.pulumi.alicloud.sae.kotlin.inputs.GetConfigMapsPlainArgsBuilder
import com.pulumi.alicloud.sae.kotlin.inputs.GetGreyTagRoutesPlainArgs
import com.pulumi.alicloud.sae.kotlin.inputs.GetGreyTagRoutesPlainArgsBuilder
import com.pulumi.alicloud.sae.kotlin.inputs.GetIngressesPlainArgs
import com.pulumi.alicloud.sae.kotlin.inputs.GetIngressesPlainArgsBuilder
import com.pulumi.alicloud.sae.kotlin.inputs.GetInstanceSpecificationsPlainArgs
import com.pulumi.alicloud.sae.kotlin.inputs.GetInstanceSpecificationsPlainArgsBuilder
import com.pulumi.alicloud.sae.kotlin.inputs.GetNamespacesPlainArgs
import com.pulumi.alicloud.sae.kotlin.inputs.GetNamespacesPlainArgsBuilder
import com.pulumi.alicloud.sae.kotlin.inputs.GetServicePlainArgs
import com.pulumi.alicloud.sae.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.alicloud.sae.kotlin.outputs.GetApplicationScalingRulesResult
import com.pulumi.alicloud.sae.kotlin.outputs.GetApplicationsResult
import com.pulumi.alicloud.sae.kotlin.outputs.GetConfigMapsResult
import com.pulumi.alicloud.sae.kotlin.outputs.GetGreyTagRoutesResult
import com.pulumi.alicloud.sae.kotlin.outputs.GetIngressesResult
import com.pulumi.alicloud.sae.kotlin.outputs.GetInstanceSpecificationsResult
import com.pulumi.alicloud.sae.kotlin.outputs.GetNamespacesResult
import com.pulumi.alicloud.sae.kotlin.outputs.GetServiceResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.sae.kotlin.outputs.GetApplicationScalingRulesResult.Companion.toKotlin as getApplicationScalingRulesResultToKotlin
import com.pulumi.alicloud.sae.kotlin.outputs.GetApplicationsResult.Companion.toKotlin as getApplicationsResultToKotlin
import com.pulumi.alicloud.sae.kotlin.outputs.GetConfigMapsResult.Companion.toKotlin as getConfigMapsResultToKotlin
import com.pulumi.alicloud.sae.kotlin.outputs.GetGreyTagRoutesResult.Companion.toKotlin as getGreyTagRoutesResultToKotlin
import com.pulumi.alicloud.sae.kotlin.outputs.GetIngressesResult.Companion.toKotlin as getIngressesResultToKotlin
import com.pulumi.alicloud.sae.kotlin.outputs.GetInstanceSpecificationsResult.Companion.toKotlin as getInstanceSpecificationsResultToKotlin
import com.pulumi.alicloud.sae.kotlin.outputs.GetNamespacesResult.Companion.toKotlin as getNamespacesResultToKotlin
import com.pulumi.alicloud.sae.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin

public object SaeFunctions {
    /**
     * This data source provides the Sae Application Scaling Rules of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.159.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.sae.getApplicationScalingRules({
     *     appId: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     * });
     * export const saeApplicationScalingRuleId1 = ids.then(ids => ids.rules?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.sae.get_application_scaling_rules(app_id="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ])
     * pulumi.export("saeApplicationScalingRuleId1", ids.rules[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Sae.GetApplicationScalingRules.Invoke(new()
     *     {
     *         AppId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["saeApplicationScalingRuleId1"] = ids&#46;Apply(getApplicationScalingRulesResult => getApplicationScalingRulesResult&#46;Rules[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/sae"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := sae.GetApplicationScalingRules(ctx, &sae.GetApplicationScalingRulesArgs{
     * 			AppId: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("saeApplicationScalingRuleId1", ids.Rules[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.sae.SaeFunctions;
     * import com.pulumi.alicloud.sae.inputs.GetApplicationScalingRulesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = SaeFunctions.getApplicationScalingRules(GetApplicationScalingRulesArgs.builder()
     *             .appId("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .build());
     *         ctx.export("saeApplicationScalingRuleId1", ids.applyValue(getApplicationScalingRulesResult -> getApplicationScalingRulesResult.rules()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:sae:getApplicationScalingRules
     *       Arguments:
     *         appId: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     * outputs:
     *   saeApplicationScalingRuleId1: ${ids.rules[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getApplicationScalingRules.
     * @return A collection of values returned by getApplicationScalingRules.
     */
    public suspend fun getApplicationScalingRules(argument: GetApplicationScalingRulesPlainArgs): GetApplicationScalingRulesResult =
        getApplicationScalingRulesResultToKotlin(getApplicationScalingRulesPlain(argument.toJava()).await())

    /**
     * @see [getApplicationScalingRules].
     * @param appId The ID of the Application.
     * @param ids A list of Application Scaling Rule IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getApplicationScalingRules.
     */
    public suspend fun getApplicationScalingRules(
        appId: String,
        ids: List<String>? = null,
        outputFile: String? = null,
    ): GetApplicationScalingRulesResult {
        val argument = GetApplicationScalingRulesPlainArgs(
            appId = appId,
            ids = ids,
            outputFile = outputFile,
        )
        return getApplicationScalingRulesResultToKotlin(getApplicationScalingRulesPlain(argument.toJava()).await())
    }

    /**
     * @see [getApplicationScalingRules].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;sae&#46;kotlin&#46;inputs&#46;GetApplicationScalingRulesPlainArgs].
     * @return A collection of values returned by getApplicationScalingRules.
     */
    public suspend fun getApplicationScalingRules(argument: suspend GetApplicationScalingRulesPlainArgsBuilder.() -> Unit): GetApplicationScalingRulesResult {
        val builder = GetApplicationScalingRulesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApplicationScalingRulesResultToKotlin(getApplicationScalingRulesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Sae Applications of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.161.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const config = new pulumi.Config();
     * const name = config.get("name") || "tf-testacc";
     * const default = alicloud.getZones({
     *     availableResourceCreation: "VSwitch",
     * });
     * const vpc = new alicloud.vpc.Network("vpc", {
     *     vpcName: "tf_testacc",
     *     cidrBlock: "172.16.0.0/12",
     * });
     * const vsw = new alicloud.vpc.Switch("vsw", {
     *     vpcId: vpc.id,
     *     cidrBlock: "172.16.0.0/24",
     *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
     *     vswitchName: name,
     * });
     * const defaultNamespace = new alicloud.sae.Namespace("default", {
     *     namespaceDescription: name,
     *     namespaceId: "cn-hangzhou:tfacctest",
     *     namespaceName: name,
     * });
     * const defaultApplication = new alicloud.sae.Application("default", {
     *     appDescription: "tf-testaccDescription",
     *     appName: "tf-testaccAppName131",
     *     namespaceId: defaultNamespace.id,
     *     imageUrl: "registry-vpc.cn-hangzhou.aliyuncs.com/lxepoo/apache-php5",
     *     packageType: "Image",
     *     vswitchId: vsw.id,
     *     timezone: "Asia/Beijing",
     *     replicas: 5,
     *     cpu: 500,
     *     memory: 2048,
     * });
     * const defaultGetApplications = alicloud.sae.getApplicationsOutput({
     *     ids: [defaultApplication&#46;id],
     * });
     * export const saeApplicationId = defaultGetApplications.apply(defaultGetApplications => defaultGetApplications.applications?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * config = pulumi.Config()
     * name = config.get("name")
     * if name is None:
     *     name = "tf-testacc"
     * default = alicloud.get_zones(available_resource_creation="VSwitch")
     * vpc = alicloud.vpc.Network("vpc",
     *     vpc_name="tf_testacc",
     *     cidr_block="172.16.0.0/12")
     * vsw = alicloud.vpc.Switch("vsw",
     *     vpc_id=vpc.id,
     *     cidr_block="172.16.0.0/24",
     *     zone_id=default.zones[0].id,
     *     vswitch_name=name)
     * default_namespace = alicloud.sae.Namespace("default",
     *     namespace_description=name,
     *     namespace_id="cn-hangzhou:tfacctest",
     *     namespace_name=name)
     * default_application = alicloud.sae.Application("default",
     *     app_description="tf-testaccDescription",
     *     app_name="tf-testaccAppName131",
     *     namespace_id=default_namespace.id,
     *     image_url="registry-vpc.cn-hangzhou.aliyuncs.com/lxepoo/apache-php5",
     *     package_type="Image",
     *     vswitch_id=vsw.id,
     *     timezone="Asia/Beijing",
     *     replicas=5,
     *     cpu=500,
     *     memory=2048)
     * default_get_applications = alicloud.sae.get_applications_output(ids=[default_application&#46;id])
     * pulumi.export("saeApplicationId", default_get_applications.applications[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var name = config.Get("name") ?? "tf-testacc";
     *     var @default = AliCloud.GetZones.Invoke(new()
     *     {
     *         AvailableResourceCreation = "VSwitch",
     *     });
     *     var vpc = new AliCloud.Vpc.Network("vpc", new()
     *     {
     *         VpcName = "tf_testacc",
     *         CidrBlock = "172.16.0.0/12",
     *     });
     *     var vsw = new AliCloud.Vpc.Switch("vsw", new()
     *     {
     *         VpcId = vpc.Id,
     *         CidrBlock = "172.16.0.0/24",
     *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
     *         VswitchName = name,
     *     });
     *     var defaultNamespace = new AliCloud.Sae.Namespace("default", new()
     *     {
     *         NamespaceDescription = name,
     *         NamespaceId = "cn-hangzhou:tfacctest",
     *         NamespaceName = name,
     *     });
     *     var defaultApplication = new AliCloud.Sae.Application("default", new()
     *     {
     *         AppDescription = "tf-testaccDescription",
     *         AppName = "tf-testaccAppName131",
     *         NamespaceId = defaultNamespace.Id,
     *         ImageUrl = "registry-vpc.cn-hangzhou.aliyuncs.com/lxepoo/apache-php5",
     *         PackageType = "Image",
     *         VswitchId = vsw.Id,
     *         Timezone = "Asia/Beijing",
     *         Replicas = 5,
     *         Cpu = 500,
     *         Memory = 2048,
     *     });
     *     var defaultGetApplications = AliCloud.Sae.GetApplications.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultApplication.Id,
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["saeApplicationId"] = defaultGetApplications&#46;Apply(getApplicationsResult => getApplicationsResult&#46;Applications[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/sae"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		name := "tf-testacc"
     * 		if param := cfg.Get("name"); param != "" {
     * 			name = param
     * 		}
     * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
     * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		vpc, err := vpc.NewNetwork(ctx, "vpc", &vpc.NetworkArgs{
     * 			VpcName:   pulumi.String("tf_testacc"),
     * 			CidrBlock: pulumi.String("172.16.0.0/12"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		vsw, err := vpc.NewSwitch(ctx, "vsw", &vpc.SwitchArgs{
     * 			VpcId:       vpc.ID(),
     * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
     * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
     * 			VswitchName: pulumi.String(name),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultNamespace, err := sae.NewNamespace(ctx, "default", &sae.NamespaceArgs{
     * 			NamespaceDescription: pulumi.String(name),
     * 			NamespaceId:          pulumi.String("cn-hangzhou:tfacctest"),
     * 			NamespaceName:        pulumi.String(name),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultApplication, err := sae.NewApplication(ctx, "default", &sae.ApplicationArgs{
     * 			AppDescription: pulumi.String("tf-testaccDescription"),
     * 			AppName:        pulumi.String("tf-testaccAppName131"),
     * 			NamespaceId:    defaultNamespace.ID(),
     * 			ImageUrl:       pulumi.String("registry-vpc.cn-hangzhou.aliyuncs.com/lxepoo/apache-php5"),
     * 			PackageType:    pulumi.String("Image"),
     * 			VswitchId:      vsw.ID(),
     * 			Timezone:       pulumi.String("Asia/Beijing"),
     * 			Replicas:       pulumi.Int(5),
     * 			Cpu:            pulumi.Int(500),
     * 			Memory:         pulumi.Int(2048),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		defaultGetApplications := sae.GetApplicationsOutput(ctx, sae.GetApplicationsOutputArgs{
     * 			Ids: pulumi.StringArray{
     * 				defaultApplication.ID(),
     * 			},
     * 		}, nil)
     * 		ctx.Export("saeApplicationId", defaultGetApplications.ApplyT(func(defaultGetApplications sae.GetApplicationsResult) (*string, error) {
     * 			return &defaultGetApplications.Applications[0].Id, nil
     * 		}).(pulumi.StringPtrOutput))
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.AlicloudFunctions;
     * import com.pulumi.alicloud.inputs.GetZonesArgs;
     * import com.pulumi.alicloud.vpc.Network;
     * import com.pulumi.alicloud.vpc.NetworkArgs;
     * import com.pulumi.alicloud.vpc.Switch;
     * import com.pulumi.alicloud.vpc.SwitchArgs;
     * import com.pulumi.alicloud.sae.Namespace;
     * import com.pulumi.alicloud.sae.NamespaceArgs;
     * import com.pulumi.alicloud.sae.Application;
     * import com.pulumi.alicloud.sae.ApplicationArgs;
     * import com.pulumi.alicloud.sae.SaeFunctions;
     * import com.pulumi.alicloud.sae.inputs.GetApplicationsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var name = config.get("name").orElse("tf-testacc");
     *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
     *             .availableResourceCreation("VSwitch")
     *             .build());
     *         var vpc = new Network("vpc", NetworkArgs.builder()
     *             .vpcName("tf_testacc")
     *             .cidrBlock("172.16.0.0/12")
     *             .build());
     *         var vsw = new Switch("vsw", SwitchArgs.builder()
     *             .vpcId(vpc.id())
     *             .cidrBlock("172.16.0.0/24")
     *             .zoneId(default_.zones()[0].id())
     *             .vswitchName(name)
     *             .build());
     *         var defaultNamespace = new Namespace("defaultNamespace", NamespaceArgs.builder()
     *             .namespaceDescription(name)
     *             .namespaceId("cn-hangzhou:tfacctest")
     *             .namespaceName(name)
     *             .build());
     *         var defaultApplication = new Application("defaultApplication", ApplicationArgs.builder()
     *             .appDescription("tf-testaccDescription")
     *             .appName("tf-testaccAppName131")
     *             .namespaceId(defaultNamespace.id())
     *             .imageUrl("registry-vpc.cn-hangzhou.aliyuncs.com/lxepoo/apache-php5")
     *             .packageType("Image")
     *             .vswitchId(vsw.id())
     *             .timezone("Asia/Beijing")
     *             .replicas("5")
     *             .cpu("500")
     *             .memory("2048")
     *             .build());
     *         final var defaultGetApplications = SaeFunctions.getApplications(GetApplicationsArgs.builder()
     *             .ids(defaultApplication.id())
     *             .build());
     *         ctx.export("saeApplicationId", defaultGetApplications.applyValue(getApplicationsResult -> getApplicationsResult).applyValue(defaultGetApplications -> defaultGetApplications.applyValue(getApplicationsResult -> getApplicationsResult.applications()[0].id())));
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   name:
     *     type: string
     *     default: tf-testacc
     * resources:
     *   vpc:
     *     type: alicloud:vpc:Network
     *     properties:
     *       vpcName: tf_testacc
     *       cidrBlock: 172.16.0.0/12
     *   vsw:
     *     type: alicloud:vpc:Switch
     *     properties:
     *       vpcId: ${vpc.id}
     *       cidrBlock: 172.16.0.0/24
     *       zoneId: ${default.zones[0].id}
     *       vswitchName: ${name}
     *   defaultNamespace:
     *     type: alicloud:sae:Namespace
     *     name: default
     *     properties:
     *       namespaceDescription: ${name}
     *       namespaceId: cn-hangzhou:tfacctest
     *       namespaceName: ${name}
     *   defaultApplication:
     *     type: alicloud:sae:Application
     *     name: default
     *     properties:
     *       appDescription: tf-testaccDescription
     *       appName: tf-testaccAppName131
     *       namespaceId: ${defaultNamespace.id}
     *       imageUrl: registry-vpc.cn-hangzhou.aliyuncs.com/lxepoo/apache-php5
     *       packageType: Image
     *       vswitchId: ${vsw.id}
     *       timezone: Asia/Beijing
     *       replicas: '5'
     *       cpu: '500'
     *       memory: '2048'
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:getZones
     *       Arguments:
     *         availableResourceCreation: VSwitch
     *   defaultGetApplications:
     *     fn::invoke:
     *       Function: alicloud:sae:getApplications
     *       Arguments:
     *         ids:
     *           - ${defaultApplication.id}
     * outputs:
     *   saeApplicationId: ${defaultGetApplications.applications[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getApplications.
     * @return A collection of values returned by getApplications.
     */
    public suspend fun getApplications(argument: GetApplicationsPlainArgs): GetApplicationsResult =
        getApplicationsResultToKotlin(getApplicationsPlain(argument.toJava()).await())

    /**
     * @see [getApplications].
     * @param appName Application Name. Combinations of numbers, letters, and dashes (-) are allowed. It must start with a letter and the maximum length is 36 characters.
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param fieldType The field type. Valid values:`appName`, `appIds`, `slbIps`, `instanceIps`
     * @param fieldValue The field value.
     * @param ids A list of Application IDs.
     * @param namespaceId SAE namespace ID. Only namespaces whose names are lowercase letters and dashes (-) are supported, and must start with a letter. The namespace can be obtained by calling the DescribeNamespaceList interface.
     * @param orderBy The order by.Valid values:`running`,`instances`.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param reverse The reverse.
     * @param status The status of the resource. Valid values: `RUNNING`, `STOPPED`,`UNKNOWN`.
     * @return A collection of values returned by getApplications.
     */
    public suspend fun getApplications(
        appName: String? = null,
        enableDetails: Boolean? = null,
        fieldType: String? = null,
        fieldValue: String? = null,
        ids: List<String>? = null,
        namespaceId: String? = null,
        orderBy: String? = null,
        outputFile: String? = null,
        reverse: Boolean? = null,
        status: String? = null,
    ): GetApplicationsResult {
        val argument = GetApplicationsPlainArgs(
            appName = appName,
            enableDetails = enableDetails,
            fieldType = fieldType,
            fieldValue = fieldValue,
            ids = ids,
            namespaceId = namespaceId,
            orderBy = orderBy,
            outputFile = outputFile,
            reverse = reverse,
            status = status,
        )
        return getApplicationsResultToKotlin(getApplicationsPlain(argument.toJava()).await())
    }

    /**
     * @see [getApplications].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;sae&#46;kotlin&#46;inputs&#46;GetApplicationsPlainArgs].
     * @return A collection of values returned by getApplications.
     */
    public suspend fun getApplications(argument: suspend GetApplicationsPlainArgsBuilder.() -> Unit): GetApplicationsResult {
        val builder = GetApplicationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApplicationsResultToKotlin(getApplicationsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Sae Config Maps of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.130.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const config = new pulumi.Config();
     * const configMapName = config.get("configMapName") || "examplename";
     * const example = new alicloud.sae.Namespace("example", {
     *     namespaceId: "cn-hangzhou:yourname",
     *     namespaceName: "example_value",
     *     namespaceDescription: "your_description",
     * });
     * const exampleConfigMap = new alicloud.sae.ConfigMap("example", {
     *     data: JSON.stringify({
     *         "env.home": "/root",
     *         "env.shell": "/bin/sh",
     *     }),
     *     name: configMapName,
     *     namespaceId: example.namespaceId,
     * });
     * const nameRegex = alicloud.sae.getConfigMapsOutput({
     *     namespaceId: example.namespaceId,
     *     nameRegex: "^example",
     * });
     * export const saeConfigMapId = nameRegex.apply(nameRegex => nameRegex.maps?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import json
     * import pulumi_alicloud as alicloud
     * config = pulumi.Config()
     * config_map_name = config.get("configMapName")
     * if config_map_name is None:
     *     config_map_name = "examplename"
     * example = alicloud.sae.Namespace("example",
     *     namespace_id="cn-hangzhou:yourname",
     *     namespace_name="example_value",
     *     namespace_description="your_description")
     * example_config_map = alicloud.sae.ConfigMap("example",
     *     data=json.dumps({
     *         "env.home": "/root",
     *         "env.shell": "/bin/sh",
     *     }),
     *     name=config_map_name,
     *     namespace_id=example.namespace_id)
     * name_regex = alicloud.sae.get_config_maps_output(namespace_id=example.namespace_id,
     *     name_regex="^example")
     * pulumi.export("saeConfigMapId", name_regex.maps[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using System.Text.Json;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var configMapName = config.Get("configMapName") ?? "examplename";
     *     var example = new AliCloud.Sae.Namespace("example", new()
     *     {
     *         NamespaceId = "cn-hangzhou:yourname",
     *         NamespaceName = "example_value",
     *         NamespaceDescription = "your_description",
     *     });
     *     var exampleConfigMap = new AliCloud.Sae.ConfigMap("example", new()
     *     {
     *         Data = JsonSerializer.Serialize(new Dictionary<string, object?>
     *         {
     *             ["env&#46;home"] = "/root",
     *             ["env&#46;shell"] = "/bin/sh",
     *         }),
     *         Name = configMapName,
     *         NamespaceId = example.NamespaceId,
     *     });
     *     var nameRegex = AliCloud.Sae.GetConfigMaps.Invoke(new()
     *     {
     *         NamespaceId = example.NamespaceId,
     *         NameRegex = "^example",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["saeConfigMapId"] = nameRegex&#46;Apply(getConfigMapsResult => getConfigMapsResult&#46;Maps[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"encoding/json"
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/sae"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		configMapName := "examplename"
     * 		if param := cfg.Get("configMapName"); param != "" {
     * 			configMapName = param
     * 		}
     * 		example, err := sae.NewNamespace(ctx, "example", &sae.NamespaceArgs{
     * 			NamespaceId:          pulumi.String("cn-hangzhou:yourname"),
     * 			NamespaceName:        pulumi.String("example_value"),
     * 			NamespaceDescription: pulumi.String("your_description"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
     * 			"env.home":  "/root",
     * 			"env.shell": "/bin/sh",
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		json0 := string(tmpJSON0)
     * 		_, err = sae.NewConfigMap(ctx, "example", &sae.ConfigMapArgs{
     * 			Data:        pulumi.String(json0),
     * 			Name:        pulumi.String(configMapName),
     * 			NamespaceId: example.NamespaceId,
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		nameRegex := sae.GetConfigMapsOutput(ctx, sae.GetConfigMapsOutputArgs{
     * 			NamespaceId: example.NamespaceId,
     * 			NameRegex:   pulumi.String("^example"),
     * 		}, nil)
     * 		ctx.Export("saeConfigMapId", nameRegex.ApplyT(func(nameRegex sae.GetConfigMapsResult) (*string, error) {
     * 			return &nameRegex.Maps[0].Id, nil
     * 		}).(pulumi.StringPtrOutput))
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.sae.Namespace;
     * import com.pulumi.alicloud.sae.NamespaceArgs;
     * import com.pulumi.alicloud.sae.ConfigMap;
     * import com.pulumi.alicloud.sae.ConfigMapArgs;
     * import com.pulumi.alicloud.sae.SaeFunctions;
     * import com.pulumi.alicloud.sae.inputs.GetConfigMapsArgs;
     * import static com.pulumi.codegen.internal.Serialization.*;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var configMapName = config.get("configMapName").orElse("examplename");
     *         var example = new Namespace("example", NamespaceArgs.builder()
     *             .namespaceId("cn-hangzhou:yourname")
     *             .namespaceName("example_value")
     *             .namespaceDescription("your_description")
     *             .build());
     *         var exampleConfigMap = new ConfigMap("exampleConfigMap", ConfigMapArgs.builder()
     *             .data(serializeJson(
     *                 jsonObject(
     *                     jsonProperty("env.home", "/root"),
     *                     jsonProperty("env.shell", "/bin/sh")
     *                 )))
     *             .name(configMapName)
     *             .namespaceId(example.namespaceId())
     *             .build());
     *         final var nameRegex = SaeFunctions.getConfigMaps(GetConfigMapsArgs.builder()
     *             .namespaceId(example.namespaceId())
     *             .nameRegex("^example")
     *             .build());
     *         ctx.export("saeConfigMapId", nameRegex.applyValue(getConfigMapsResult -> getConfigMapsResult).applyValue(nameRegex -> nameRegex.applyValue(getConfigMapsResult -> getConfigMapsResult.maps()[0].id())));
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   configMapName:
     *     type: string
     *     default: examplename
     * resources:
     *   example:
     *     type: alicloud:sae:Namespace
     *     properties:
     *       namespaceId: cn-hangzhou:yourname
     *       namespaceName: example_value
     *       namespaceDescription: your_description
     *   exampleConfigMap:
     *     type: alicloud:sae:ConfigMap
     *     name: example
     *     properties:
     *       data:
     *         fn::toJSON:
     *           env.home: /root
     *           env.shell: /bin/sh
     *       name: ${configMapName}
     *       namespaceId: ${example.namespaceId}
     * variables:
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:sae:getConfigMaps
     *       Arguments:
     *         namespaceId: ${example.namespaceId}
     *         nameRegex: ^example
     * outputs:
     *   saeConfigMapId: ${nameRegex.maps[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getConfigMaps.
     * @return A collection of values returned by getConfigMaps.
     */
    public suspend fun getConfigMaps(argument: GetConfigMapsPlainArgs): GetConfigMapsResult =
        getConfigMapsResultToKotlin(getConfigMapsPlain(argument.toJava()).await())

    /**
     * @see [getConfigMaps].
     * @param ids A list of Config Map IDs.
     * @param nameRegex A regex string to filter results by Config Map name.
     * @param namespaceId The NamespaceId of Config Maps. The Id of Namespace.It can contain 2 to 32 characters.The value is in format {RegionId}:{namespace}.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getConfigMaps.
     */
    public suspend fun getConfigMaps(
        ids: List<String>? = null,
        nameRegex: String? = null,
        namespaceId: String,
        outputFile: String? = null,
    ): GetConfigMapsResult {
        val argument = GetConfigMapsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            namespaceId = namespaceId,
            outputFile = outputFile,
        )
        return getConfigMapsResultToKotlin(getConfigMapsPlain(argument.toJava()).await())
    }

    /**
     * @see [getConfigMaps].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;sae&#46;kotlin&#46;inputs&#46;GetConfigMapsPlainArgs].
     * @return A collection of values returned by getConfigMaps.
     */
    public suspend fun getConfigMaps(argument: suspend GetConfigMapsPlainArgsBuilder.() -> Unit): GetConfigMapsResult {
        val builder = GetConfigMapsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConfigMapsResultToKotlin(getConfigMapsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Sae GreyTagRoutes of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.160.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const nameRegex = alicloud.sae.getGreyTagRoutes({
     *     appId: "example_id",
     *     nameRegex: "^my-GreyTagRoute",
     * });
     * export const saeGreyTagRoutesId = nameRegex.then(nameRegex => nameRegex.routes?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * name_regex = alicloud.sae.get_grey_tag_routes(app_id="example_id",
     *     name_regex="^my-GreyTagRoute")
     * pulumi.export("saeGreyTagRoutesId", name_regex.routes[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var nameRegex = AliCloud.Sae.GetGreyTagRoutes.Invoke(new()
     *     {
     *         AppId = "example_id",
     *         NameRegex = "^my-GreyTagRoute",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["saeGreyTagRoutesId"] = nameRegex&#46;Apply(getGreyTagRoutesResult => getGreyTagRoutesResult&#46;Routes[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/sae"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		nameRegex, err := sae.GetGreyTagRoutes(ctx, &sae.GetGreyTagRoutesArgs{
     * 			AppId:     "example_id",
     * 			NameRegex: pulumi.StringRef("^my-GreyTagRoute"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("saeGreyTagRoutesId", nameRegex.Routes[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.sae.SaeFunctions;
     * import com.pulumi.alicloud.sae.inputs.GetGreyTagRoutesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var nameRegex = SaeFunctions.getGreyTagRoutes(GetGreyTagRoutesArgs.builder()
     *             .appId("example_id")
     *             .nameRegex("^my-GreyTagRoute")
     *             .build());
     *         ctx.export("saeGreyTagRoutesId", nameRegex.applyValue(getGreyTagRoutesResult -> getGreyTagRoutesResult.routes()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:sae:getGreyTagRoutes
     *       Arguments:
     *         appId: example_id
     *         nameRegex: ^my-GreyTagRoute
     * outputs:
     *   saeGreyTagRoutesId: ${nameRegex.routes[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getGreyTagRoutes.
     * @return A collection of values returned by getGreyTagRoutes.
     */
    public suspend fun getGreyTagRoutes(argument: GetGreyTagRoutesPlainArgs): GetGreyTagRoutesResult =
        getGreyTagRoutesResultToKotlin(getGreyTagRoutesPlain(argument.toJava()).await())

    /**
     * @see [getGreyTagRoutes].
     * @param appId The ID  of the SAE Application.
     * @param ids A list of GreyTagRoute IDs.
     * @param nameRegex A regex string to filter results by GreyTagRoute name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getGreyTagRoutes.
     */
    public suspend fun getGreyTagRoutes(
        appId: String,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetGreyTagRoutesResult {
        val argument = GetGreyTagRoutesPlainArgs(
            appId = appId,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getGreyTagRoutesResultToKotlin(getGreyTagRoutesPlain(argument.toJava()).await())
    }

    /**
     * @see [getGreyTagRoutes].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;sae&#46;kotlin&#46;inputs&#46;GetGreyTagRoutesPlainArgs].
     * @return A collection of values returned by getGreyTagRoutes.
     */
    public suspend fun getGreyTagRoutes(argument: suspend GetGreyTagRoutesPlainArgsBuilder.() -> Unit): GetGreyTagRoutesResult {
        val builder = GetGreyTagRoutesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGreyTagRoutesResultToKotlin(getGreyTagRoutesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Sae Ingresses of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.137.0+.
     * @param argument A collection of arguments for invoking getIngresses.
     * @return A collection of values returned by getIngresses.
     */
    public suspend fun getIngresses(argument: GetIngressesPlainArgs): GetIngressesResult =
        getIngressesResultToKotlin(getIngressesPlain(argument.toJava()).await())

    /**
     * @see [getIngresses].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Ingress IDs.
     * @param namespaceId The Id of Namespace.It can contain 2 to 32 lowercase characters.The value is in format `{RegionId}:{namespace}`
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getIngresses.
     */
    public suspend fun getIngresses(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        namespaceId: String,
        outputFile: String? = null,
    ): GetIngressesResult {
        val argument = GetIngressesPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            namespaceId = namespaceId,
            outputFile = outputFile,
        )
        return getIngressesResultToKotlin(getIngressesPlain(argument.toJava()).await())
    }

    /**
     * @see [getIngresses].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;sae&#46;kotlin&#46;inputs&#46;GetIngressesPlainArgs].
     * @return A collection of values returned by getIngresses.
     */
    public suspend fun getIngresses(argument: suspend GetIngressesPlainArgsBuilder.() -> Unit): GetIngressesResult {
        val builder = GetIngressesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIngressesResultToKotlin(getIngressesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Sae Instance Specifications of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.139.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.sae.getInstanceSpecifications({});
     * export const saeInstanceSpecificationId1 = ids.then(ids => ids.specifications?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.sae.get_instance_specifications()
     * pulumi.export("saeInstanceSpecificationId1", ids.specifications[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Sae.GetInstanceSpecifications.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["saeInstanceSpecificationId1"] = ids&#46;Apply(getInstanceSpecificationsResult => getInstanceSpecificationsResult&#46;Specifications[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/sae"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := sae.GetInstanceSpecifications(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("saeInstanceSpecificationId1", ids.Specifications[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.sae.SaeFunctions;
     * import com.pulumi.alicloud.sae.inputs.GetInstanceSpecificationsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = SaeFunctions.getInstanceSpecifications();
     *         ctx.export("saeInstanceSpecificationId1", ids.applyValue(getInstanceSpecificationsResult -> getInstanceSpecificationsResult.specifications()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:sae:getInstanceSpecifications
     *       Arguments: {}
     * outputs:
     *   saeInstanceSpecificationId1: ${ids.specifications[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstanceSpecifications.
     * @return A collection of values returned by getInstanceSpecifications.
     */
    public suspend fun getInstanceSpecifications(argument: GetInstanceSpecificationsPlainArgs): GetInstanceSpecificationsResult =
        getInstanceSpecificationsResultToKotlin(getInstanceSpecificationsPlain(argument.toJava()).await())

    /**
     * @see [getInstanceSpecifications].
     * @param ids A list of Instance Specification IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getInstanceSpecifications.
     */
    public suspend fun getInstanceSpecifications(
        ids: List<String>? = null,
        outputFile: String? =
            null,
    ): GetInstanceSpecificationsResult {
        val argument = GetInstanceSpecificationsPlainArgs(
            ids = ids,
            outputFile = outputFile,
        )
        return getInstanceSpecificationsResultToKotlin(getInstanceSpecificationsPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstanceSpecifications].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;sae&#46;kotlin&#46;inputs&#46;GetInstanceSpecificationsPlainArgs].
     * @return A collection of values returned by getInstanceSpecifications.
     */
    public suspend fun getInstanceSpecifications(argument: suspend GetInstanceSpecificationsPlainArgsBuilder.() -> Unit): GetInstanceSpecificationsResult {
        val builder = GetInstanceSpecificationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceSpecificationsResultToKotlin(getInstanceSpecificationsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Sae Namespaces of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.129.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const nameRegex = alicloud.sae.getNamespaces({
     *     nameRegex: "^my-Namespace",
     * });
     * export const saeNamespaceId = nameRegex.then(nameRegex => nameRegex.namespaces?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * name_regex = alicloud.sae.get_namespaces(name_regex="^my-Namespace")
     * pulumi.export("saeNamespaceId", name_regex.namespaces[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var nameRegex = AliCloud.Sae.GetNamespaces.Invoke(new()
     *     {
     *         NameRegex = "^my-Namespace",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["saeNamespaceId"] = nameRegex&#46;Apply(getNamespacesResult => getNamespacesResult&#46;Namespaces[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/sae"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		nameRegex, err := sae.GetNamespaces(ctx, &sae.GetNamespacesArgs{
     * 			NameRegex: pulumi.StringRef("^my-Namespace"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("saeNamespaceId", nameRegex.Namespaces[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.sae.SaeFunctions;
     * import com.pulumi.alicloud.sae.inputs.GetNamespacesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var nameRegex = SaeFunctions.getNamespaces(GetNamespacesArgs.builder()
     *             .nameRegex("^my-Namespace")
     *             .build());
     *         ctx.export("saeNamespaceId", nameRegex.applyValue(getNamespacesResult -> getNamespacesResult.namespaces()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:sae:getNamespaces
     *       Arguments:
     *         nameRegex: ^my-Namespace
     * outputs:
     *   saeNamespaceId: ${nameRegex.namespaces[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getNamespaces.
     * @return A collection of values returned by getNamespaces.
     */
    public suspend fun getNamespaces(argument: GetNamespacesPlainArgs): GetNamespacesResult =
        getNamespacesResultToKotlin(getNamespacesPlain(argument.toJava()).await())

    /**
     * @see [getNamespaces].
     * @param ids A list of Namespace IDs.
     * @param nameRegex A regex string to filter results by Namespace name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getNamespaces.
     */
    public suspend fun getNamespaces(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetNamespacesResult {
        val argument = GetNamespacesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getNamespacesResultToKotlin(getNamespacesPlain(argument.toJava()).await())
    }

    /**
     * @see [getNamespaces].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;sae&#46;kotlin&#46;inputs&#46;GetNamespacesPlainArgs].
     * @return A collection of values returned by getNamespaces.
     */
    public suspend fun getNamespaces(argument: suspend GetNamespacesPlainArgsBuilder.() -> Unit): GetNamespacesResult {
        val builder = GetNamespacesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNamespacesResultToKotlin(getNamespacesPlain(builtArgument.toJava()).await())
    }

    /**
     * Using this data source can open SAE service automatically. If the service has been opened, it will return opened.
     * For information about SAE and how to use it, see [What is SAE](https://help.aliyun.com/document_detail/125720.html).
     * > **NOTE:** Available in v1.120.0+
     * > **NOTE:** The SAE service is not support in the international site.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const open = alicloud.sae.getService({
     *     enable: "On",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * open = alicloud.sae.get_service(enable="On")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var open = AliCloud.Sae.GetService.Invoke(new()
     *     {
     *         Enable = "On",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/sae"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := sae.GetService(ctx, &sae.GetServiceArgs{
     * 			Enable: pulumi.StringRef("On"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.sae.SaeFunctions;
     * import com.pulumi.alicloud.sae.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var open = SaeFunctions.getService(GetServiceArgs.builder()
     *             .enable("On")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   open:
     *     fn::invoke:
     *       Function: alicloud:sae:getService
     *       Arguments:
     *         enable: On
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getService.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param enable Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: "On" or "Off". Default to "Off".
     * > **NOTE:** Setting `enable = "On"` to open the SAE service that means you have read and agreed the [SAE Terms of Service](https://help.aliyun.com/document_detail/123775.html). The service can not closed once it is opened.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(enable: String? = null): GetServiceResult {
        val argument = GetServicePlainArgs(
            enable = enable,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;sae&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit): GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }
}
