@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.inputs

import com.pulumi.alicloud.sae.inputs.ApplicationConfigMapMountDescV2Args.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property configMapId The ID of the ConfigMap.
 * @property key The key.
 * @property mountPath The mount path.
 */
public data class ApplicationConfigMapMountDescV2Args(
    public val configMapId: Output<String>? = null,
    public val key: Output<String>? = null,
    public val mountPath: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sae.inputs.ApplicationConfigMapMountDescV2Args> {
    override fun toJava(): com.pulumi.alicloud.sae.inputs.ApplicationConfigMapMountDescV2Args =
        com.pulumi.alicloud.sae.inputs.ApplicationConfigMapMountDescV2Args.builder()
            .configMapId(configMapId?.applyValue({ args0 -> args0 }))
            .key(key?.applyValue({ args0 -> args0 }))
            .mountPath(mountPath?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationConfigMapMountDescV2Args].
 */
@PulumiTagMarker
public class ApplicationConfigMapMountDescV2ArgsBuilder internal constructor() {
    private var configMapId: Output<String>? = null

    private var key: Output<String>? = null

    private var mountPath: Output<String>? = null

    /**
     * @param value The ID of the ConfigMap.
     */
    @JvmName("vcjxmifycocnwctw")
    public suspend fun configMapId(`value`: Output<String>) {
        this.configMapId = value
    }

    /**
     * @param value The key.
     */
    @JvmName("xoxivhpgpgdyjuhb")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The mount path.
     */
    @JvmName("bouavrcjxdkrgmjb")
    public suspend fun mountPath(`value`: Output<String>) {
        this.mountPath = value
    }

    /**
     * @param value The ID of the ConfigMap.
     */
    @JvmName("pmqyqqiaqwkrssvq")
    public suspend fun configMapId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configMapId = mapped
    }

    /**
     * @param value The key.
     */
    @JvmName("pwuvfobimdlammyg")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The mount path.
     */
    @JvmName("nvyuribsqqxpbgqn")
    public suspend fun mountPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mountPath = mapped
    }

    internal fun build(): ApplicationConfigMapMountDescV2Args = ApplicationConfigMapMountDescV2Args(
        configMapId = configMapId,
        key = key,
        mountPath = mountPath,
    )
}
