@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.inputs

import com.pulumi.alicloud.sae.inputs.ApplicationCustomHostAliasV2Args.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property hostName The domain name or hostname.
 * @property ip The IP address.
 */
public data class ApplicationCustomHostAliasV2Args(
    public val hostName: Output<String>? = null,
    public val ip: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sae.inputs.ApplicationCustomHostAliasV2Args> {
    override fun toJava(): com.pulumi.alicloud.sae.inputs.ApplicationCustomHostAliasV2Args =
        com.pulumi.alicloud.sae.inputs.ApplicationCustomHostAliasV2Args.builder()
            .hostName(hostName?.applyValue({ args0 -> args0 }))
            .ip(ip?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationCustomHostAliasV2Args].
 */
@PulumiTagMarker
public class ApplicationCustomHostAliasV2ArgsBuilder internal constructor() {
    private var hostName: Output<String>? = null

    private var ip: Output<String>? = null

    /**
     * @param value The domain name or hostname.
     */
    @JvmName("pbtflcmbqmnplglv")
    public suspend fun hostName(`value`: Output<String>) {
        this.hostName = value
    }

    /**
     * @param value The IP address.
     */
    @JvmName("imtvspxhrmkcluvg")
    public suspend fun ip(`value`: Output<String>) {
        this.ip = value
    }

    /**
     * @param value The domain name or hostname.
     */
    @JvmName("qwgtinjgngqfmplo")
    public suspend fun hostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostName = mapped
    }

    /**
     * @param value The IP address.
     */
    @JvmName("ilakmwljmowurwnb")
    public suspend fun ip(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ip = mapped
    }

    internal fun build(): ApplicationCustomHostAliasV2Args = ApplicationCustomHostAliasV2Args(
        hostName = hostName,
        ip = ip,
    )
}
