@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.inputs

import com.pulumi.alicloud.sae.inputs.ApplicationKafkaConfigsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property kafkaConfigs One or more logging configurations of ApsaraMQ for Kafka. See `kafka_configs` below.
 * @property kafkaEndpoint The endpoint of the ApsaraMQ for Kafka API.
 * @property kafkaInstanceId The  ID of the ApsaraMQ for Kafka instance.
 */
public data class ApplicationKafkaConfigsArgs(
    public val kafkaConfigs: Output<List<ApplicationKafkaConfigsKafkaConfigArgs>>? = null,
    public val kafkaEndpoint: Output<String>? = null,
    public val kafkaInstanceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sae.inputs.ApplicationKafkaConfigsArgs> {
    override fun toJava(): com.pulumi.alicloud.sae.inputs.ApplicationKafkaConfigsArgs =
        com.pulumi.alicloud.sae.inputs.ApplicationKafkaConfigsArgs.builder()
            .kafkaConfigs(
                kafkaConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .kafkaEndpoint(kafkaEndpoint?.applyValue({ args0 -> args0 }))
            .kafkaInstanceId(kafkaInstanceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationKafkaConfigsArgs].
 */
@PulumiTagMarker
public class ApplicationKafkaConfigsArgsBuilder internal constructor() {
    private var kafkaConfigs: Output<List<ApplicationKafkaConfigsKafkaConfigArgs>>? = null

    private var kafkaEndpoint: Output<String>? = null

    private var kafkaInstanceId: Output<String>? = null

    /**
     * @param value One or more logging configurations of ApsaraMQ for Kafka. See `kafka_configs` below.
     */
    @JvmName("vjmjqwumapjiepmt")
    public suspend fun kafkaConfigs(`value`: Output<List<ApplicationKafkaConfigsKafkaConfigArgs>>) {
        this.kafkaConfigs = value
    }

    @JvmName("xewwcikjdjporxqe")
    public suspend fun kafkaConfigs(vararg values: Output<ApplicationKafkaConfigsKafkaConfigArgs>) {
        this.kafkaConfigs = Output.all(values.asList())
    }

    /**
     * @param values One or more logging configurations of ApsaraMQ for Kafka. See `kafka_configs` below.
     */
    @JvmName("lnodtarcuiatlsff")
    public suspend fun kafkaConfigs(values: List<Output<ApplicationKafkaConfigsKafkaConfigArgs>>) {
        this.kafkaConfigs = Output.all(values)
    }

    /**
     * @param value The endpoint of the ApsaraMQ for Kafka API.
     */
    @JvmName("ogcbytgmwnatpiis")
    public suspend fun kafkaEndpoint(`value`: Output<String>) {
        this.kafkaEndpoint = value
    }

    /**
     * @param value The  ID of the ApsaraMQ for Kafka instance.
     */
    @JvmName("avxakaancdhkbnhn")
    public suspend fun kafkaInstanceId(`value`: Output<String>) {
        this.kafkaInstanceId = value
    }

    /**
     * @param value One or more logging configurations of ApsaraMQ for Kafka. See `kafka_configs` below.
     */
    @JvmName("mhqbrasvcdhxontk")
    public suspend fun kafkaConfigs(`value`: List<ApplicationKafkaConfigsKafkaConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kafkaConfigs = mapped
    }

    /**
     * @param argument One or more logging configurations of ApsaraMQ for Kafka. See `kafka_configs` below.
     */
    @JvmName("musmotrilfsritdv")
    public suspend fun kafkaConfigs(argument: List<suspend ApplicationKafkaConfigsKafkaConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationKafkaConfigsKafkaConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.kafkaConfigs = mapped
    }

    /**
     * @param argument One or more logging configurations of ApsaraMQ for Kafka. See `kafka_configs` below.
     */
    @JvmName("nfnwggbfxefpygjc")
    public suspend fun kafkaConfigs(vararg argument: suspend ApplicationKafkaConfigsKafkaConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ApplicationKafkaConfigsKafkaConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.kafkaConfigs = mapped
    }

    /**
     * @param argument One or more logging configurations of ApsaraMQ for Kafka. See `kafka_configs` below.
     */
    @JvmName("doqrhiulcowlmqed")
    public suspend fun kafkaConfigs(argument: suspend ApplicationKafkaConfigsKafkaConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationKafkaConfigsKafkaConfigArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.kafkaConfigs = mapped
    }

    /**
     * @param values One or more logging configurations of ApsaraMQ for Kafka. See `kafka_configs` below.
     */
    @JvmName("tmagfnqonnanaekl")
    public suspend fun kafkaConfigs(vararg values: ApplicationKafkaConfigsKafkaConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kafkaConfigs = mapped
    }

    /**
     * @param value The endpoint of the ApsaraMQ for Kafka API.
     */
    @JvmName("qarmdivarqmgxjph")
    public suspend fun kafkaEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kafkaEndpoint = mapped
    }

    /**
     * @param value The  ID of the ApsaraMQ for Kafka instance.
     */
    @JvmName("tdrkghciqujernin")
    public suspend fun kafkaInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kafkaInstanceId = mapped
    }

    internal fun build(): ApplicationKafkaConfigsArgs = ApplicationKafkaConfigsArgs(
        kafkaConfigs = kafkaConfigs,
        kafkaEndpoint = kafkaEndpoint,
        kafkaInstanceId = kafkaInstanceId,
    )
}
