@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.inputs

import com.pulumi.alicloud.sae.inputs.ApplicationKafkaConfigsKafkaConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property kafkaTopic The topic of the Kafka.
 * @property logDir The path in which logs are stored.
 * @property logType The type of the log.
 */
public data class ApplicationKafkaConfigsKafkaConfigArgs(
    public val kafkaTopic: Output<String>? = null,
    public val logDir: Output<String>? = null,
    public val logType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sae.inputs.ApplicationKafkaConfigsKafkaConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.sae.inputs.ApplicationKafkaConfigsKafkaConfigArgs =
        com.pulumi.alicloud.sae.inputs.ApplicationKafkaConfigsKafkaConfigArgs.builder()
            .kafkaTopic(kafkaTopic?.applyValue({ args0 -> args0 }))
            .logDir(logDir?.applyValue({ args0 -> args0 }))
            .logType(logType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationKafkaConfigsKafkaConfigArgs].
 */
@PulumiTagMarker
public class ApplicationKafkaConfigsKafkaConfigArgsBuilder internal constructor() {
    private var kafkaTopic: Output<String>? = null

    private var logDir: Output<String>? = null

    private var logType: Output<String>? = null

    /**
     * @param value The topic of the Kafka.
     */
    @JvmName("jocdgwdapldfyhcj")
    public suspend fun kafkaTopic(`value`: Output<String>) {
        this.kafkaTopic = value
    }

    /**
     * @param value The path in which logs are stored.
     */
    @JvmName("ptkfywicuhsvcefa")
    public suspend fun logDir(`value`: Output<String>) {
        this.logDir = value
    }

    /**
     * @param value The type of the log.
     */
    @JvmName("cimiwokwjsswuihl")
    public suspend fun logType(`value`: Output<String>) {
        this.logType = value
    }

    /**
     * @param value The topic of the Kafka.
     */
    @JvmName("iwoncrenocqlghwl")
    public suspend fun kafkaTopic(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kafkaTopic = mapped
    }

    /**
     * @param value The path in which logs are stored.
     */
    @JvmName("dovlqcllambrttrn")
    public suspend fun logDir(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logDir = mapped
    }

    /**
     * @param value The type of the log.
     */
    @JvmName("fibrygpjcggfcwld")
    public suspend fun logType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logType = mapped
    }

    internal fun build(): ApplicationKafkaConfigsKafkaConfigArgs =
        ApplicationKafkaConfigsKafkaConfigArgs(
            kafkaTopic = kafkaTopic,
            logDir = logDir,
            logType = logType,
        )
}
