@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.inputs

import com.pulumi.alicloud.sae.inputs.ApplicationLivenessV2Args.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property exec Execute. See `exec` below.
 * @property httpGet The liveness check settings of the container. See `http_get` below.
 * @property initialDelaySeconds The delay of the health check.
 * @property periodSeconds The interval at which the health check is performed.
 * @property tcpSocket The liveness check settings of the container. See `tcp_socket` below.
 * @property timeoutSeconds The timeout period of the health check.
 */
public data class ApplicationLivenessV2Args(
    public val exec: Output<ApplicationLivenessV2ExecArgs>? = null,
    public val httpGet: Output<ApplicationLivenessV2HttpGetArgs>? = null,
    public val initialDelaySeconds: Output<Int>? = null,
    public val periodSeconds: Output<Int>? = null,
    public val tcpSocket: Output<ApplicationLivenessV2TcpSocketArgs>? = null,
    public val timeoutSeconds: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sae.inputs.ApplicationLivenessV2Args> {
    override fun toJava(): com.pulumi.alicloud.sae.inputs.ApplicationLivenessV2Args =
        com.pulumi.alicloud.sae.inputs.ApplicationLivenessV2Args.builder()
            .exec(exec?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .httpGet(httpGet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .initialDelaySeconds(initialDelaySeconds?.applyValue({ args0 -> args0 }))
            .periodSeconds(periodSeconds?.applyValue({ args0 -> args0 }))
            .tcpSocket(tcpSocket?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .timeoutSeconds(timeoutSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationLivenessV2Args].
 */
@PulumiTagMarker
public class ApplicationLivenessV2ArgsBuilder internal constructor() {
    private var exec: Output<ApplicationLivenessV2ExecArgs>? = null

    private var httpGet: Output<ApplicationLivenessV2HttpGetArgs>? = null

    private var initialDelaySeconds: Output<Int>? = null

    private var periodSeconds: Output<Int>? = null

    private var tcpSocket: Output<ApplicationLivenessV2TcpSocketArgs>? = null

    private var timeoutSeconds: Output<Int>? = null

    /**
     * @param value Execute. See `exec` below.
     */
    @JvmName("rirroqovagvuopkj")
    public suspend fun exec(`value`: Output<ApplicationLivenessV2ExecArgs>) {
        this.exec = value
    }

    /**
     * @param value The liveness check settings of the container. See `http_get` below.
     */
    @JvmName("nffokxalpiiqyvjy")
    public suspend fun httpGet(`value`: Output<ApplicationLivenessV2HttpGetArgs>) {
        this.httpGet = value
    }

    /**
     * @param value The delay of the health check.
     */
    @JvmName("imrrmhfbvjiocwog")
    public suspend fun initialDelaySeconds(`value`: Output<Int>) {
        this.initialDelaySeconds = value
    }

    /**
     * @param value The interval at which the health check is performed.
     */
    @JvmName("fftsplsslsfgshqu")
    public suspend fun periodSeconds(`value`: Output<Int>) {
        this.periodSeconds = value
    }

    /**
     * @param value The liveness check settings of the container. See `tcp_socket` below.
     */
    @JvmName("wglkukitbtymjkmv")
    public suspend fun tcpSocket(`value`: Output<ApplicationLivenessV2TcpSocketArgs>) {
        this.tcpSocket = value
    }

    /**
     * @param value The timeout period of the health check.
     */
    @JvmName("qclaschmardjfbdg")
    public suspend fun timeoutSeconds(`value`: Output<Int>) {
        this.timeoutSeconds = value
    }

    /**
     * @param value Execute. See `exec` below.
     */
    @JvmName("fpqefwbhccurulcc")
    public suspend fun exec(`value`: ApplicationLivenessV2ExecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exec = mapped
    }

    /**
     * @param argument Execute. See `exec` below.
     */
    @JvmName("kimwiucdydllcufp")
    public suspend fun exec(argument: suspend ApplicationLivenessV2ExecArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationLivenessV2ExecArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.exec = mapped
    }

    /**
     * @param value The liveness check settings of the container. See `http_get` below.
     */
    @JvmName("gxnucgscjqrtxbbf")
    public suspend fun httpGet(`value`: ApplicationLivenessV2HttpGetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpGet = mapped
    }

    /**
     * @param argument The liveness check settings of the container. See `http_get` below.
     */
    @JvmName("oxvmcimfufypinad")
    public suspend fun httpGet(argument: suspend ApplicationLivenessV2HttpGetArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationLivenessV2HttpGetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.httpGet = mapped
    }

    /**
     * @param value The delay of the health check.
     */
    @JvmName("qntmdhkfkndrarth")
    public suspend fun initialDelaySeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialDelaySeconds = mapped
    }

    /**
     * @param value The interval at which the health check is performed.
     */
    @JvmName("iusbdvhcsryvrrlv")
    public suspend fun periodSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.periodSeconds = mapped
    }

    /**
     * @param value The liveness check settings of the container. See `tcp_socket` below.
     */
    @JvmName("hvsergyocsfcfcyd")
    public suspend fun tcpSocket(`value`: ApplicationLivenessV2TcpSocketArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tcpSocket = mapped
    }

    /**
     * @param argument The liveness check settings of the container. See `tcp_socket` below.
     */
    @JvmName("sgjgyoyveblflmtv")
    public suspend fun tcpSocket(argument: suspend ApplicationLivenessV2TcpSocketArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationLivenessV2TcpSocketArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tcpSocket = mapped
    }

    /**
     * @param value The timeout period of the health check.
     */
    @JvmName("theskwmljmmqjver")
    public suspend fun timeoutSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutSeconds = mapped
    }

    internal fun build(): ApplicationLivenessV2Args = ApplicationLivenessV2Args(
        exec = exec,
        httpGet = httpGet,
        initialDelaySeconds = initialDelaySeconds,
        periodSeconds = periodSeconds,
        tcpSocket = tcpSocket,
        timeoutSeconds = timeoutSeconds,
    )
}
