@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.inputs

import com.pulumi.alicloud.sae.inputs.ApplicationNasConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property mountDomain The domain name of the mount target.
 * @property mountPath The mount path of the container.
 * @property nasId The ID of the NAS file system.
 * @property nasPath The directory in the NAS file system.
 * @property readOnly Specifies whether the application can read data from or write data to resources in the directory of the NAS. Valid values: `true` and `false`. If you set `read_only` to `false`, the application has the read and write permissions.
 */
public data class ApplicationNasConfigArgs(
    public val mountDomain: Output<String>? = null,
    public val mountPath: Output<String>? = null,
    public val nasId: Output<String>? = null,
    public val nasPath: Output<String>? = null,
    public val readOnly: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sae.inputs.ApplicationNasConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.sae.inputs.ApplicationNasConfigArgs =
        com.pulumi.alicloud.sae.inputs.ApplicationNasConfigArgs.builder()
            .mountDomain(mountDomain?.applyValue({ args0 -> args0 }))
            .mountPath(mountPath?.applyValue({ args0 -> args0 }))
            .nasId(nasId?.applyValue({ args0 -> args0 }))
            .nasPath(nasPath?.applyValue({ args0 -> args0 }))
            .readOnly(readOnly?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationNasConfigArgs].
 */
@PulumiTagMarker
public class ApplicationNasConfigArgsBuilder internal constructor() {
    private var mountDomain: Output<String>? = null

    private var mountPath: Output<String>? = null

    private var nasId: Output<String>? = null

    private var nasPath: Output<String>? = null

    private var readOnly: Output<Boolean>? = null

    /**
     * @param value The domain name of the mount target.
     */
    @JvmName("hssgmylckhisucdu")
    public suspend fun mountDomain(`value`: Output<String>) {
        this.mountDomain = value
    }

    /**
     * @param value The mount path of the container.
     */
    @JvmName("iwqumblaacmrohei")
    public suspend fun mountPath(`value`: Output<String>) {
        this.mountPath = value
    }

    /**
     * @param value The ID of the NAS file system.
     */
    @JvmName("kauyykxmnrfmelnn")
    public suspend fun nasId(`value`: Output<String>) {
        this.nasId = value
    }

    /**
     * @param value The directory in the NAS file system.
     */
    @JvmName("hpdqfwbfivuwkdke")
    public suspend fun nasPath(`value`: Output<String>) {
        this.nasPath = value
    }

    /**
     * @param value Specifies whether the application can read data from or write data to resources in the directory of the NAS. Valid values: `true` and `false`. If you set `read_only` to `false`, the application has the read and write permissions.
     */
    @JvmName("ppjplpxoatvhwrgw")
    public suspend fun readOnly(`value`: Output<Boolean>) {
        this.readOnly = value
    }

    /**
     * @param value The domain name of the mount target.
     */
    @JvmName("nhmxadwkywinafku")
    public suspend fun mountDomain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mountDomain = mapped
    }

    /**
     * @param value The mount path of the container.
     */
    @JvmName("sglwkilggdhsljsf")
    public suspend fun mountPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mountPath = mapped
    }

    /**
     * @param value The ID of the NAS file system.
     */
    @JvmName("atjknkxpisaieray")
    public suspend fun nasId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nasId = mapped
    }

    /**
     * @param value The directory in the NAS file system.
     */
    @JvmName("sihyscojsnbfcxgy")
    public suspend fun nasPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nasPath = mapped
    }

    /**
     * @param value Specifies whether the application can read data from or write data to resources in the directory of the NAS. Valid values: `true` and `false`. If you set `read_only` to `false`, the application has the read and write permissions.
     */
    @JvmName("stukmoahouafeeio")
    public suspend fun readOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readOnly = mapped
    }

    internal fun build(): ApplicationNasConfigArgs = ApplicationNasConfigArgs(
        mountDomain = mountDomain,
        mountPath = mountPath,
        nasId = nasId,
        nasPath = nasPath,
        readOnly = readOnly,
    )
}
