@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.inputs

import com.pulumi.alicloud.sae.inputs.ApplicationOssMountDescsV2Args.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucketName The name of the OSS bucket.
 * @property bucketPath The directory or object in OSS.
 * @property mountPath The path of the container in SAE.
 * @property readOnly Specifies whether the application can use the container path to read data from or write data to resources in the directory of the OSS bucket. Valid values:
 */
public data class ApplicationOssMountDescsV2Args(
    public val bucketName: Output<String>? = null,
    public val bucketPath: Output<String>? = null,
    public val mountPath: Output<String>? = null,
    public val readOnly: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sae.inputs.ApplicationOssMountDescsV2Args> {
    override fun toJava(): com.pulumi.alicloud.sae.inputs.ApplicationOssMountDescsV2Args =
        com.pulumi.alicloud.sae.inputs.ApplicationOssMountDescsV2Args.builder()
            .bucketName(bucketName?.applyValue({ args0 -> args0 }))
            .bucketPath(bucketPath?.applyValue({ args0 -> args0 }))
            .mountPath(mountPath?.applyValue({ args0 -> args0 }))
            .readOnly(readOnly?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationOssMountDescsV2Args].
 */
@PulumiTagMarker
public class ApplicationOssMountDescsV2ArgsBuilder internal constructor() {
    private var bucketName: Output<String>? = null

    private var bucketPath: Output<String>? = null

    private var mountPath: Output<String>? = null

    private var readOnly: Output<Boolean>? = null

    /**
     * @param value The name of the OSS bucket.
     */
    @JvmName("ssnxbtcdssecprjc")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value The directory or object in OSS.
     */
    @JvmName("ovrdasfsavbduevv")
    public suspend fun bucketPath(`value`: Output<String>) {
        this.bucketPath = value
    }

    /**
     * @param value The path of the container in SAE.
     */
    @JvmName("gphphjwqcuaehwwm")
    public suspend fun mountPath(`value`: Output<String>) {
        this.mountPath = value
    }

    /**
     * @param value Specifies whether the application can use the container path to read data from or write data to resources in the directory of the OSS bucket. Valid values:
     */
    @JvmName("rhcpiqgsnnewkrtf")
    public suspend fun readOnly(`value`: Output<Boolean>) {
        this.readOnly = value
    }

    /**
     * @param value The name of the OSS bucket.
     */
    @JvmName("eshnkueogtehugau")
    public suspend fun bucketName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value The directory or object in OSS.
     */
    @JvmName("wqeesrxapvkvaybr")
    public suspend fun bucketPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketPath = mapped
    }

    /**
     * @param value The path of the container in SAE.
     */
    @JvmName("rflbyysmsilcqaei")
    public suspend fun mountPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mountPath = mapped
    }

    /**
     * @param value Specifies whether the application can use the container path to read data from or write data to resources in the directory of the OSS bucket. Valid values:
     */
    @JvmName("tctinhctoyxexldu")
    public suspend fun readOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readOnly = mapped
    }

    internal fun build(): ApplicationOssMountDescsV2Args = ApplicationOssMountDescsV2Args(
        bucketName = bucketName,
        bucketPath = bucketPath,
        mountPath = mountPath,
        readOnly = readOnly,
    )
}
