@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.inputs

import com.pulumi.alicloud.sae.inputs.ApplicationPvtzDiscoverySvcArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property enable Enables the Kubernetes Service-based registration and discovery feature.
 * @property namespaceId The ID of the namespace.
 * @property portProtocols The port number and protocol. See `port_protocols` below.
 * @property serviceName The name of the Service.
 */
public data class ApplicationPvtzDiscoverySvcArgs(
    public val enable: Output<Boolean>? = null,
    public val namespaceId: Output<String>? = null,
    public val portProtocols: Output<List<ApplicationPvtzDiscoverySvcPortProtocolArgs>>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sae.inputs.ApplicationPvtzDiscoverySvcArgs> {
    override fun toJava(): com.pulumi.alicloud.sae.inputs.ApplicationPvtzDiscoverySvcArgs =
        com.pulumi.alicloud.sae.inputs.ApplicationPvtzDiscoverySvcArgs.builder()
            .enable(enable?.applyValue({ args0 -> args0 }))
            .namespaceId(namespaceId?.applyValue({ args0 -> args0 }))
            .portProtocols(
                portProtocols?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationPvtzDiscoverySvcArgs].
 */
@PulumiTagMarker
public class ApplicationPvtzDiscoverySvcArgsBuilder internal constructor() {
    private var enable: Output<Boolean>? = null

    private var namespaceId: Output<String>? = null

    private var portProtocols: Output<List<ApplicationPvtzDiscoverySvcPortProtocolArgs>>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value Enables the Kubernetes Service-based registration and discovery feature.
     */
    @JvmName("clxvrivipnvjlnej")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value The ID of the namespace.
     */
    @JvmName("hvqlgnevoikppjls")
    public suspend fun namespaceId(`value`: Output<String>) {
        this.namespaceId = value
    }

    /**
     * @param value The port number and protocol. See `port_protocols` below.
     */
    @JvmName("xjtaxeurksetgkst")
    public suspend fun portProtocols(`value`: Output<List<ApplicationPvtzDiscoverySvcPortProtocolArgs>>) {
        this.portProtocols = value
    }

    @JvmName("bydkfyxwkushsbkl")
    public suspend fun portProtocols(vararg values: Output<ApplicationPvtzDiscoverySvcPortProtocolArgs>) {
        this.portProtocols = Output.all(values.asList())
    }

    /**
     * @param values The port number and protocol. See `port_protocols` below.
     */
    @JvmName("duixshrhtxbjqwqh")
    public suspend fun portProtocols(values: List<Output<ApplicationPvtzDiscoverySvcPortProtocolArgs>>) {
        this.portProtocols = Output.all(values)
    }

    /**
     * @param value The name of the Service.
     */
    @JvmName("foudnhtmueqlsqsx")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Enables the Kubernetes Service-based registration and discovery feature.
     */
    @JvmName("bnvshaqdejvffeno")
    public suspend fun enable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value The ID of the namespace.
     */
    @JvmName("mykehwjptmlkqjyu")
    public suspend fun namespaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceId = mapped
    }

    /**
     * @param value The port number and protocol. See `port_protocols` below.
     */
    @JvmName("kkngknstjorixcex")
    public suspend fun portProtocols(`value`: List<ApplicationPvtzDiscoverySvcPortProtocolArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portProtocols = mapped
    }

    /**
     * @param argument The port number and protocol. See `port_protocols` below.
     */
    @JvmName("ybnvikxostrmiwbu")
    public suspend fun portProtocols(argument: List<suspend ApplicationPvtzDiscoverySvcPortProtocolArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationPvtzDiscoverySvcPortProtocolArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.portProtocols = mapped
    }

    /**
     * @param argument The port number and protocol. See `port_protocols` below.
     */
    @JvmName("tppebfheeajgevtb")
    public suspend fun portProtocols(vararg argument: suspend ApplicationPvtzDiscoverySvcPortProtocolArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ApplicationPvtzDiscoverySvcPortProtocolArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.portProtocols = mapped
    }

    /**
     * @param argument The port number and protocol. See `port_protocols` below.
     */
    @JvmName("ljafsdnfebiytcgc")
    public suspend fun portProtocols(argument: suspend ApplicationPvtzDiscoverySvcPortProtocolArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationPvtzDiscoverySvcPortProtocolArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.portProtocols = mapped
    }

    /**
     * @param values The port number and protocol. See `port_protocols` below.
     */
    @JvmName("npnuovytfofimxwr")
    public suspend fun portProtocols(vararg values: ApplicationPvtzDiscoverySvcPortProtocolArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.portProtocols = mapped
    }

    /**
     * @param value The name of the Service.
     */
    @JvmName("stvbpjohttanafhc")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): ApplicationPvtzDiscoverySvcArgs = ApplicationPvtzDiscoverySvcArgs(
        enable = enable,
        namespaceId = namespaceId,
        portProtocols = portProtocols,
        serviceName = serviceName,
    )
}
