@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.inputs

import com.pulumi.alicloud.sae.inputs.ApplicationPvtzDiscoverySvcPortProtocolArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property port
 * @property protocol The protocol. Valid values: `TCP` and `UDP`.
 */
public data class ApplicationPvtzDiscoverySvcPortProtocolArgs(
    public val port: Output<Int>? = null,
    public val protocol: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sae.inputs.ApplicationPvtzDiscoverySvcPortProtocolArgs> {
    override fun toJava(): com.pulumi.alicloud.sae.inputs.ApplicationPvtzDiscoverySvcPortProtocolArgs = com.pulumi.alicloud.sae.inputs.ApplicationPvtzDiscoverySvcPortProtocolArgs.builder()
        .port(port?.applyValue({ args0 -> args0 }))
        .protocol(protocol?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationPvtzDiscoverySvcPortProtocolArgs].
 */
@PulumiTagMarker
public class ApplicationPvtzDiscoverySvcPortProtocolArgsBuilder internal constructor() {
    private var port: Output<Int>? = null

    private var protocol: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("kcxendiiadaameqo")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The protocol. Valid values: `TCP` and `UDP`.
     */
    @JvmName("qxfuknlanfpaxgom")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value
     */
    @JvmName("fxfarocxdhmjebcj")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The protocol. Valid values: `TCP` and `UDP`.
     */
    @JvmName("psrxhvjreabtqgcm")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    internal fun build(): ApplicationPvtzDiscoverySvcPortProtocolArgs =
        ApplicationPvtzDiscoverySvcPortProtocolArgs(
            port = port,
            protocol = protocol,
        )
}
