@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.inputs

import com.pulumi.alicloud.sae.inputs.ApplicationReadinessV2Args.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property exec Execute. See `exec` below.
 * @property httpGet The liveness check settings of the container. See `http_get` below.
 * @property initialDelaySeconds The delay of the health check.
 * @property periodSeconds The interval at which the health check is performed.
 * @property tcpSocket The liveness check settings of the container. See `tcp_socket` below.
 * @property timeoutSeconds The timeout period of the health check.
 */
public data class ApplicationReadinessV2Args(
    public val exec: Output<ApplicationReadinessV2ExecArgs>? = null,
    public val httpGet: Output<ApplicationReadinessV2HttpGetArgs>? = null,
    public val initialDelaySeconds: Output<Int>? = null,
    public val periodSeconds: Output<Int>? = null,
    public val tcpSocket: Output<ApplicationReadinessV2TcpSocketArgs>? = null,
    public val timeoutSeconds: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sae.inputs.ApplicationReadinessV2Args> {
    override fun toJava(): com.pulumi.alicloud.sae.inputs.ApplicationReadinessV2Args =
        com.pulumi.alicloud.sae.inputs.ApplicationReadinessV2Args.builder()
            .exec(exec?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .httpGet(httpGet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .initialDelaySeconds(initialDelaySeconds?.applyValue({ args0 -> args0 }))
            .periodSeconds(periodSeconds?.applyValue({ args0 -> args0 }))
            .tcpSocket(tcpSocket?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .timeoutSeconds(timeoutSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationReadinessV2Args].
 */
@PulumiTagMarker
public class ApplicationReadinessV2ArgsBuilder internal constructor() {
    private var exec: Output<ApplicationReadinessV2ExecArgs>? = null

    private var httpGet: Output<ApplicationReadinessV2HttpGetArgs>? = null

    private var initialDelaySeconds: Output<Int>? = null

    private var periodSeconds: Output<Int>? = null

    private var tcpSocket: Output<ApplicationReadinessV2TcpSocketArgs>? = null

    private var timeoutSeconds: Output<Int>? = null

    /**
     * @param value Execute. See `exec` below.
     */
    @JvmName("ukmieivuwwwlorsd")
    public suspend fun exec(`value`: Output<ApplicationReadinessV2ExecArgs>) {
        this.exec = value
    }

    /**
     * @param value The liveness check settings of the container. See `http_get` below.
     */
    @JvmName("uqpnqgpigmvqsulo")
    public suspend fun httpGet(`value`: Output<ApplicationReadinessV2HttpGetArgs>) {
        this.httpGet = value
    }

    /**
     * @param value The delay of the health check.
     */
    @JvmName("ggfpjcfhrkbdtomm")
    public suspend fun initialDelaySeconds(`value`: Output<Int>) {
        this.initialDelaySeconds = value
    }

    /**
     * @param value The interval at which the health check is performed.
     */
    @JvmName("khixgoyltlikmnpu")
    public suspend fun periodSeconds(`value`: Output<Int>) {
        this.periodSeconds = value
    }

    /**
     * @param value The liveness check settings of the container. See `tcp_socket` below.
     */
    @JvmName("toqvobjsecrsrnpr")
    public suspend fun tcpSocket(`value`: Output<ApplicationReadinessV2TcpSocketArgs>) {
        this.tcpSocket = value
    }

    /**
     * @param value The timeout period of the health check.
     */
    @JvmName("iljnrmlhjerxvgvd")
    public suspend fun timeoutSeconds(`value`: Output<Int>) {
        this.timeoutSeconds = value
    }

    /**
     * @param value Execute. See `exec` below.
     */
    @JvmName("xxyuxdyxruhrtflg")
    public suspend fun exec(`value`: ApplicationReadinessV2ExecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exec = mapped
    }

    /**
     * @param argument Execute. See `exec` below.
     */
    @JvmName("wxogtntdkuwxcefh")
    public suspend fun exec(argument: suspend ApplicationReadinessV2ExecArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationReadinessV2ExecArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.exec = mapped
    }

    /**
     * @param value The liveness check settings of the container. See `http_get` below.
     */
    @JvmName("uvcuqiuyniinnyxr")
    public suspend fun httpGet(`value`: ApplicationReadinessV2HttpGetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpGet = mapped
    }

    /**
     * @param argument The liveness check settings of the container. See `http_get` below.
     */
    @JvmName("kbylefqdlutiajgp")
    public suspend fun httpGet(argument: suspend ApplicationReadinessV2HttpGetArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationReadinessV2HttpGetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.httpGet = mapped
    }

    /**
     * @param value The delay of the health check.
     */
    @JvmName("cwshoovpimucmfar")
    public suspend fun initialDelaySeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialDelaySeconds = mapped
    }

    /**
     * @param value The interval at which the health check is performed.
     */
    @JvmName("aqyyrmvkkdblwyfa")
    public suspend fun periodSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.periodSeconds = mapped
    }

    /**
     * @param value The liveness check settings of the container. See `tcp_socket` below.
     */
    @JvmName("lofdmexxlsyeruyu")
    public suspend fun tcpSocket(`value`: ApplicationReadinessV2TcpSocketArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tcpSocket = mapped
    }

    /**
     * @param argument The liveness check settings of the container. See `tcp_socket` below.
     */
    @JvmName("dvegffltnkjoymcr")
    public suspend fun tcpSocket(argument: suspend ApplicationReadinessV2TcpSocketArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationReadinessV2TcpSocketArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tcpSocket = mapped
    }

    /**
     * @param value The timeout period of the health check.
     */
    @JvmName("fxgsjokrobspfxyf")
    public suspend fun timeoutSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutSeconds = mapped
    }

    internal fun build(): ApplicationReadinessV2Args = ApplicationReadinessV2Args(
        exec = exec,
        httpGet = httpGet,
        initialDelaySeconds = initialDelaySeconds,
        periodSeconds = periodSeconds,
        tcpSocket = tcpSocket,
        timeoutSeconds = timeoutSeconds,
    )
}
