@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.inputs

import com.pulumi.alicloud.sae.inputs.ApplicationReadinessV2ExecArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property commands Mirror start command. The command must be an executable object in the container. For example: sleep. Setting this command will cause the original startup command of the mirror to become invalid.
 */
public data class ApplicationReadinessV2ExecArgs(
    public val commands: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sae.inputs.ApplicationReadinessV2ExecArgs> {
    override fun toJava(): com.pulumi.alicloud.sae.inputs.ApplicationReadinessV2ExecArgs =
        com.pulumi.alicloud.sae.inputs.ApplicationReadinessV2ExecArgs.builder()
            .commands(commands?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ApplicationReadinessV2ExecArgs].
 */
@PulumiTagMarker
public class ApplicationReadinessV2ExecArgsBuilder internal constructor() {
    private var commands: Output<List<String>>? = null

    /**
     * @param value Mirror start command. The command must be an executable object in the container. For example: sleep. Setting this command will cause the original startup command of the mirror to become invalid.
     */
    @JvmName("ovenxysahtyrfeea")
    public suspend fun commands(`value`: Output<List<String>>) {
        this.commands = value
    }

    @JvmName("tlkhmlfffuvkinao")
    public suspend fun commands(vararg values: Output<String>) {
        this.commands = Output.all(values.asList())
    }

    /**
     * @param values Mirror start command. The command must be an executable object in the container. For example: sleep. Setting this command will cause the original startup command of the mirror to become invalid.
     */
    @JvmName("tftpkrasawmbpmpk")
    public suspend fun commands(values: List<Output<String>>) {
        this.commands = Output.all(values)
    }

    /**
     * @param value Mirror start command. The command must be an executable object in the container. For example: sleep. Setting this command will cause the original startup command of the mirror to become invalid.
     */
    @JvmName("evnktemjfsurbrir")
    public suspend fun commands(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commands = mapped
    }

    /**
     * @param values Mirror start command. The command must be an executable object in the container. For example: sleep. Setting this command will cause the original startup command of the mirror to become invalid.
     */
    @JvmName("epocsgcgligfmpns")
    public suspend fun commands(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.commands = mapped
    }

    internal fun build(): ApplicationReadinessV2ExecArgs = ApplicationReadinessV2ExecArgs(
        commands = commands,
    )
}
