@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.inputs

import com.pulumi.alicloud.sae.inputs.ApplicationScalingRuleScalingRuleMetricArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property maxReplicas Maximum number of instances applied.
 * @property metrics Indicator rule configuration. See `metrics` below.
 * @property minReplicas Minimum number of instances applied.
 * @property scaleDownRules Apply shrink rules. See `scale_down_rules` below.
 * @property scaleUpRules Apply expansion rules. See `scale_up_rules` below.
 */
public data class ApplicationScalingRuleScalingRuleMetricArgs(
    public val maxReplicas: Output<Int>? = null,
    public val metrics: Output<List<ApplicationScalingRuleScalingRuleMetricMetricArgs>>? = null,
    public val minReplicas: Output<Int>? = null,
    public val scaleDownRules: Output<ApplicationScalingRuleScalingRuleMetricScaleDownRulesArgs>? =
        null,
    public val scaleUpRules: Output<ApplicationScalingRuleScalingRuleMetricScaleUpRulesArgs>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sae.inputs.ApplicationScalingRuleScalingRuleMetricArgs> {
    override fun toJava(): com.pulumi.alicloud.sae.inputs.ApplicationScalingRuleScalingRuleMetricArgs = com.pulumi.alicloud.sae.inputs.ApplicationScalingRuleScalingRuleMetricArgs.builder()
        .maxReplicas(maxReplicas?.applyValue({ args0 -> args0 }))
        .metrics(
            metrics?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .minReplicas(minReplicas?.applyValue({ args0 -> args0 }))
        .scaleDownRules(scaleDownRules?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .scaleUpRules(scaleUpRules?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ApplicationScalingRuleScalingRuleMetricArgs].
 */
@PulumiTagMarker
public class ApplicationScalingRuleScalingRuleMetricArgsBuilder internal constructor() {
    private var maxReplicas: Output<Int>? = null

    private var metrics: Output<List<ApplicationScalingRuleScalingRuleMetricMetricArgs>>? = null

    private var minReplicas: Output<Int>? = null

    private var scaleDownRules: Output<ApplicationScalingRuleScalingRuleMetricScaleDownRulesArgs>? =
        null

    private var scaleUpRules: Output<ApplicationScalingRuleScalingRuleMetricScaleUpRulesArgs>? = null

    /**
     * @param value Maximum number of instances applied.
     */
    @JvmName("xtgrlxlhlpwmofes")
    public suspend fun maxReplicas(`value`: Output<Int>) {
        this.maxReplicas = value
    }

    /**
     * @param value Indicator rule configuration. See `metrics` below.
     */
    @JvmName("ukrgptfmtubsuokv")
    public suspend fun metrics(`value`: Output<List<ApplicationScalingRuleScalingRuleMetricMetricArgs>>) {
        this.metrics = value
    }

    @JvmName("cpqfdglrsixnexcu")
    public suspend fun metrics(vararg values: Output<ApplicationScalingRuleScalingRuleMetricMetricArgs>) {
        this.metrics = Output.all(values.asList())
    }

    /**
     * @param values Indicator rule configuration. See `metrics` below.
     */
    @JvmName("deuohgvvtfywexkc")
    public suspend fun metrics(values: List<Output<ApplicationScalingRuleScalingRuleMetricMetricArgs>>) {
        this.metrics = Output.all(values)
    }

    /**
     * @param value Minimum number of instances applied.
     */
    @JvmName("mmthdtyqvddfsxye")
    public suspend fun minReplicas(`value`: Output<Int>) {
        this.minReplicas = value
    }

    /**
     * @param value Apply shrink rules. See `scale_down_rules` below.
     */
    @JvmName("rouvmpulaauxdxnw")
    public suspend fun scaleDownRules(`value`: Output<ApplicationScalingRuleScalingRuleMetricScaleDownRulesArgs>) {
        this.scaleDownRules = value
    }

    /**
     * @param value Apply expansion rules. See `scale_up_rules` below.
     */
    @JvmName("rxtpxpvvgeqabeyt")
    public suspend fun scaleUpRules(`value`: Output<ApplicationScalingRuleScalingRuleMetricScaleUpRulesArgs>) {
        this.scaleUpRules = value
    }

    /**
     * @param value Maximum number of instances applied.
     */
    @JvmName("blvjplpjkwhjioam")
    public suspend fun maxReplicas(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxReplicas = mapped
    }

    /**
     * @param value Indicator rule configuration. See `metrics` below.
     */
    @JvmName("fiqllylamdxicrmw")
    public suspend fun metrics(`value`: List<ApplicationScalingRuleScalingRuleMetricMetricArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metrics = mapped
    }

    /**
     * @param argument Indicator rule configuration. See `metrics` below.
     */
    @JvmName("dmpsdvaqlrsnrpoy")
    public suspend fun metrics(argument: List<suspend ApplicationScalingRuleScalingRuleMetricMetricArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationScalingRuleScalingRuleMetricMetricArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.metrics = mapped
    }

    /**
     * @param argument Indicator rule configuration. See `metrics` below.
     */
    @JvmName("bnwuqfsmjgaourly")
    public suspend fun metrics(vararg argument: suspend ApplicationScalingRuleScalingRuleMetricMetricArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ApplicationScalingRuleScalingRuleMetricMetricArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.metrics = mapped
    }

    /**
     * @param argument Indicator rule configuration. See `metrics` below.
     */
    @JvmName("rqdlptbgndxmvasr")
    public suspend fun metrics(argument: suspend ApplicationScalingRuleScalingRuleMetricMetricArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationScalingRuleScalingRuleMetricMetricArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.metrics = mapped
    }

    /**
     * @param values Indicator rule configuration. See `metrics` below.
     */
    @JvmName("haeyrrwmxtkvpkln")
    public suspend fun metrics(vararg values: ApplicationScalingRuleScalingRuleMetricMetricArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metrics = mapped
    }

    /**
     * @param value Minimum number of instances applied.
     */
    @JvmName("nbrwvxeteasnchqo")
    public suspend fun minReplicas(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minReplicas = mapped
    }

    /**
     * @param value Apply shrink rules. See `scale_down_rules` below.
     */
    @JvmName("oryegonvprljuhvo")
    public suspend fun scaleDownRules(`value`: ApplicationScalingRuleScalingRuleMetricScaleDownRulesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleDownRules = mapped
    }

    /**
     * @param argument Apply shrink rules. See `scale_down_rules` below.
     */
    @JvmName("xkkixfsibkdhulqc")
    public suspend fun scaleDownRules(argument: suspend ApplicationScalingRuleScalingRuleMetricScaleDownRulesArgsBuilder.() -> Unit) {
        val toBeMapped =
            ApplicationScalingRuleScalingRuleMetricScaleDownRulesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.scaleDownRules = mapped
    }

    /**
     * @param value Apply expansion rules. See `scale_up_rules` below.
     */
    @JvmName("ymfqmktunbdplahs")
    public suspend fun scaleUpRules(`value`: ApplicationScalingRuleScalingRuleMetricScaleUpRulesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleUpRules = mapped
    }

    /**
     * @param argument Apply expansion rules. See `scale_up_rules` below.
     */
    @JvmName("cyqyycbostmkjjmg")
    public suspend fun scaleUpRules(argument: suspend ApplicationScalingRuleScalingRuleMetricScaleUpRulesArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationScalingRuleScalingRuleMetricScaleUpRulesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.scaleUpRules = mapped
    }

    internal fun build(): ApplicationScalingRuleScalingRuleMetricArgs =
        ApplicationScalingRuleScalingRuleMetricArgs(
            maxReplicas = maxReplicas,
            metrics = metrics,
            minReplicas = minReplicas,
            scaleDownRules = scaleDownRules,
            scaleUpRules = scaleUpRules,
        )
}
