@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.inputs

import com.pulumi.alicloud.sae.inputs.ApplicationScalingRuleScalingRuleMetricMetricArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property metricTargetAverageUtilization According to different `metric_type`, set the target value of the corresponding monitoring index.
 * @property metricType Monitoring indicator trigger condition. Valid values: `CPU`, `MEMORY`, `tcpActiveConn`, `QPS`, `RT`, `SLB_QPS`, `SLB_RT`, `INTRANET_SLB_QPS` and `INTRANET_SLB_RT`. The values are described as follows:
 * - CPU: CPU usage.
 * - MEMORY: MEMORY usage.
 * - tcpActiveConn: The average number of TCP active connections for a single instance in 30 seconds.
 * - QPS: The average QPS of a single instance within 1 minute of JAVA application.
 * - RT: The average response time of all service interfaces within 1 minute of JAVA application.
 * - SLB_QPS: The average public network SLB QPS of a single instance within 15 seconds.
 * - SLB_RT: The average response time of public network SLB within 15 seconds.
 * - INTRANET_SLB_QPS: The average private network SLB QPS of a single instance within 15 seconds.
 * - INTRANET_SLB_RT: The average response time of private network SLB within 15 seconds.
 * **NOTE:** From version 1.206.0, `metric_type` can be set to `QPS`, `RT`, `INTRANET_SLB_QPS`, `INTRANET_SLB_RT`.
 * @property slbId SLB ID.
 * @property slbLogStore The log store of the Log Service.
 * @property slbProject The project of the Log Service.
 * @property vport SLB listening port.
 */
public data class ApplicationScalingRuleScalingRuleMetricMetricArgs(
    public val metricTargetAverageUtilization: Output<Int>? = null,
    public val metricType: Output<String>? = null,
    public val slbId: Output<String>? = null,
    public val slbLogStore: Output<String>? = null,
    public val slbProject: Output<String>? = null,
    public val vport: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.sae.inputs.ApplicationScalingRuleScalingRuleMetricMetricArgs> {
    override fun toJava(): com.pulumi.alicloud.sae.inputs.ApplicationScalingRuleScalingRuleMetricMetricArgs =
        com.pulumi.alicloud.sae.inputs.ApplicationScalingRuleScalingRuleMetricMetricArgs.builder()
            .metricTargetAverageUtilization(metricTargetAverageUtilization?.applyValue({ args0 -> args0 }))
            .metricType(metricType?.applyValue({ args0 -> args0 }))
            .slbId(slbId?.applyValue({ args0 -> args0 }))
            .slbLogStore(slbLogStore?.applyValue({ args0 -> args0 }))
            .slbProject(slbProject?.applyValue({ args0 -> args0 }))
            .vport(vport?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationScalingRuleScalingRuleMetricMetricArgs].
 */
@PulumiTagMarker
public class ApplicationScalingRuleScalingRuleMetricMetricArgsBuilder internal constructor() {
    private var metricTargetAverageUtilization: Output<Int>? = null

    private var metricType: Output<String>? = null

    private var slbId: Output<String>? = null

    private var slbLogStore: Output<String>? = null

    private var slbProject: Output<String>? = null

    private var vport: Output<String>? = null

    /**
     * @param value According to different `metric_type`, set the target value of the corresponding monitoring index.
     */
    @JvmName("vkfbmdoacswwlbvx")
    public suspend fun metricTargetAverageUtilization(`value`: Output<Int>) {
        this.metricTargetAverageUtilization = value
    }

    /**
     * @param value Monitoring indicator trigger condition. Valid values: `CPU`, `MEMORY`, `tcpActiveConn`, `QPS`, `RT`, `SLB_QPS`, `SLB_RT`, `INTRANET_SLB_QPS` and `INTRANET_SLB_RT`. The values are described as follows:
     * - CPU: CPU usage.
     * - MEMORY: MEMORY usage.
     * - tcpActiveConn: The average number of TCP active connections for a single instance in 30 seconds.
     * - QPS: The average QPS of a single instance within 1 minute of JAVA application.
     * - RT: The average response time of all service interfaces within 1 minute of JAVA application.
     * - SLB_QPS: The average public network SLB QPS of a single instance within 15 seconds.
     * - SLB_RT: The average response time of public network SLB within 15 seconds.
     * - INTRANET_SLB_QPS: The average private network SLB QPS of a single instance within 15 seconds.
     * - INTRANET_SLB_RT: The average response time of private network SLB within 15 seconds.
     * **NOTE:** From version 1.206.0, `metric_type` can be set to `QPS`, `RT`, `INTRANET_SLB_QPS`, `INTRANET_SLB_RT`.
     */
    @JvmName("toqogjwyhgeigwkv")
    public suspend fun metricType(`value`: Output<String>) {
        this.metricType = value
    }

    /**
     * @param value SLB ID.
     */
    @JvmName("iamnmkmorrjetegl")
    public suspend fun slbId(`value`: Output<String>) {
        this.slbId = value
    }

    /**
     * @param value The log store of the Log Service.
     */
    @JvmName("fbrelgrpfeirjwii")
    public suspend fun slbLogStore(`value`: Output<String>) {
        this.slbLogStore = value
    }

    /**
     * @param value The project of the Log Service.
     */
    @JvmName("qpckeredyegvomjg")
    public suspend fun slbProject(`value`: Output<String>) {
        this.slbProject = value
    }

    /**
     * @param value SLB listening port.
     */
    @JvmName("bjwrugltvbqvuasd")
    public suspend fun vport(`value`: Output<String>) {
        this.vport = value
    }

    /**
     * @param value According to different `metric_type`, set the target value of the corresponding monitoring index.
     */
    @JvmName("vpdwnghohfagsgpk")
    public suspend fun metricTargetAverageUtilization(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricTargetAverageUtilization = mapped
    }

    /**
     * @param value Monitoring indicator trigger condition. Valid values: `CPU`, `MEMORY`, `tcpActiveConn`, `QPS`, `RT`, `SLB_QPS`, `SLB_RT`, `INTRANET_SLB_QPS` and `INTRANET_SLB_RT`. The values are described as follows:
     * - CPU: CPU usage.
     * - MEMORY: MEMORY usage.
     * - tcpActiveConn: The average number of TCP active connections for a single instance in 30 seconds.
     * - QPS: The average QPS of a single instance within 1 minute of JAVA application.
     * - RT: The average response time of all service interfaces within 1 minute of JAVA application.
     * - SLB_QPS: The average public network SLB QPS of a single instance within 15 seconds.
     * - SLB_RT: The average response time of public network SLB within 15 seconds.
     * - INTRANET_SLB_QPS: The average private network SLB QPS of a single instance within 15 seconds.
     * - INTRANET_SLB_RT: The average response time of private network SLB within 15 seconds.
     * **NOTE:** From version 1.206.0, `metric_type` can be set to `QPS`, `RT`, `INTRANET_SLB_QPS`, `INTRANET_SLB_RT`.
     */
    @JvmName("yxxqdiwafcypjflp")
    public suspend fun metricType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricType = mapped
    }

    /**
     * @param value SLB ID.
     */
    @JvmName("wpctlgpnveoybjon")
    public suspend fun slbId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slbId = mapped
    }

    /**
     * @param value The log store of the Log Service.
     */
    @JvmName("awofwusnfaphhgcv")
    public suspend fun slbLogStore(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slbLogStore = mapped
    }

    /**
     * @param value The project of the Log Service.
     */
    @JvmName("fwgpyhtgmlvumafi")
    public suspend fun slbProject(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slbProject = mapped
    }

    /**
     * @param value SLB listening port.
     */
    @JvmName("hhbojwiskjebxsen")
    public suspend fun vport(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vport = mapped
    }

    internal fun build(): ApplicationScalingRuleScalingRuleMetricMetricArgs =
        ApplicationScalingRuleScalingRuleMetricMetricArgs(
            metricTargetAverageUtilization = metricTargetAverageUtilization,
            metricType = metricType,
            slbId = slbId,
            slbLogStore = slbLogStore,
            slbProject = slbProject,
            vport = vport,
        )
}
