@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.inputs

import com.pulumi.alicloud.sae.inputs.ApplicationScalingRuleScalingRuleMetricScaleUpRulesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property disabled Whether shrinkage is prohibited.
 * @property stabilizationWindowSeconds Cooling time for expansion or contraction. Valid values: `0` to `3600`. Unit: seconds. The default is `0` seconds.
 * @property step Elastic expansion or contraction step size. the maximum number of instances to be scaled in per unit time.
 */
public data class ApplicationScalingRuleScalingRuleMetricScaleUpRulesArgs(
    public val disabled: Output<Boolean>? = null,
    public val stabilizationWindowSeconds: Output<Int>? = null,
    public val step: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.sae.inputs.ApplicationScalingRuleScalingRuleMetricScaleUpRulesArgs> {
    override fun toJava(): com.pulumi.alicloud.sae.inputs.ApplicationScalingRuleScalingRuleMetricScaleUpRulesArgs =
        com.pulumi.alicloud.sae.inputs.ApplicationScalingRuleScalingRuleMetricScaleUpRulesArgs.builder()
            .disabled(disabled?.applyValue({ args0 -> args0 }))
            .stabilizationWindowSeconds(stabilizationWindowSeconds?.applyValue({ args0 -> args0 }))
            .step(step?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationScalingRuleScalingRuleMetricScaleUpRulesArgs].
 */
@PulumiTagMarker
public class ApplicationScalingRuleScalingRuleMetricScaleUpRulesArgsBuilder internal constructor() {
    private var disabled: Output<Boolean>? = null

    private var stabilizationWindowSeconds: Output<Int>? = null

    private var step: Output<Int>? = null

    /**
     * @param value Whether shrinkage is prohibited.
     */
    @JvmName("pkxlvbawxuadeecp")
    public suspend fun disabled(`value`: Output<Boolean>) {
        this.disabled = value
    }

    /**
     * @param value Cooling time for expansion or contraction. Valid values: `0` to `3600`. Unit: seconds. The default is `0` seconds.
     */
    @JvmName("ujlwdgheygblrndp")
    public suspend fun stabilizationWindowSeconds(`value`: Output<Int>) {
        this.stabilizationWindowSeconds = value
    }

    /**
     * @param value Elastic expansion or contraction step size. the maximum number of instances to be scaled in per unit time.
     */
    @JvmName("hjijwpvddsbckstx")
    public suspend fun step(`value`: Output<Int>) {
        this.step = value
    }

    /**
     * @param value Whether shrinkage is prohibited.
     */
    @JvmName("skrstxxhiwyheaux")
    public suspend fun disabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disabled = mapped
    }

    /**
     * @param value Cooling time for expansion or contraction. Valid values: `0` to `3600`. Unit: seconds. The default is `0` seconds.
     */
    @JvmName("bnhaymjydlxchoru")
    public suspend fun stabilizationWindowSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stabilizationWindowSeconds = mapped
    }

    /**
     * @param value Elastic expansion or contraction step size. the maximum number of instances to be scaled in per unit time.
     */
    @JvmName("pwoklvhmvwbybxot")
    public suspend fun step(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.step = mapped
    }

    internal fun build(): ApplicationScalingRuleScalingRuleMetricScaleUpRulesArgs =
        ApplicationScalingRuleScalingRuleMetricScaleUpRulesArgs(
            disabled = disabled,
            stabilizationWindowSeconds = stabilizationWindowSeconds,
            step = step,
        )
}
