@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.inputs

import com.pulumi.alicloud.sae.inputs.ApplicationScalingRuleScalingRuleTimerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property beginDate The Start date. When the `begin_date` and `end_date` values are empty. it indicates long-term execution and is the default value.
 * @property endDate The End Date. When the `begin_date` and `end_date` values are empty. it indicates long-term execution and is the default value.
 * @property period The period in which a timed elastic scaling strategy is executed.
 * @property schedules Resilient Scaling Strategy Trigger Timing. See `schedules` below.
 */
public data class ApplicationScalingRuleScalingRuleTimerArgs(
    public val beginDate: Output<String>? = null,
    public val endDate: Output<String>? = null,
    public val period: Output<String>? = null,
    public val schedules: Output<List<ApplicationScalingRuleScalingRuleTimerScheduleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.sae.inputs.ApplicationScalingRuleScalingRuleTimerArgs> {
    override fun toJava(): com.pulumi.alicloud.sae.inputs.ApplicationScalingRuleScalingRuleTimerArgs =
        com.pulumi.alicloud.sae.inputs.ApplicationScalingRuleScalingRuleTimerArgs.builder()
            .beginDate(beginDate?.applyValue({ args0 -> args0 }))
            .endDate(endDate?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .schedules(
                schedules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ApplicationScalingRuleScalingRuleTimerArgs].
 */
@PulumiTagMarker
public class ApplicationScalingRuleScalingRuleTimerArgsBuilder internal constructor() {
    private var beginDate: Output<String>? = null

    private var endDate: Output<String>? = null

    private var period: Output<String>? = null

    private var schedules: Output<List<ApplicationScalingRuleScalingRuleTimerScheduleArgs>>? = null

    /**
     * @param value The Start date. When the `begin_date` and `end_date` values are empty. it indicates long-term execution and is the default value.
     */
    @JvmName("efvpmqtauolwkxdk")
    public suspend fun beginDate(`value`: Output<String>) {
        this.beginDate = value
    }

    /**
     * @param value The End Date. When the `begin_date` and `end_date` values are empty. it indicates long-term execution and is the default value.
     */
    @JvmName("avmyssfmgkqslngt")
    public suspend fun endDate(`value`: Output<String>) {
        this.endDate = value
    }

    /**
     * @param value The period in which a timed elastic scaling strategy is executed.
     */
    @JvmName("vmjdivqgkawpiwjj")
    public suspend fun period(`value`: Output<String>) {
        this.period = value
    }

    /**
     * @param value Resilient Scaling Strategy Trigger Timing. See `schedules` below.
     */
    @JvmName("relkpmjncpkeyusd")
    public suspend fun schedules(`value`: Output<List<ApplicationScalingRuleScalingRuleTimerScheduleArgs>>) {
        this.schedules = value
    }

    @JvmName("bfainuaoriyrmfhw")
    public suspend fun schedules(vararg values: Output<ApplicationScalingRuleScalingRuleTimerScheduleArgs>) {
        this.schedules = Output.all(values.asList())
    }

    /**
     * @param values Resilient Scaling Strategy Trigger Timing. See `schedules` below.
     */
    @JvmName("acmtuxvmdmxmrvgd")
    public suspend fun schedules(values: List<Output<ApplicationScalingRuleScalingRuleTimerScheduleArgs>>) {
        this.schedules = Output.all(values)
    }

    /**
     * @param value The Start date. When the `begin_date` and `end_date` values are empty. it indicates long-term execution and is the default value.
     */
    @JvmName("jqqeyinrnkhkjpyh")
    public suspend fun beginDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.beginDate = mapped
    }

    /**
     * @param value The End Date. When the `begin_date` and `end_date` values are empty. it indicates long-term execution and is the default value.
     */
    @JvmName("uepjqqranytqmegh")
    public suspend fun endDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endDate = mapped
    }

    /**
     * @param value The period in which a timed elastic scaling strategy is executed.
     */
    @JvmName("ygookuoeqhrvwpnh")
    public suspend fun period(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value Resilient Scaling Strategy Trigger Timing. See `schedules` below.
     */
    @JvmName("tmyuckxbxxyrhiix")
    public suspend fun schedules(`value`: List<ApplicationScalingRuleScalingRuleTimerScheduleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedules = mapped
    }

    /**
     * @param argument Resilient Scaling Strategy Trigger Timing. See `schedules` below.
     */
    @JvmName("rooqkwlffladhqvj")
    public suspend fun schedules(argument: List<suspend ApplicationScalingRuleScalingRuleTimerScheduleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationScalingRuleScalingRuleTimerScheduleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.schedules = mapped
    }

    /**
     * @param argument Resilient Scaling Strategy Trigger Timing. See `schedules` below.
     */
    @JvmName("fmtfqqjnqocafqaw")
    public suspend fun schedules(vararg argument: suspend ApplicationScalingRuleScalingRuleTimerScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ApplicationScalingRuleScalingRuleTimerScheduleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.schedules = mapped
    }

    /**
     * @param argument Resilient Scaling Strategy Trigger Timing. See `schedules` below.
     */
    @JvmName("maagggghrbqkcngh")
    public suspend fun schedules(argument: suspend ApplicationScalingRuleScalingRuleTimerScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationScalingRuleScalingRuleTimerScheduleArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.schedules = mapped
    }

    /**
     * @param values Resilient Scaling Strategy Trigger Timing. See `schedules` below.
     */
    @JvmName("oulqsycjqjkvmhjp")
    public suspend fun schedules(vararg values: ApplicationScalingRuleScalingRuleTimerScheduleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schedules = mapped
    }

    internal fun build(): ApplicationScalingRuleScalingRuleTimerArgs =
        ApplicationScalingRuleScalingRuleTimerArgs(
            beginDate = beginDate,
            endDate = endDate,
            period = period,
            schedules = schedules,
        )
}
