@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.sae.kotlin.inputs

import com.pulumi.alicloud.sae.inputs.ApplicationScalingRuleScalingRuleTimerScheduleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property atTime Trigger point in time. When supporting format: minutes, for example: `08:00`.
 * @property maxReplicas
 * @property minReplicas
 * @property targetReplicas This parameter can specify the number of instances to be applied or the minimum number of surviving instances per deployment. value range [1,50]. > **NOTE:** The attribute is valid when the attribute `scaling_rule_type` is `timing`.
 */
public data class ApplicationScalingRuleScalingRuleTimerScheduleArgs(
    public val atTime: Output<String>? = null,
    public val maxReplicas: Output<Int>? = null,
    public val minReplicas: Output<Int>? = null,
    public val targetReplicas: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.sae.inputs.ApplicationScalingRuleScalingRuleTimerScheduleArgs> {
    override fun toJava(): com.pulumi.alicloud.sae.inputs.ApplicationScalingRuleScalingRuleTimerScheduleArgs =
        com.pulumi.alicloud.sae.inputs.ApplicationScalingRuleScalingRuleTimerScheduleArgs.builder()
            .atTime(atTime?.applyValue({ args0 -> args0 }))
            .maxReplicas(maxReplicas?.applyValue({ args0 -> args0 }))
            .minReplicas(minReplicas?.applyValue({ args0 -> args0 }))
            .targetReplicas(targetReplicas?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationScalingRuleScalingRuleTimerScheduleArgs].
 */
@PulumiTagMarker
public class ApplicationScalingRuleScalingRuleTimerScheduleArgsBuilder internal constructor() {
    private var atTime: Output<String>? = null

    private var maxReplicas: Output<Int>? = null

    private var minReplicas: Output<Int>? = null

    private var targetReplicas: Output<Int>? = null

    /**
     * @param value Trigger point in time. When supporting format: minutes, for example: `08:00`.
     */
    @JvmName("hvwwvwpyxqlhvkpt")
    public suspend fun atTime(`value`: Output<String>) {
        this.atTime = value
    }

    /**
     * @param value
     */
    @JvmName("rwksajmvsckcacmc")
    public suspend fun maxReplicas(`value`: Output<Int>) {
        this.maxReplicas = value
    }

    /**
     * @param value
     */
    @JvmName("kpnqgjkrtgnsbeap")
    public suspend fun minReplicas(`value`: Output<Int>) {
        this.minReplicas = value
    }

    /**
     * @param value This parameter can specify the number of instances to be applied or the minimum number of surviving instances per deployment. value range [1,50]. > **NOTE:** The attribute is valid when the attribute `scaling_rule_type` is `timing`.
     */
    @JvmName("etgwlawevkuhqhsf")
    public suspend fun targetReplicas(`value`: Output<Int>) {
        this.targetReplicas = value
    }

    /**
     * @param value Trigger point in time. When supporting format: minutes, for example: `08:00`.
     */
    @JvmName("dcudganakxefixfw")
    public suspend fun atTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.atTime = mapped
    }

    /**
     * @param value
     */
    @JvmName("tgtybdfblctvsxoh")
    public suspend fun maxReplicas(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxReplicas = mapped
    }

    /**
     * @param value
     */
    @JvmName("itrghvybifkaylew")
    public suspend fun minReplicas(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minReplicas = mapped
    }

    /**
     * @param value This parameter can specify the number of instances to be applied or the minimum number of surviving instances per deployment. value range [1,50]. > **NOTE:** The attribute is valid when the attribute `scaling_rule_type` is `timing`.
     */
    @JvmName("oooupeuxhhhimpjb")
    public suspend fun targetReplicas(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetReplicas = mapped
    }

    internal fun build(): ApplicationScalingRuleScalingRuleTimerScheduleArgs =
        ApplicationScalingRuleScalingRuleTimerScheduleArgs(
            atTime = atTime,
            maxReplicas = maxReplicas,
            minReplicas = minReplicas,
            targetReplicas = targetReplicas,
        )
}
